/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.CloudTrailDetails;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class CloudTrailDetailsMarshaller {
    private static final MarshallingInfo<String> ACCESSROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessRole").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<List> TRAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("trails").build();
    private static final CloudTrailDetailsMarshaller instance = new CloudTrailDetailsMarshaller();

    public static CloudTrailDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(CloudTrailDetails cloudTrailDetails, ProtocolMarshaller protocolMarshaller) {
        if (cloudTrailDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cloudTrailDetails.getAccessRole(), ACCESSROLE_BINDING);
            protocolMarshaller.marshall((Object)cloudTrailDetails.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)cloudTrailDetails.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall(cloudTrailDetails.getTrails(), TRAILS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

