/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.accessanalyzer.model.S3BucketConfiguration;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class S3BucketConfigurationMarshaller {
    private static final MarshallingInfo<Map> ACCESSPOINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessPoints").build();
    private static final MarshallingInfo<List> BUCKETACLGRANTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketAclGrants").build();
    private static final MarshallingInfo<String> BUCKETPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketPolicy").build();
    private static final MarshallingInfo<StructuredPojo> BUCKETPUBLICACCESSBLOCK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketPublicAccessBlock").build();
    private static final S3BucketConfigurationMarshaller instance = new S3BucketConfigurationMarshaller();

    public static S3BucketConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3BucketConfiguration s3BucketConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (s3BucketConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3BucketConfiguration.getAccessPoints(), ACCESSPOINTS_BINDING);
            protocolMarshaller.marshall(s3BucketConfiguration.getBucketAclGrants(), BUCKETACLGRANTS_BINDING);
            protocolMarshaller.marshall((Object)s3BucketConfiguration.getBucketPolicy(), BUCKETPOLICY_BINDING);
            protocolMarshaller.marshall((Object)s3BucketConfiguration.getBucketPublicAccessBlock(), BUCKETPUBLICACCESSBLOCK_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

