/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.accessanalyzer.model.KmsGrantConfiguration;
import com.amazonaws.services.accessanalyzer.model.transform.KmsKeyConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KmsKeyConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<KmsGrantConfiguration> grants;
    private Map<String, String> keyPolicies;

    public List<KmsGrantConfiguration> getGrants() {
        return this.grants;
    }

    public void setGrants(Collection<KmsGrantConfiguration> grants) {
        if (grants == null) {
            this.grants = null;
            return;
        }
        this.grants = new ArrayList<KmsGrantConfiguration>(grants);
    }

    public KmsKeyConfiguration withGrants(KmsGrantConfiguration ... grants) {
        if (this.grants == null) {
            this.setGrants(new ArrayList<KmsGrantConfiguration>(grants.length));
        }
        for (KmsGrantConfiguration ele : grants) {
            this.grants.add(ele);
        }
        return this;
    }

    public KmsKeyConfiguration withGrants(Collection<KmsGrantConfiguration> grants) {
        this.setGrants(grants);
        return this;
    }

    public Map<String, String> getKeyPolicies() {
        return this.keyPolicies;
    }

    public void setKeyPolicies(Map<String, String> keyPolicies) {
        this.keyPolicies = keyPolicies;
    }

    public KmsKeyConfiguration withKeyPolicies(Map<String, String> keyPolicies) {
        this.setKeyPolicies(keyPolicies);
        return this;
    }

    public KmsKeyConfiguration addKeyPoliciesEntry(String key, String value) {
        if (null == this.keyPolicies) {
            this.keyPolicies = new HashMap<String, String>();
        }
        if (this.keyPolicies.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.keyPolicies.put(key, value);
        return this;
    }

    public KmsKeyConfiguration clearKeyPoliciesEntries() {
        this.keyPolicies = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGrants() != null) {
            sb.append("Grants: ").append(this.getGrants()).append(",");
        }
        if (this.getKeyPolicies() != null) {
            sb.append("KeyPolicies: ").append(this.getKeyPolicies());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KmsKeyConfiguration)) {
            return false;
        }
        KmsKeyConfiguration other = (KmsKeyConfiguration)obj;
        if (other.getGrants() == null ^ this.getGrants() == null) {
            return false;
        }
        if (other.getGrants() != null && !other.getGrants().equals(this.getGrants())) {
            return false;
        }
        if (other.getKeyPolicies() == null ^ this.getKeyPolicies() == null) {
            return false;
        }
        return other.getKeyPolicies() == null || other.getKeyPolicies().equals(this.getKeyPolicies());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGrants() == null ? 0 : this.getGrants().hashCode());
        hashCode = 31 * hashCode + (this.getKeyPolicies() == null ? 0 : this.getKeyPolicies().hashCode());
        return hashCode;
    }

    public KmsKeyConfiguration clone() {
        try {
            return (KmsKeyConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KmsKeyConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

