/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import com.amazonaws.encryptionsdk.CommitmentPolicy;
import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import com.amazonaws.encryptionsdk.internal.BlockEncryptionHandler;
import com.amazonaws.encryptionsdk.internal.CipherHandler;
import com.amazonaws.encryptionsdk.internal.CryptoHandler;
import com.amazonaws.encryptionsdk.internal.EncryptionContextSerializer;
import com.amazonaws.encryptionsdk.internal.FrameEncryptionHandler;
import com.amazonaws.encryptionsdk.internal.MessageCryptoHandler;
import com.amazonaws.encryptionsdk.internal.ProcessingSummary;
import com.amazonaws.encryptionsdk.internal.TrailingSignatureAlgorithm;
import com.amazonaws.encryptionsdk.internal.Utils;
import com.amazonaws.encryptionsdk.model.CiphertextFooters;
import com.amazonaws.encryptionsdk.model.CiphertextHeaders;
import com.amazonaws.encryptionsdk.model.CiphertextType;
import com.amazonaws.encryptionsdk.model.ContentType;
import com.amazonaws.encryptionsdk.model.EncryptionMaterials;
import com.amazonaws.encryptionsdk.model.KeyBlob;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;

public class EncryptionHandler
implements MessageCryptoHandler {
    private static final CiphertextType CIPHERTEXT_TYPE = CiphertextType.CUSTOMER_AUTHENTICATED_ENCRYPTED_DATA;
    private final EncryptionMaterials encryptionMaterials_;
    private final Map<String, String> encryptionContext_;
    private final CryptoAlgorithm cryptoAlgo_;
    private final List<MasterKey> masterKeys_;
    private final List<KeyBlob> keyBlobs_;
    private final SecretKey encryptionKey_;
    private final byte version_;
    private final CiphertextType type_;
    private final byte nonceLen_;
    private final PrivateKey trailingSignaturePrivateKey_;
    private final MessageDigest trailingDigest_;
    private final Signature trailingSig_;
    private final CiphertextHeaders ciphertextHeaders_;
    private final byte[] ciphertextHeaderBytes_;
    private final CryptoHandler contentCryptoHandler_;
    private boolean firstOperation_ = true;
    private boolean complete_ = false;
    private long plaintextBytes_ = 0L;
    private long plaintextByteLimit_ = -1L;

    public EncryptionHandler(int frameSize, EncryptionMaterials result) throws AwsCryptoException {
        ContentType contentType;
        this.encryptionMaterials_ = result;
        this.encryptionContext_ = result.getEncryptionContext();
        this.cryptoAlgo_ = result.getAlgorithm();
        this.masterKeys_ = result.getMasterKeys();
        this.keyBlobs_ = result.getEncryptedDataKeys();
        this.trailingSignaturePrivateKey_ = result.getTrailingSignatureKey();
        if (this.keyBlobs_.isEmpty()) {
            throw new IllegalArgumentException("No encrypted data keys in materials result");
        }
        if (this.trailingSignaturePrivateKey_ != null) {
            try {
                TrailingSignatureAlgorithm algorithm = TrailingSignatureAlgorithm.forCryptoAlgorithm(this.cryptoAlgo_);
                this.trailingDigest_ = MessageDigest.getInstance(algorithm.getMessageDigestAlgorithm());
                this.trailingSig_ = Signature.getInstance(algorithm.getRawSignatureAlgorithm());
                this.trailingSig_.initSign(this.trailingSignaturePrivateKey_, Utils.getSecureRandom());
            }
            catch (GeneralSecurityException ex) {
                throw new AwsCryptoException(ex);
            }
        } else {
            this.trailingDigest_ = null;
            this.trailingSig_ = null;
        }
        this.version_ = this.cryptoAlgo_.getMessageFormatVersion();
        if (this.version_ != 1) {
            throw new AwsCryptoException("Configuration conflict. Cannot encrypt due to CommitmentPolicy " + (Object)((Object)CommitmentPolicy.ForbidEncryptAllowDecrypt) + " requiring only non-committed messages. Algorithm ID was " + (Object)((Object)this.cryptoAlgo_) + ". See: https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/troubleshooting-migration.html");
        }
        this.type_ = CIPHERTEXT_TYPE;
        this.nonceLen_ = this.cryptoAlgo_.getNonceLen();
        if (frameSize > 0) {
            contentType = ContentType.FRAME;
        } else if (frameSize == 0) {
            contentType = ContentType.SINGLEBLOCK;
        } else {
            throw Utils.cannotBeNegative("Frame size");
        }
        CiphertextHeaders unsignedHeaders = this.createCiphertextHeaders(contentType, frameSize);
        try {
            this.encryptionKey_ = this.cryptoAlgo_.getEncryptionKeyFromDataKey(result.getCleartextDataKey(), unsignedHeaders);
        }
        catch (InvalidKeyException ex) {
            throw new AwsCryptoException(ex);
        }
        this.ciphertextHeaders_ = this.signCiphertextHeaders(unsignedHeaders);
        this.ciphertextHeaderBytes_ = this.ciphertextHeaders_.toByteArray();
        byte[] messageId_ = this.ciphertextHeaders_.getMessageId();
        switch (contentType) {
            case FRAME: {
                this.contentCryptoHandler_ = new FrameEncryptionHandler(this.encryptionKey_, this.nonceLen_, this.cryptoAlgo_, messageId_, frameSize);
                break;
            }
            case SINGLEBLOCK: {
                this.contentCryptoHandler_ = new BlockEncryptionHandler(this.encryptionKey_, this.nonceLen_, this.cryptoAlgo_, messageId_);
                break;
            }
            default: {
                throw new AwsCryptoException("Unknown content type.");
            }
        }
    }

    @Override
    public ProcessingSummary processBytes(byte[] in, int off, int len, byte[] out, int outOff) throws AwsCryptoException, BadCiphertextException {
        if (len < 0 || off < 0) {
            throw new AwsCryptoException(String.format("Invalid values for input offset: %d and length: %d", off, len));
        }
        this.checkPlaintextSizeLimit(len);
        int actualOutLen = 0;
        if (this.firstOperation_) {
            System.arraycopy(this.ciphertextHeaderBytes_, 0, out, outOff, this.ciphertextHeaderBytes_.length);
            actualOutLen += this.ciphertextHeaderBytes_.length;
            this.firstOperation_ = false;
        }
        ProcessingSummary contentOut = this.contentCryptoHandler_.processBytes(in, off, len, out, outOff + actualOutLen);
        this.updateTrailingSignature(out, outOff, actualOutLen += contentOut.getBytesWritten());
        this.plaintextBytes_ += (long)contentOut.getBytesProcessed();
        return new ProcessingSummary(actualOutLen, contentOut.getBytesProcessed());
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws BadCiphertextException {
        if (this.complete_) {
            throw new IllegalStateException("Attempted to call doFinal twice");
        }
        this.complete_ = true;
        this.checkPlaintextSizeLimit(0L);
        int written = this.contentCryptoHandler_.doFinal(out, outOff);
        this.updateTrailingSignature(out, outOff, written);
        if (this.cryptoAlgo_.getTrailingSignatureLength() > 0) {
            try {
                CiphertextFooters footer = new CiphertextFooters(this.signContent());
                byte[] fBytes = footer.toByteArray();
                System.arraycopy(fBytes, 0, out, outOff + written, fBytes.length);
                return written + fBytes.length;
            }
            catch (SignatureException ex) {
                throw new AwsCryptoException(ex);
            }
        }
        return written;
    }

    private byte[] signContent() throws SignatureException {
        if (this.trailingDigest_ != null) {
            if (!this.trailingSig_.getAlgorithm().contains("ECDSA")) {
                throw new UnsupportedOperationException("Signatures calculated in pieces is only supported for ECDSA.");
            }
            byte[] digest = this.trailingDigest_.digest();
            return this.generateEcdsaFixedLengthSignature(digest);
        }
        return this.trailingSig_.sign();
    }

    private byte[] generateEcdsaFixedLengthSignature(byte[] digest) throws SignatureException {
        byte[] signature;
        do {
            this.trailingSig_.update(digest);
            signature = this.trailingSig_.sign();
            if (signature.length == this.cryptoAlgo_.getTrailingSignatureLength()) continue;
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)signature);
            ASN1Integer r = (ASN1Integer)seq.getObjectAt(0);
            ASN1Integer s = (ASN1Integer)seq.getObjectAt(1);
            ECPrivateKey ecKey = (ECPrivateKey)this.trailingSignaturePrivateKey_;
            s = new ASN1Integer(ecKey.getParams().getOrder().subtract(s.getPositiveValue()));
            seq = new DERSequence(new ASN1Encodable[]{r, s});
            try {
                signature = seq.getEncoded();
            }
            catch (IOException ex) {
                throw new SignatureException(ex);
            }
        } while (signature.length != this.cryptoAlgo_.getTrailingSignatureLength());
        return signature;
    }

    @Override
    public int estimateOutputSize(int inLen) {
        int outSize = 0;
        if (this.firstOperation_) {
            outSize += this.ciphertextHeaderBytes_.length;
        }
        outSize += this.contentCryptoHandler_.estimateOutputSize(inLen);
        if (this.cryptoAlgo_.getTrailingSignatureLength() > 0) {
            outSize += 2;
            outSize += this.cryptoAlgo_.getTrailingSignatureLength();
        }
        return outSize;
    }

    @Override
    public int estimatePartialOutputSize(int inLen) {
        int outSize = 0;
        if (this.firstOperation_) {
            outSize += this.ciphertextHeaderBytes_.length;
        }
        return outSize += this.contentCryptoHandler_.estimatePartialOutputSize(inLen);
    }

    @Override
    public int estimateFinalOutputSize() {
        return this.estimateOutputSize(0);
    }

    @Override
    public Map<String, String> getEncryptionContext() {
        return this.encryptionContext_;
    }

    @Override
    public CiphertextHeaders getHeaders() {
        return this.ciphertextHeaders_;
    }

    @Override
    public void setMaxInputLength(long size) {
        if (size < 0L) {
            throw Utils.cannotBeNegative("Max input length");
        }
        if (this.plaintextByteLimit_ == -1L || this.plaintextByteLimit_ > size) {
            this.plaintextByteLimit_ = size;
        }
        this.checkPlaintextSizeLimit(0L);
    }

    private void checkPlaintextSizeLimit(long additionalBytes) {
        if (this.plaintextByteLimit_ != -1L && this.plaintextBytes_ + additionalBytes > this.plaintextByteLimit_) {
            throw new IllegalStateException("Plaintext size exceeds max input size limit");
        }
    }

    private byte[] computeHeaderTag(byte[] nonce, byte[] aad) {
        CipherHandler cipherHandler = new CipherHandler(this.encryptionKey_, 1, this.cryptoAlgo_);
        return cipherHandler.cipherData(nonce, aad, new byte[0], 0, 0);
    }

    private CiphertextHeaders createCiphertextHeaders(ContentType contentType, int frameSize) {
        byte[] headerNonce = new byte[this.nonceLen_];
        byte[] encryptionContextBytes = EncryptionContextSerializer.serialize(this.encryptionContext_);
        CiphertextHeaders ciphertextHeaders = new CiphertextHeaders(this.type_, this.cryptoAlgo_, encryptionContextBytes, this.keyBlobs_, contentType, frameSize);
        ciphertextHeaders.setHeaderNonce(headerNonce);
        return ciphertextHeaders;
    }

    private CiphertextHeaders signCiphertextHeaders(CiphertextHeaders unsignedHeaders) {
        byte[] headerFields = unsignedHeaders.serializeAuthenticatedFields();
        byte[] headerTag = this.computeHeaderTag(unsignedHeaders.getHeaderNonce(), headerFields);
        unsignedHeaders.setHeaderTag(headerTag);
        return unsignedHeaders;
    }

    @Override
    public List<? extends MasterKey<?>> getMasterKeys() {
        return this.masterKeys_;
    }

    private void updateTrailingSignature(byte[] input, int offset, int len) {
        if (this.trailingDigest_ != null) {
            this.trailingDigest_.update(input, offset, len);
        } else if (this.trailingSig_ != null) {
            try {
                this.trailingSig_.update(input, offset, len);
            }
            catch (SignatureException ex) {
                throw new AwsCryptoException(ex);
            }
        }
    }

    @Override
    public boolean isComplete() {
        return this.complete_;
    }
}

