/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.internal.BouncyCastleConfiguration;
import com.amazonaws.encryptionsdk.internal.Utils;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECPoint;

public abstract class TrailingSignatureAlgorithm {
    private static final ECDSASignatureAlgorithm SHA256_ECDSA_P256 = new ECDSASignatureAlgorithm(ECNamedCurveTable.getParameterSpec((String)"secp256r1"), "SHA256");
    private static final ECDSASignatureAlgorithm SHA384_ECDSA_P384 = new ECDSASignatureAlgorithm(ECNamedCurveTable.getParameterSpec((String)"secp384r1"), "SHA384");

    private TrailingSignatureAlgorithm() {
    }

    public abstract String getMessageDigestAlgorithm();

    public abstract String getRawSignatureAlgorithm();

    public abstract String getHashAndSignAlgorithm();

    public abstract PublicKey deserializePublicKey(String var1);

    public abstract String serializePublicKey(PublicKey var1);

    public abstract KeyPair generateKey() throws GeneralSecurityException;

    public static TrailingSignatureAlgorithm forCryptoAlgorithm(CryptoAlgorithm algorithm) {
        switch (algorithm) {
            case ALG_AES_128_GCM_IV12_TAG16_HKDF_SHA256_ECDSA_P256: {
                return SHA256_ECDSA_P256;
            }
            case ALG_AES_192_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384: 
            case ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384: {
                return SHA384_ECDSA_P384;
            }
        }
        throw new IllegalStateException("Algorithm does not support trailing signature");
    }

    private static final class ECDSASignatureAlgorithm
    extends TrailingSignatureAlgorithm {
        private final ECNamedCurveParameterSpec ecSpec;
        private final String messageDigestAlgorithm;
        private final String hashAndSignAlgorithm;

        private ECDSASignatureAlgorithm(ECNamedCurveParameterSpec ecSpec, String messageDigestAlgorithm) {
            this.ecSpec = ecSpec;
            this.messageDigestAlgorithm = messageDigestAlgorithm;
            this.hashAndSignAlgorithm = messageDigestAlgorithm + "withECDSA";
        }

        public String toString() {
            return "ECDSASignatureAlgorithm(curve=" + this.ecSpec.getName() + ")";
        }

        @Override
        public String getMessageDigestAlgorithm() {
            return this.messageDigestAlgorithm;
        }

        @Override
        public String getRawSignatureAlgorithm() {
            return "NONEwithECDSA";
        }

        @Override
        public String getHashAndSignAlgorithm() {
            return this.hashAndSignAlgorithm;
        }

        @Override
        public PublicKey deserializePublicKey(String keyString) {
            ECPoint q = this.ecSpec.getCurve().decodePoint(Utils.decodeBase64String(keyString));
            ECPublicKeyParameters keyParams = new ECPublicKeyParameters(q, new ECDomainParameters(this.ecSpec.getCurve(), this.ecSpec.getG(), this.ecSpec.getN(), this.ecSpec.getH()));
            return new BCECPublicKey("EC", keyParams, (ECParameterSpec)this.ecSpec, BouncyCastleProvider.CONFIGURATION);
        }

        @Override
        public String serializePublicKey(PublicKey key) {
            return Utils.encodeBase64String(((ECPublicKey)key).getQ().getEncoded(true));
        }

        @Override
        public KeyPair generateKey() throws GeneralSecurityException {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC", (Provider)BouncyCastleConfiguration.INTERNAL_BOUNCY_CASTLE_PROVIDER);
            keyGen.initialize((AlgorithmParameterSpec)this.ecSpec, Utils.getSecureRandom());
            return keyGen.generateKeyPair();
        }
    }
}

