/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.kms;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.EncryptedDataKey;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.UnsupportedProviderException;
import com.amazonaws.encryptionsdk.kms.KmsMasterKeyProvider;
import com.amazonaws.encryptionsdk.kms.KmsMethods;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.services.kms.model.DecryptResult;
import com.amazonaws.services.kms.model.EncryptRequest;
import com.amazonaws.services.kms.model.EncryptResult;
import com.amazonaws.services.kms.model.GenerateDataKeyRequest;
import com.amazonaws.services.kms.model.GenerateDataKeyResult;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class KmsMasterKey
extends MasterKey<KmsMasterKey>
implements KmsMethods {
    private final AWSKMS kms_;
    private final MasterKeyProvider<KmsMasterKey> sourceProvider_;
    private final String id_;
    private final List<String> grantTokens_ = new ArrayList<String>();

    public static KmsMasterKey getInstance(AWSCredentials creds, String keyId) {
        return (KmsMasterKey)new KmsMasterKeyProvider(creds, keyId).getMasterKey(keyId);
    }

    public static KmsMasterKey getInstance(AWSCredentialsProvider creds, String keyId) {
        return (KmsMasterKey)new KmsMasterKeyProvider(creds, keyId).getMasterKey(keyId);
    }

    static KmsMasterKey getInstance(AWSKMS kms, String id, MasterKeyProvider<KmsMasterKey> provider) {
        return new KmsMasterKey(kms, id, provider);
    }

    private KmsMasterKey(AWSKMS kms, String id) {
        this.kms_ = kms;
        this.id_ = id;
        this.sourceProvider_ = this;
    }

    private KmsMasterKey(AWSKMS kms, String id, MasterKeyProvider<KmsMasterKey> provider) {
        this.kms_ = kms;
        this.id_ = id;
        this.sourceProvider_ = provider;
    }

    @Override
    public String getProviderId() {
        return this.sourceProvider_.getDefaultProviderId();
    }

    @Override
    public String getKeyId() {
        return this.id_;
    }

    @Override
    public DataKey<KmsMasterKey> generateDataKey(CryptoAlgorithm algorithm, Map<String, String> encryptionContext) {
        GenerateDataKeyResult gdkResult = this.kms_.generateDataKey(KmsMasterKey.appendUserAgent(new GenerateDataKeyRequest().withKeyId(this.getKeyId()).withNumberOfBytes(Integer.valueOf(algorithm.getDataKeyLength())).withEncryptionContext(encryptionContext).withGrantTokens(this.grantTokens_)));
        byte[] rawKey = new byte[algorithm.getDataKeyLength()];
        gdkResult.getPlaintext().get(rawKey);
        if (gdkResult.getPlaintext().remaining() > 0) {
            throw new IllegalStateException("Recieved an unexpected number of bytes from KMS");
        }
        byte[] encryptedKey = new byte[gdkResult.getCiphertextBlob().remaining()];
        gdkResult.getCiphertextBlob().get(encryptedKey);
        SecretKeySpec key = new SecretKeySpec(rawKey, algorithm.getDataKeyAlgo());
        return new DataKey<KmsMasterKey>(key, encryptedKey, gdkResult.getKeyId().getBytes(StandardCharsets.UTF_8), this);
    }

    @Override
    public void setGrantTokens(List<String> grantTokens) {
        this.grantTokens_.clear();
        this.grantTokens_.addAll(grantTokens);
    }

    @Override
    public List<String> getGrantTokens() {
        return this.grantTokens_;
    }

    @Override
    public void addGrantToken(String grantToken) {
        this.grantTokens_.add(grantToken);
    }

    @Override
    public DataKey<KmsMasterKey> encryptDataKey(CryptoAlgorithm algorithm, Map<String, String> encryptionContext, DataKey<?> dataKey) {
        SecretKey key = dataKey.getKey();
        if (!key.getFormat().equals("RAW")) {
            throw new IllegalArgumentException("Only RAW encoded keys are supported");
        }
        try {
            EncryptResult encryptResult = this.kms_.encrypt(KmsMasterKey.appendUserAgent(new EncryptRequest().withKeyId(this.id_).withPlaintext(ByteBuffer.wrap(key.getEncoded())).withEncryptionContext(encryptionContext).withGrantTokens(this.grantTokens_)));
            byte[] edk = new byte[encryptResult.getCiphertextBlob().remaining()];
            encryptResult.getCiphertextBlob().get(edk);
            return new DataKey<KmsMasterKey>(dataKey.getKey(), edk, encryptResult.getKeyId().getBytes(StandardCharsets.UTF_8), this);
        }
        catch (AmazonServiceException asex) {
            throw new AwsCryptoException(asex);
        }
    }

    @Override
    public DataKey<KmsMasterKey> decryptDataKey(CryptoAlgorithm algorithm, Collection<? extends EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext) throws UnsupportedProviderException, AwsCryptoException {
        ArrayList<AmazonServiceException> exceptions = new ArrayList<AmazonServiceException>();
        for (EncryptedDataKey encryptedDataKey : encryptedDataKeys) {
            try {
                DecryptResult decryptResult = this.kms_.decrypt(KmsMasterKey.appendUserAgent(new DecryptRequest().withCiphertextBlob(ByteBuffer.wrap(encryptedDataKey.getEncryptedDataKey())).withEncryptionContext(encryptionContext).withGrantTokens(this.grantTokens_)));
                if (!decryptResult.getKeyId().equals(this.id_)) continue;
                byte[] rawKey = new byte[algorithm.getDataKeyLength()];
                decryptResult.getPlaintext().get(rawKey);
                if (decryptResult.getPlaintext().remaining() > 0) {
                    throw new IllegalStateException("Received an unexpected number of bytes from KMS");
                }
                return new DataKey<KmsMasterKey>(new SecretKeySpec(rawKey, algorithm.getDataKeyAlgo()), encryptedDataKey.getEncryptedDataKey(), encryptedDataKey.getProviderInformation(), this);
            }
            catch (AmazonServiceException awsex) {
                exceptions.add(awsex);
            }
        }
        throw this.buildCannotDecryptDksException(exceptions);
    }

    private static <R extends AmazonWebServiceRequest> R appendUserAgent(R request) {
        request.getRequestClientOptions().appendUserAgent("AwsCrypto/1.1.0.0");
        return request;
    }
}

