/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import com.amazonaws.encryptionsdk.internal.BlockEncryptionHandler;
import com.amazonaws.encryptionsdk.internal.CipherHandler;
import com.amazonaws.encryptionsdk.internal.CryptoHandler;
import com.amazonaws.encryptionsdk.internal.EncryptionContextSerializer;
import com.amazonaws.encryptionsdk.internal.FrameEncryptionHandler;
import com.amazonaws.encryptionsdk.internal.MessageCryptoHandler;
import com.amazonaws.encryptionsdk.internal.ProcessingSummary;
import com.amazonaws.encryptionsdk.internal.Utils;
import com.amazonaws.encryptionsdk.model.CiphertextFooters;
import com.amazonaws.encryptionsdk.model.CiphertextHeaders;
import com.amazonaws.encryptionsdk.model.CiphertextType;
import com.amazonaws.encryptionsdk.model.ContentType;
import com.amazonaws.encryptionsdk.model.KeyBlob;
import com.amazonaws.util.Base64;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;

public class EncryptionHandler<K extends MasterKey<K>>
implements MessageCryptoHandler<K> {
    private static final SecureRandom RND = new SecureRandom();
    private static final CiphertextType CIPHERTEXT_TYPE = CiphertextType.CUSTOMER_AUTHENTICATED_ENCRYPTED_DATA;
    private final Map<String, String> encryptionContext_;
    private final CryptoAlgorithm cryptoAlgo_;
    private final DataKey<K> dataKey_;
    private final List<K> masterKeys_;
    private final List<KeyBlob> keyBlobs_;
    private final SecretKey encryptionKey_;
    private final byte version_;
    private final CiphertextType type_;
    private final byte nonceLen_;
    private final byte[] messageId_;
    private final KeyPair trailingKeys_;
    private final Signature trailingSig_;
    private final CiphertextHeaders ciphertextHeaders_;
    private final byte[] ciphertextHeaderBytes_;
    private final CryptoHandler contentCryptoHandler_;
    private boolean firstOperation_ = true;
    private boolean complete_ = false;

    public EncryptionHandler(List<K> masterKeys, Map<String, String> encryptionContext, CryptoAlgorithm cryptoAlgorithm, int frameSize) throws AwsCryptoException {
        ContentType contentType;
        Utils.assertNonNull(masterKeys, "customerMasterKey");
        this.cryptoAlgo_ = Utils.assertNonNull(cryptoAlgorithm, "cryptoAlgorithm");
        this.encryptionContext_ = new HashMap<String, String>(Utils.assertNonNull(encryptionContext, "encryptionContext"));
        if (this.cryptoAlgo_.getTrailingSignatureLength() > 0) {
            try {
                this.trailingKeys_ = this.generateTrailingSigKeyPair();
                if (this.encryptionContext_.containsKey("aws-crypto-public-key")) {
                    throw new IllegalArgumentException("EncryptionContext contains reserved field aws-crypto-public-key");
                }
                this.encryptionContext_.put("aws-crypto-public-key", this.serializeTrailingKeyForEc());
                this.trailingSig_ = Signature.getInstance(this.cryptoAlgo_.getTrailingSignatureAlgo());
                this.trailingSig_.initSign(this.trailingKeys_.getPrivate(), RND);
            }
            catch (GeneralSecurityException ex) {
                throw new AwsCryptoException(ex);
            }
        } else {
            this.trailingKeys_ = null;
            this.trailingSig_ = null;
        }
        this.version_ = 1;
        this.type_ = CIPHERTEXT_TYPE;
        this.nonceLen_ = this.cryptoAlgo_.getNonceLen();
        if (masterKeys.isEmpty()) {
            throw new IllegalArgumentException("No master keys provided");
        }
        this.masterKeys_ = Collections.unmodifiableList(masterKeys);
        this.dataKey_ = ((MasterKey)masterKeys.get(0)).generateDataKey(cryptoAlgorithm, this.encryptionContext_);
        this.keyBlobs_ = new ArrayList<KeyBlob>(masterKeys.size());
        this.keyBlobs_.add(new KeyBlob(this.dataKey_));
        for (int x = 1; x < masterKeys.size(); ++x) {
            this.keyBlobs_.add(new KeyBlob(((MasterKey)masterKeys.get(x)).encryptDataKey(this.cryptoAlgo_, this.encryptionContext_, this.dataKey_)));
        }
        if (frameSize > 0) {
            contentType = ContentType.FRAME;
        } else if (frameSize == 0) {
            contentType = ContentType.SINGLEBLOCK;
        } else {
            throw new AwsCryptoException("Frame size cannot be negative");
        }
        CiphertextHeaders unsignedHeaders = this.createCiphertextHeaders(contentType, frameSize);
        try {
            this.encryptionKey_ = this.cryptoAlgo_.getEncryptionKeyFromDataKey(this.dataKey_.getKey(), unsignedHeaders);
        }
        catch (InvalidKeyException ex) {
            throw new AwsCryptoException(ex);
        }
        this.ciphertextHeaders_ = this.signCiphertextHeaders(unsignedHeaders);
        this.ciphertextHeaderBytes_ = this.ciphertextHeaders_.toByteArray();
        this.messageId_ = this.ciphertextHeaders_.getMessageId();
        switch (contentType) {
            case FRAME: {
                this.contentCryptoHandler_ = new FrameEncryptionHandler(this.encryptionKey_, this.nonceLen_, this.cryptoAlgo_, this.messageId_, frameSize);
                break;
            }
            case SINGLEBLOCK: {
                this.contentCryptoHandler_ = new BlockEncryptionHandler(this.encryptionKey_, this.nonceLen_, this.cryptoAlgo_, this.messageId_);
                break;
            }
            default: {
                throw new AwsCryptoException("Unknown content type.");
            }
        }
    }

    @Override
    public ProcessingSummary processBytes(byte[] in, int off, int len, byte[] out, int outOff) throws AwsCryptoException, BadCiphertextException {
        if (len < 0 || off < 0) {
            throw new AwsCryptoException(String.format("Invalid values for input offset: %d and length: %d", off, len));
        }
        int actualOutLen = 0;
        if (this.firstOperation_) {
            System.arraycopy(this.ciphertextHeaderBytes_, 0, out, outOff, this.ciphertextHeaderBytes_.length);
            actualOutLen += this.ciphertextHeaderBytes_.length;
            this.firstOperation_ = false;
        }
        ProcessingSummary contentOut = this.contentCryptoHandler_.processBytes(in, off, len, out, outOff + actualOutLen);
        this.updateTrailingSignature(out, outOff, actualOutLen += contentOut.getBytesWritten());
        return new ProcessingSummary(actualOutLen, contentOut.getBytesProcessed());
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws BadCiphertextException {
        this.complete_ = true;
        int written = this.contentCryptoHandler_.doFinal(out, outOff);
        this.updateTrailingSignature(out, outOff, written);
        if (this.cryptoAlgo_.getTrailingSignatureLength() > 0) {
            try {
                CiphertextFooters footer = new CiphertextFooters(this.trailingSig_.sign());
                byte[] fBytes = footer.toByteArray();
                System.arraycopy(fBytes, 0, out, outOff + written, fBytes.length);
                return written + fBytes.length;
            }
            catch (SignatureException ex) {
                throw new AwsCryptoException(ex);
            }
        }
        return written;
    }

    @Override
    public int estimateOutputSize(int inLen) {
        int outSize = 0;
        if (this.firstOperation_) {
            outSize += this.ciphertextHeaderBytes_.length;
        }
        outSize += this.contentCryptoHandler_.estimateOutputSize(inLen);
        if (this.cryptoAlgo_.getTrailingSignatureLength() > 0) {
            outSize += 2;
            outSize += this.cryptoAlgo_.getTrailingSignatureLength();
        }
        return outSize;
    }

    @Override
    public Map<String, String> getEncryptionContext() {
        return this.encryptionContext_;
    }

    @Override
    public CiphertextHeaders getHeaders() {
        return this.ciphertextHeaders_;
    }

    private byte[] computeHeaderTag(byte[] nonce, byte[] aad) {
        CipherHandler cipherHandler = new CipherHandler(this.encryptionKey_, nonce, aad, 1, this.cryptoAlgo_);
        return cipherHandler.cipherData(new byte[0], 0, 0);
    }

    private CiphertextHeaders createCiphertextHeaders(ContentType contentType, int frameSize) {
        byte[] headerNonce = new byte[this.nonceLen_];
        RND.nextBytes(headerNonce);
        byte[] encryptionContextBytes = EncryptionContextSerializer.serialize(this.encryptionContext_);
        CiphertextHeaders ciphertextHeaders = new CiphertextHeaders(this.version_, this.type_, this.cryptoAlgo_, encryptionContextBytes, this.keyBlobs_, contentType, frameSize);
        ciphertextHeaders.setHeaderNonce(headerNonce);
        return ciphertextHeaders;
    }

    private CiphertextHeaders signCiphertextHeaders(CiphertextHeaders unsignedHeaders) {
        byte[] headerFields = unsignedHeaders.serializeAuthenticatedFields();
        byte[] headerTag = this.computeHeaderTag(unsignedHeaders.getHeaderNonce(), headerFields);
        unsignedHeaders.setHeaderTag(headerTag);
        return unsignedHeaders;
    }

    @Override
    public List<K> getMasterKeys() {
        return this.masterKeys_;
    }

    private KeyPair generateTrailingSigKeyPair() throws GeneralSecurityException {
        ECNamedCurveParameterSpec ecSpec;
        switch (this.cryptoAlgo_) {
            case ALG_AES_128_GCM_IV12_TAG16_HKDF_SHA256_ECDSA_P256: {
                ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
                break;
            }
            case ALG_AES_192_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384: 
            case ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384: {
                ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp384r1");
                break;
            }
            default: {
                throw new IllegalStateException("Algorithm does not support trailing signature");
            }
        }
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("ECDSA", "BC");
        keyGen.initialize((AlgorithmParameterSpec)ecSpec, RND);
        return keyGen.generateKeyPair();
    }

    private String serializeTrailingKeyForEc() {
        switch (this.cryptoAlgo_) {
            case ALG_AES_128_GCM_IV12_TAG16_HKDF_SHA256_ECDSA_P256: 
            case ALG_AES_192_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384: 
            case ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384: {
                ECPublicKey ecPub = (ECPublicKey)this.trailingKeys_.getPublic();
                return Base64.encodeAsString((byte[])ecPub.getQ().getEncoded(true));
            }
        }
        throw new IllegalStateException("Algorithm does not support trailing signature");
    }

    private void updateTrailingSignature(byte[] input, int offset, int len) {
        if (this.trailingSig_ != null) {
            try {
                this.trailingSig_.update(input, offset, len);
            }
            catch (SignatureException ex) {
                throw new AwsCryptoException(ex);
            }
        }
    }

    @Override
    public boolean isComplete() {
        return this.complete_;
    }
}

