/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class EncryptionContextSerializer {
    private EncryptionContextSerializer() {
    }

    public static byte[] serialize(Map<String, String> encryptionContext) {
        if (encryptionContext == null) {
            return null;
        }
        if (encryptionContext.size() == 0) {
            return new byte[0];
        }
        if ((encryptionContext = Collections.unmodifiableMap(encryptionContext)).size() > Short.MAX_VALUE) {
            throw new AwsCryptoException("The number of entries in encryption context exceeds the allowed maximum 32767");
        }
        ByteBuffer result = ByteBuffer.allocate(Short.MAX_VALUE);
        result.order(ByteOrder.BIG_ENDIAN);
        result.putShort((short)encryptionContext.size());
        try {
            CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
            encoder.onMalformedInput(CodingErrorAction.REPORT);
            encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            TreeMap<ByteBuffer, ByteBuffer> binaryEntries = new TreeMap<ByteBuffer, ByteBuffer>();
            for (Map.Entry<String, String> entry : encryptionContext.entrySet()) {
                ByteBuffer valueBytes;
                if (entry.getKey() == null || entry.getValue() == null) {
                    throw new AwsCryptoException("All keys and values in excryption context must be non-null.");
                }
                if (entry.getKey().isEmpty() || entry.getValue().isEmpty()) {
                    throw new AwsCryptoException("All keys and values in excryption context must be non-empty.");
                }
                ByteBuffer keyBytes = encoder.encode(CharBuffer.wrap(entry.getKey()));
                if (binaryEntries.put(keyBytes, valueBytes = encoder.encode(CharBuffer.wrap(entry.getValue()))) != null) {
                    throw new AwsCryptoException("Encryption context contains duplicate entries.");
                }
                if (keyBytes.limit() <= Short.MAX_VALUE && valueBytes.limit() <= Short.MAX_VALUE) continue;
                throw new AwsCryptoException("All keys and values in excryption context must be shorter than 32767");
            }
            for (Map.Entry<String, String> entry : binaryEntries.entrySet()) {
                result.putShort((short)((ByteBuffer)((Object)entry.getKey())).limit());
                result.put((ByteBuffer)((Object)entry.getKey()));
                result.putShort((short)((ByteBuffer)((Object)entry.getValue())).limit());
                result.put((ByteBuffer)((Object)entry.getValue()));
            }
            result.flip();
            byte[] encryptionContextBytes = new byte[result.limit()];
            result.get(encryptionContextBytes);
            return encryptionContextBytes;
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("Encryption context contains an invalid unicode character");
        }
        catch (BufferOverflowException e) {
            throw new AwsCryptoException("The number of bytes in encryption context exceeds the allowed maximum 32767", e);
        }
    }

    public static Map<String, String> deserialize(byte[] b) {
        try {
            if (b == null) {
                return null;
            }
            if (b.length == 0) {
                return Collections.emptyMap();
            }
            ByteBuffer encryptionContextBytes = ByteBuffer.wrap(b);
            int entryCount = encryptionContextBytes.getShort();
            if (entryCount <= 0 || entryCount > Short.MAX_VALUE) {
                throw new AwsCryptoException("The number of entries in encryption context must be greater than 0 and smaller than 32767");
            }
            CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            HashMap<String, String> result = new HashMap<String, String>(entryCount);
            for (int i = 0; i < entryCount; ++i) {
                short keyLen = encryptionContextBytes.getShort();
                if (keyLen <= 0 || keyLen > Short.MAX_VALUE) {
                    throw new AwsCryptoException("Key length must be greater than 0 and smaller than 32767");
                }
                ByteBuffer keyBytes = encryptionContextBytes.slice();
                keyBytes.limit(keyLen);
                encryptionContextBytes.position(encryptionContextBytes.position() + keyLen);
                short valueLen = encryptionContextBytes.getShort();
                if (valueLen <= 0 || valueLen > Short.MAX_VALUE) {
                    throw new AwsCryptoException("Value length must be greater than 0 and smaller than 32767");
                }
                ByteBuffer valueBytes = encryptionContextBytes.slice();
                valueBytes.limit(valueLen);
                encryptionContextBytes.position(encryptionContextBytes.position() + valueLen);
                CharBuffer keyChars = decoder.decode(keyBytes);
                CharBuffer valueChars = decoder.decode(valueBytes);
                if (result.put(keyChars.toString(), valueChars.toString()) == null) continue;
                throw new AwsCryptoException("Encryption context contains duplicate entries.");
            }
            return result;
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("Encryption context contains an invalid unicode character");
        }
        catch (BufferUnderflowException e) {
            throw new AwsCryptoException("Invalid encryption context. Expected more bytes.", e);
        }
    }
}

