/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.CryptoInputStream;
import com.amazonaws.encryptionsdk.CryptoOutputStream;
import com.amazonaws.encryptionsdk.CryptoResult;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.MasterKeyRequest;
import com.amazonaws.encryptionsdk.ParsedCiphertext;
import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import com.amazonaws.encryptionsdk.internal.DecryptionHandler;
import com.amazonaws.encryptionsdk.internal.EncryptionHandler;
import com.amazonaws.encryptionsdk.internal.ProcessingSummary;
import com.amazonaws.encryptionsdk.internal.Utils;
import com.amazonaws.util.Base64;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AwsCrypto {
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private CryptoAlgorithm encryptionAlgorithm_ = AwsCrypto.getDefaultCryptoAlgorithm();
    private int encryptionFrameSize_ = AwsCrypto.getDefaultFrameSize();

    public static CryptoAlgorithm getDefaultCryptoAlgorithm() {
        return CryptoAlgorithm.ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384;
    }

    public static int getDefaultFrameSize() {
        return 4096;
    }

    public void setEncryptionAlgorithm(CryptoAlgorithm alg) {
        this.encryptionAlgorithm_ = alg;
    }

    public CryptoAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm_;
    }

    public void setEncryptionFrameSize(int frameSize) {
        if (frameSize < 0 || frameSize % this.encryptionAlgorithm_.getBlockSize() != 0) {
            throw new IllegalArgumentException("frameSize must be a non-negative multiple of the block size");
        }
        this.encryptionFrameSize_ = frameSize;
    }

    public int getEncryptionFrameSize() {
        return this.encryptionFrameSize_;
    }

    public <K extends MasterKey<K>> long estimateCiphertextSize(MasterKeyProvider<K> provider, int plaintextSize, Map<String, String> encryptionContext) {
        MasterKeyRequest keyRequest = MasterKeyRequest.newBuilder().setEncryptionContext(encryptionContext).setStreaming(true).build();
        List<K> mks = Utils.assertNonNull(provider, "provider").getMasterKeysForEncryption(keyRequest);
        EncryptionHandler<K> cryptoHandler = new EncryptionHandler<K>(mks, encryptionContext, this.getEncryptionAlgorithm(), this.getEncryptionFrameSize());
        return cryptoHandler.estimateOutputSize(plaintextSize);
    }

    public <K extends MasterKey<K>> long estimateCiphertextSize(MasterKeyProvider<K> provider, int plaintextSize) {
        return this.estimateCiphertextSize(provider, plaintextSize, EMPTY_MAP);
    }

    public <K extends MasterKey<K>> CryptoResult<byte[], K> encryptData(MasterKeyProvider<K> provider, byte[] plaintext, Map<String, String> encryptionContext) {
        MasterKeyRequest keyRequest = MasterKeyRequest.newBuilder().setEncryptionContext(encryptionContext).setPlaintext(plaintext).build();
        List<K> mks = Utils.assertNonNull(provider, "provider").getMasterKeysForEncryption(keyRequest);
        EncryptionHandler<K> cryptoHandler = new EncryptionHandler<K>(mks, encryptionContext, this.getEncryptionAlgorithm(), this.getEncryptionFrameSize());
        int outSizeEstimate = cryptoHandler.estimateOutputSize(plaintext.length);
        byte[] out = new byte[outSizeEstimate];
        int outLen = cryptoHandler.processBytes(plaintext, 0, plaintext.length, out, 0).getBytesWritten();
        outLen += cryptoHandler.doFinal(out, outLen);
        byte[] outBytes = Utils.truncate(out, outLen);
        return new CryptoResult(outBytes, cryptoHandler.getMasterKeys(), cryptoHandler.getHeaders());
    }

    public <K extends MasterKey<K>> CryptoResult<byte[], K> encryptData(MasterKeyProvider<K> provider, byte[] plaintext) {
        return this.encryptData(provider, plaintext, EMPTY_MAP);
    }

    public <K extends MasterKey<K>> CryptoResult<String, K> encryptString(MasterKeyProvider<K> provider, String plaintext, Map<String, String> encryptionContext) {
        CryptoResult<byte[], K> ctBytes = this.encryptData(provider, plaintext.getBytes(StandardCharsets.UTF_8), encryptionContext);
        return new CryptoResult<String, K>(Base64.encodeAsString((byte[])ctBytes.getResult()), ctBytes.getMasterKeys(), ctBytes.getHeaders());
    }

    public <K extends MasterKey<K>> CryptoResult<String, K> encryptString(MasterKeyProvider<K> provider, String plaintext) {
        return this.encryptString(provider, plaintext, EMPTY_MAP);
    }

    public <K extends MasterKey<K>> CryptoResult<byte[], K> decryptData(MasterKeyProvider<K> provider, byte[] ciphertext) {
        return this.decryptData(Utils.assertNonNull(provider, "provider"), new ParsedCiphertext(ciphertext));
    }

    public <K extends MasterKey<K>> CryptoResult<byte[], K> decryptData(MasterKeyProvider<K> provider, ParsedCiphertext ciphertext) {
        DecryptionHandler<K> cryptoHandler = new DecryptionHandler<K>(provider, ciphertext);
        byte[] ciphertextBytes = ciphertext.getCiphertext();
        int contentLen = ciphertextBytes.length - ciphertext.getOffset();
        int outSizeEstimate = cryptoHandler.estimateOutputSize(contentLen);
        byte[] out = new byte[outSizeEstimate];
        ProcessingSummary processed = cryptoHandler.processBytes(ciphertextBytes, ciphertext.getOffset(), contentLen, out, 0);
        if (processed.getBytesProcessed() != contentLen) {
            throw new BadCiphertextException("Unable to process entire ciphertext. May have trailing data.");
        }
        int outLen = processed.getBytesWritten();
        outLen += cryptoHandler.doFinal(out, outLen);
        byte[] outBytes = Utils.truncate(out, outLen);
        return new CryptoResult(outBytes, cryptoHandler.getMasterKeys(), cryptoHandler.getHeaders());
    }

    public <K extends MasterKey<K>> CryptoResult<String, K> decryptString(MasterKeyProvider<K> provider, String ciphertext) {
        byte[] ciphertextBytes;
        Utils.assertNonNull(provider, "provider");
        try {
            ciphertextBytes = Base64.decode((String)Utils.assertNonNull(ciphertext, "ciphertext"));
        }
        catch (IllegalArgumentException ex) {
            throw new BadCiphertextException("Invalid base 64", ex);
        }
        CryptoResult<byte[], K> ptBytes = this.decryptData(provider, ciphertextBytes);
        return new CryptoResult<String, K>(new String(ptBytes.getResult(), StandardCharsets.UTF_8), ptBytes.getMasterKeys(), ptBytes.getHeaders());
    }

    public <K extends MasterKey<K>> CryptoOutputStream<K> createEncryptingStream(MasterKeyProvider<K> provider, OutputStream os, Map<String, String> encryptionContext) {
        MasterKeyRequest keyRequest = MasterKeyRequest.newBuilder().setEncryptionContext(encryptionContext).setStreaming(true).build();
        List<K> mks = Utils.assertNonNull(provider, "provider").getMasterKeysForEncryption(keyRequest);
        EncryptionHandler<K> cryptoHandler = new EncryptionHandler<K>(mks, encryptionContext, this.getEncryptionAlgorithm(), this.getEncryptionFrameSize());
        return new CryptoOutputStream<K>(os, cryptoHandler);
    }

    public <K extends MasterKey<K>> CryptoOutputStream<K> createEncryptingStream(MasterKeyProvider<K> provider, OutputStream os) {
        return this.createEncryptingStream(provider, os, EMPTY_MAP);
    }

    public <K extends MasterKey<K>> CryptoInputStream<K> createEncryptingStream(MasterKeyProvider<K> provider, InputStream is, Map<String, String> encryptionContext) {
        MasterKeyRequest keyRequest = MasterKeyRequest.newBuilder().setEncryptionContext(encryptionContext).setStreaming(true).build();
        List<K> mks = Utils.assertNonNull(provider, "provider").getMasterKeysForEncryption(keyRequest);
        EncryptionHandler<K> cryptoHandler = new EncryptionHandler<K>(mks, encryptionContext, this.getEncryptionAlgorithm(), this.getEncryptionFrameSize());
        return new CryptoInputStream<K>(is, cryptoHandler);
    }

    public <K extends MasterKey<K>> CryptoInputStream<K> createEncryptingStream(MasterKeyProvider<K> provider, InputStream is) {
        return this.createEncryptingStream(provider, is, EMPTY_MAP);
    }

    public <K extends MasterKey<K>> CryptoOutputStream<K> createDecryptingStream(MasterKeyProvider<K> provider, OutputStream os) {
        DecryptionHandler<K> cryptoHandler = new DecryptionHandler<K>(provider);
        return new CryptoOutputStream<K>(os, cryptoHandler);
    }

    public <K extends MasterKey<K>> CryptoInputStream<K> createDecryptingStream(MasterKeyProvider<K> provider, InputStream is) {
        DecryptionHandler<K> cryptoHandler = new DecryptionHandler<K>(provider);
        return new CryptoInputStream<K>(is, cryptoHandler);
    }
}

