/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.internal;

import com.amazonaws.annotation.ThreadSafe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

@ThreadSafe
public final class LRUCache<T> {
    private final Map<String, T> map;
    private final RemovalListener<T> listener;
    private final int maxSize;

    public LRUCache(int maxSize, RemovalListener<T> listener) {
        if (maxSize < 1) {
            throw new IllegalArgumentException("maxSize " + maxSize + " must be at least 1");
        }
        this.maxSize = maxSize;
        this.listener = listener;
        this.map = Collections.synchronizedMap(new LRUHashMap(maxSize, listener));
    }

    public LRUCache(int maxSize) {
        this(maxSize, null);
    }

    public T add(String key, T value) {
        return this.map.put(key, value);
    }

    public T get(String key) {
        return this.map.get(key);
    }

    public int size() {
        return this.map.size();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.listener != null) {
            ArrayList<Map.Entry<String, T>> removedEntries = new ArrayList<Map.Entry<String, T>>();
            Map<String, T> map = this.map;
            synchronized (map) {
                Iterator<Map.Entry<String, T>> iterator = this.map.entrySet().iterator();
                while (iterator.hasNext()) {
                    removedEntries.add(iterator.next());
                    iterator.remove();
                }
            }
            for (Map.Entry entry : removedEntries) {
                this.listener.onRemoval(entry);
            }
        } else {
            this.map.clear();
        }
    }

    public String toString() {
        return this.map.toString();
    }

    public static interface RemovalListener<T> {
        public void onRemoval(Map.Entry<String, T> var1);
    }

    private static class LRUHashMap<T>
    extends LinkedHashMap<String, T> {
        private final int maxSize;
        private final RemovalListener<T> listener;

        private LRUHashMap(int maxSize, RemovalListener<T> listener) {
            super(10, 0.75f, true);
            this.maxSize = maxSize;
            this.listener = listener;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, T> eldest) {
            if (this.size() > this.maxSize) {
                if (this.listener != null) {
                    this.listener.onRemoval(eldest);
                }
                return true;
            }
            return false;
        }
    }
}

