/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.EncryptionContext;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.DecryptionMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.EncryptionMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.SymmetricRawMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.EncryptionMaterialsProvider;
import com.amazonaws.services.dynamodbv2.datamodeling.internal.Hkdf;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.services.kms.model.DecryptResult;
import com.amazonaws.services.kms.model.GenerateDataKeyRequest;
import com.amazonaws.services.kms.model.GenerateDataKeyResult;
import com.amazonaws.util.Base64;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.VersionInfoUtils;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class DirectKmsMaterialProvider
implements EncryptionMaterialsProvider {
    private static final String VERSION_STRING = "1.0";
    private static final String USER_AGENT = DirectKmsMaterialProvider.class.getName() + "/" + "1.0" + "/" + VersionInfoUtils.getVersion();
    private static final String COVERED_ATTR_CTX_KEY = "aws-kms-ec-attr";
    private static final String SIGNING_KEY_ALGORITHM = "amzn-ddb-sig-alg";
    private static final String TABLE_NAME_EC_KEY = "*aws-kms-table*";
    private static final String DEFAULT_ENC_ALG = "AES/256";
    private static final String DEFAULT_SIG_ALG = "HmacSHA256/256";
    private static final String KEY_COVERAGE = "*keys*";
    private static final String KDF_ALG = "HmacSHA256";
    private static final String KDF_SIG_INFO = "Signing";
    private static final String KDF_ENC_INFO = "Encryption";
    private final AWSKMS kms;
    private final String encryptionKeyId;
    private final Map<String, String> description;
    private final String dataKeyAlg;
    private final int dataKeyLength;
    private final String dataKeyDesc;
    private final String sigKeyAlg;
    private final int sigKeyLength;
    private final String sigKeyDesc;

    public DirectKmsMaterialProvider(AWSKMS kms) {
        this(kms, null);
    }

    public DirectKmsMaterialProvider(AWSKMS kms, String encryptionKeyId, Map<String, String> materialDescription) {
        this.kms = kms;
        this.encryptionKeyId = encryptionKeyId;
        this.description = materialDescription != null ? Collections.unmodifiableMap(new HashMap<String, String>(materialDescription)) : Collections.emptyMap();
        this.dataKeyDesc = this.description.containsKey("amzn-ddb-env-alg") ? this.description.get("amzn-ddb-env-alg") : DEFAULT_ENC_ALG;
        String[] parts = this.dataKeyDesc.split("/", 2);
        this.dataKeyAlg = parts[0];
        this.dataKeyLength = parts.length == 2 ? Integer.parseInt(parts[1]) : 256;
        this.sigKeyDesc = this.description.containsKey(SIGNING_KEY_ALGORITHM) ? this.description.get(SIGNING_KEY_ALGORITHM) : DEFAULT_SIG_ALG;
        parts = this.sigKeyDesc.split("/", 2);
        this.sigKeyAlg = parts[0];
        this.sigKeyLength = parts.length == 2 ? Integer.parseInt(parts[1]) : 256;
    }

    public DirectKmsMaterialProvider(AWSKMS kms, String encryptionKeyId) {
        this(kms, encryptionKeyId, Collections.emptyMap());
    }

    @Override
    public DecryptionMaterials getDecryptionMaterials(EncryptionContext context) {
        Hkdf kdf;
        Map<String, String> materialDescription = context.getMaterialDescription();
        HashMap<String, String> ec = new HashMap<String, String>();
        String providedEncAlg = materialDescription.get("amzn-ddb-env-alg");
        String providedSigAlg = materialDescription.get(SIGNING_KEY_ALGORITHM);
        ec.put("*amzn-ddb-env-alg*", providedEncAlg);
        ec.put("*amzn-ddb-sig-alg*", providedSigAlg);
        DirectKmsMaterialProvider.populateKmsEcFromEc(context, ec);
        DecryptRequest request = DirectKmsMaterialProvider.appendUserAgent(new DecryptRequest());
        request.setCiphertextBlob(ByteBuffer.wrap(Base64.decode((String)materialDescription.get("amzn-ddb-env-key"))));
        request.setEncryptionContext(ec);
        DecryptResult decryptResult = this.kms.decrypt(request);
        this.validateEncryptionKeyId(decryptResult.getKeyId(), context);
        try {
            kdf = Hkdf.getInstance(KDF_ALG);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DynamoDBMappingException((Throwable)e);
        }
        kdf.init(DirectKmsMaterialProvider.toArray(decryptResult.getPlaintext()));
        String[] encAlgParts = providedEncAlg.split("/", 2);
        int encLength = encAlgParts.length == 2 ? Integer.parseInt(encAlgParts[1]) : 256;
        String[] sigAlgParts = providedSigAlg.split("/", 2);
        int sigLength = sigAlgParts.length == 2 ? Integer.parseInt(sigAlgParts[1]) : 256;
        SecretKeySpec encryptionKey = new SecretKeySpec(kdf.deriveKey(KDF_ENC_INFO, encLength / 8), encAlgParts[0]);
        SecretKeySpec macKey = new SecretKeySpec(kdf.deriveKey(KDF_SIG_INFO, sigLength / 8), sigAlgParts[0]);
        return new SymmetricRawMaterials((SecretKey)encryptionKey, macKey, materialDescription);
    }

    @Override
    public EncryptionMaterials getEncryptionMaterials(EncryptionContext context) {
        Hkdf kdf;
        HashMap<String, String> ec = new HashMap<String, String>();
        ec.put("*amzn-ddb-env-alg*", this.dataKeyDesc);
        ec.put("*amzn-ddb-sig-alg*", this.sigKeyDesc);
        DirectKmsMaterialProvider.populateKmsEcFromEc(context, ec);
        String keyId = this.selectEncryptionKeyId(context);
        if (StringUtils.isNullOrEmpty((String)keyId)) {
            throw new DynamoDBMappingException("Encryption key id is empty.");
        }
        GenerateDataKeyRequest req = DirectKmsMaterialProvider.appendUserAgent(new GenerateDataKeyRequest());
        req.setKeyId(keyId);
        req.setNumberOfBytes(Integer.valueOf(32));
        req.setEncryptionContext(ec);
        GenerateDataKeyResult dataKeyResult = this.kms.generateDataKey(req);
        HashMap<String, String> materialDescription = new HashMap<String, String>();
        materialDescription.putAll(this.description);
        materialDescription.put(COVERED_ATTR_CTX_KEY, KEY_COVERAGE);
        materialDescription.put("amzn-ddb-wrap-alg", "kms");
        materialDescription.put("amzn-ddb-env-alg", this.dataKeyDesc);
        materialDescription.put(SIGNING_KEY_ALGORITHM, this.sigKeyDesc);
        materialDescription.put("amzn-ddb-env-key", Base64.encodeAsString((byte[])DirectKmsMaterialProvider.toArray(dataKeyResult.getCiphertextBlob())));
        try {
            kdf = Hkdf.getInstance(KDF_ALG);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DynamoDBMappingException((Throwable)e);
        }
        kdf.init(DirectKmsMaterialProvider.toArray(dataKeyResult.getPlaintext()));
        SecretKeySpec encryptionKey = new SecretKeySpec(kdf.deriveKey(KDF_ENC_INFO, this.dataKeyLength / 8), this.dataKeyAlg);
        SecretKeySpec signatureKey = new SecretKeySpec(kdf.deriveKey(KDF_SIG_INFO, this.sigKeyLength / 8), this.sigKeyAlg);
        return new SymmetricRawMaterials((SecretKey)encryptionKey, signatureKey, materialDescription);
    }

    protected String getEncryptionKeyId() {
        return this.encryptionKeyId;
    }

    protected String selectEncryptionKeyId(EncryptionContext context) throws DynamoDBMappingException {
        return this.getEncryptionKeyId();
    }

    protected void validateEncryptionKeyId(String encryptionKeyId, EncryptionContext context) throws DynamoDBMappingException {
    }

    private static void populateKmsEcFromEc(EncryptionContext context, Map<String, String> kmsEc) {
        String tableName;
        String rangeKeyName;
        String hashKeyName = context.getHashKeyName();
        if (hashKeyName != null) {
            AttributeValue hashKey = context.getAttributeValues().get(hashKeyName);
            if (hashKey.getN() != null) {
                kmsEc.put(hashKeyName, hashKey.getN());
            } else if (hashKey.getS() != null) {
                kmsEc.put(hashKeyName, hashKey.getS());
            } else if (hashKey.getB() != null) {
                kmsEc.put(hashKeyName, Base64.encodeAsString((byte[])DirectKmsMaterialProvider.toArray(hashKey.getB())));
            } else {
                throw new UnsupportedOperationException("DirectKmsMaterialProvider only supports String, Number, and Binary HashKeys");
            }
        }
        if ((rangeKeyName = context.getRangeKeyName()) != null) {
            AttributeValue rangeKey = context.getAttributeValues().get(rangeKeyName);
            if (rangeKey.getN() != null) {
                kmsEc.put(rangeKeyName, rangeKey.getN());
            } else if (rangeKey.getS() != null) {
                kmsEc.put(rangeKeyName, rangeKey.getS());
            } else if (rangeKey.getB() != null) {
                kmsEc.put(rangeKeyName, Base64.encodeAsString((byte[])DirectKmsMaterialProvider.toArray(rangeKey.getB())));
            } else {
                throw new UnsupportedOperationException("DirectKmsMaterialProvider only supports String, Number, and Binary RangeKeys");
            }
        }
        if ((tableName = context.getTableName()) != null) {
            kmsEc.put(TABLE_NAME_EC_KEY, tableName);
        }
    }

    private static byte[] toArray(ByteBuffer buff) {
        ByteBuffer dup = buff.asReadOnlyBuffer();
        byte[] result = new byte[dup.remaining()];
        dup.get(result);
        return result;
    }

    private static <X extends AmazonWebServiceRequest> X appendUserAgent(X request) {
        request.getRequestClientOptions().appendUserAgent(USER_AGENT);
        return request;
    }

    @Override
    public void refresh() {
    }
}

