/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.AttributeTransformer;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingsRegistry;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.DoNotEncrypt;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.DoNotTouch;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.DynamoDBEncryptor;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.EncryptionContext;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.EncryptionFlags;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.HandleUnknownAttributes;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.TableAadOverride;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.EncryptionMaterialsProvider;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AttributeEncryptor
implements AttributeTransformer {
    private static final Log LOG = LogFactory.getLog(AttributeEncryptor.class);
    private final DynamoDBEncryptor encryptor;
    private final Map<Class<?>, ModelClassMetadata> metadataCache = new ConcurrentHashMap();

    public AttributeEncryptor(DynamoDBEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public AttributeEncryptor(EncryptionMaterialsProvider encryptionMaterialsProvider) {
        this.encryptor = DynamoDBEncryptor.getInstance(encryptionMaterialsProvider);
    }

    public DynamoDBEncryptor getEncryptor() {
        return this.encryptor;
    }

    public Map<String, AttributeValue> transform(AttributeTransformer.Parameters<?> parameters) {
        ModelClassMetadata metadata = this.getModelClassMetadata(parameters);
        Map attributeValues = parameters.getAttributeValues();
        if (metadata.doNotTouch) {
            return attributeValues;
        }
        if (parameters.isPartialUpdate()) {
            LOG.error((Object)("Use of AttributeEncryptor without SaveBehavior.CLOBBER is an error and can result in data-corruption. This occured while trying to save " + parameters.getModelClass()));
        }
        try {
            return this.encryptor.encryptRecord(attributeValues, metadata.getEncryptionFlags(), AttributeEncryptor.paramsToContext(parameters));
        }
        catch (Exception ex) {
            throw new DynamoDBMappingException((Throwable)ex);
        }
    }

    public Map<String, AttributeValue> untransform(AttributeTransformer.Parameters<?> parameters) {
        Map<String, Set<EncryptionFlags>> attributeFlags = this.getEncryptionFlags(parameters);
        try {
            return this.encryptor.decryptRecord(parameters.getAttributeValues(), attributeFlags, AttributeEncryptor.paramsToContext(parameters));
        }
        catch (Exception ex) {
            throw new DynamoDBMappingException((Throwable)ex);
        }
    }

    private Map<String, Set<EncryptionFlags>> getEncryptionFlags(AttributeTransformer.Parameters<?> parameters) {
        ModelClassMetadata metadata = this.getModelClassMetadata(parameters);
        if (metadata.getDoNotTouch()) {
            return metadata.getEncryptionFlags();
        }
        Set<EncryptionFlags> unknownAttributeBehavior = metadata.getUnknownAttributeBehavior();
        HashMap<String, Set<EncryptionFlags>> attributeFlags = new HashMap<String, Set<EncryptionFlags>>();
        attributeFlags.putAll(metadata.getEncryptionFlags());
        for (String attributeName : parameters.getAttributeValues().keySet()) {
            if (attributeFlags.containsKey(attributeName) || this.encryptor.getSignatureFieldName().equals(attributeName) || this.encryptor.getMaterialDescriptionFieldName().equals(attributeName)) continue;
            attributeFlags.put(attributeName, unknownAttributeBehavior);
        }
        return attributeFlags;
    }

    private <T> ModelClassMetadata getModelClassMetadata(AttributeTransformer.Parameters<T> parameters) {
        Class clazz = parameters.getModelClass();
        ModelClassMetadata metadata = this.metadataCache.get(clazz);
        if (metadata == null) {
            HashMap<String, Set<EncryptionFlags>> attributeFlags = new HashMap<String, Set<EncryptionFlags>>();
            boolean handleUnknownAttributes = this.handleUnknownAttributes(clazz);
            EnumSet<EncryptionFlags> unknownAttributeBehavior = EnumSet.noneOf(EncryptionFlags.class);
            if (this.shouldTouch(clazz)) {
                DynamoDBMappingsRegistry.Mappings mappings = DynamoDBMappingsRegistry.instance().mappingsOf(clazz);
                for (DynamoDBMappingsRegistry.Mapping mapping : mappings.getMappings()) {
                    EnumSet<EncryptionFlags> flags = EnumSet.noneOf(EncryptionFlags.class);
                    if (this.shouldTouch(mapping)) {
                        if (this.shouldEncryptAttribute(clazz, mapping)) {
                            flags.add(EncryptionFlags.ENCRYPT);
                        }
                        flags.add(EncryptionFlags.SIGN);
                    }
                    attributeFlags.put(mapping.getAttributeName(), Collections.unmodifiableSet(flags));
                }
                if (handleUnknownAttributes) {
                    unknownAttributeBehavior.add(EncryptionFlags.SIGN);
                    if (this.shouldEncrypt(clazz)) {
                        unknownAttributeBehavior.add(EncryptionFlags.ENCRYPT);
                    }
                }
            }
            metadata = new ModelClassMetadata(Collections.unmodifiableMap(attributeFlags), this.doNotTouch(clazz), Collections.unmodifiableSet(unknownAttributeBehavior));
            this.metadataCache.put(clazz, metadata);
        }
        return metadata;
    }

    private boolean shouldTouch(Class<?> clazz) {
        return !this.doNotTouch(clazz);
    }

    private boolean shouldTouch(DynamoDBMappingsRegistry.Mapping mapping) {
        return !this.doNotTouch(mapping);
    }

    private boolean doNotTouch(Class<?> clazz) {
        return clazz.isAnnotationPresent(DoNotTouch.class);
    }

    private boolean doNotTouch(DynamoDBMappingsRegistry.Mapping mapping) {
        return mapping.getter().isAnnotationPresent(DoNotTouch.class);
    }

    private boolean shouldEncrypt(Class<?> clazz) {
        return !this.doNotEncrypt(clazz);
    }

    private boolean doNotEncrypt(Class<?> clazz) {
        return clazz.isAnnotationPresent(DoNotEncrypt.class);
    }

    private boolean doNotEncrypt(DynamoDBMappingsRegistry.Mapping mapping) {
        return mapping.getter().isAnnotationPresent(DoNotEncrypt.class);
    }

    private boolean shouldEncryptAttribute(Class<?> clazz, DynamoDBMappingsRegistry.Mapping mapping) {
        return !this.doNotEncrypt(clazz) && !this.doNotEncrypt(mapping) && !mapping.isPrimaryKey() && !mapping.isVersion();
    }

    private static EncryptionContext paramsToContext(AttributeTransformer.Parameters<?> params) {
        Class clazz = params.getModelClass();
        TableAadOverride override = clazz.getAnnotation(TableAadOverride.class);
        String tableName = override == null ? params.getTableName() : override.tableName();
        return new EncryptionContext.Builder().withHashKeyName(params.getHashKeyName()).withRangeKeyName(params.getRangeKeyName()).withTableName(tableName).withModeledClass(params.getModelClass()).withAttributeValues(params.getAttributeValues()).build();
    }

    private boolean handleUnknownAttributes(Class<?> clazz) {
        return clazz.getAnnotation(HandleUnknownAttributes.class) != null;
    }

    private static class ModelClassMetadata {
        private final Map<String, Set<EncryptionFlags>> encryptionFlags;
        private final boolean doNotTouch;
        private final Set<EncryptionFlags> unknownAttributeBehavior;

        public ModelClassMetadata(Map<String, Set<EncryptionFlags>> encryptionFlags, boolean doNotTouch, Set<EncryptionFlags> unknownAttributeBehavior) {
            this.encryptionFlags = encryptionFlags;
            this.doNotTouch = doNotTouch;
            this.unknownAttributeBehavior = unknownAttributeBehavior;
        }

        public Map<String, Set<EncryptionFlags>> getEncryptionFlags() {
            return this.encryptionFlags;
        }

        public boolean getDoNotTouch() {
            return this.doNotTouch;
        }

        public Set<EncryptionFlags> getUnknownAttributeBehavior() {
            return this.unknownAttributeBehavior;
        }
    }
}

