/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferNetworkLossHandler;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferRecord;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferStatusUpdater;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferThreadPool;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtility;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtilityException;
import com.amazonaws.mobileconnectors.s3.transferutility.UploadPartTask;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.ObjectTagging;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.Tag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.util.Mimetypes;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class UploadTask
implements Callable<Boolean> {
    private static final Log LOGGER = LogFactory.getLog(UploadTask.class);
    private static final String OBJECT_TAGS_DELIMITER = "&";
    private static final String OBJECT_TAG_KEY_VALUE_SEPARATOR = "=";
    private static final String REQUESTER_PAYS = "requester";
    private final AmazonS3 s3;
    private final TransferRecord upload;
    private final TransferDBUtil dbUtil;
    private final TransferStatusUpdater updater;
    Map<Integer, UploadPartTaskMetadata> uploadPartTasks;
    private List<UploadPartRequest> requestList;
    private static final Map<String, CannedAccessControlList> CANNED_ACL_MAP = new HashMap<String, CannedAccessControlList>();

    public UploadTask(TransferRecord uploadInfo, AmazonS3 s3, TransferDBUtil dbUtil, TransferStatusUpdater updater) {
        this.upload = uploadInfo;
        this.s3 = s3;
        this.dbUtil = dbUtil;
        this.updater = updater;
        this.uploadPartTasks = new HashMap<Integer, UploadPartTaskMetadata>();
    }

    @Override
    public Boolean call() throws Exception {
        try {
            if (TransferNetworkLossHandler.getInstance() != null && !TransferNetworkLossHandler.getInstance().isNetworkConnected()) {
                LOGGER.info((Object)"Network not connected. Setting the state to WAITING_FOR_NETWORK.");
                this.updater.updateState(this.upload.id, TransferState.WAITING_FOR_NETWORK);
                return false;
            }
        }
        catch (TransferUtilityException transferUtilityException) {
            LOGGER.error((Object)("TransferUtilityException: [" + transferUtilityException + "]"));
        }
        this.updater.updateState(this.upload.id, TransferState.IN_PROGRESS);
        if (this.upload.isMultipart == 1 && this.upload.partNumber == 0) {
            return this.uploadMultipartAndWaitForCompletion();
        }
        if (this.upload.isMultipart == 0) {
            return this.uploadSinglePartAndWaitForCompletion();
        }
        return false;
    }

    private Boolean uploadMultipartAndWaitForCompletion() throws ExecutionException {
        block22: {
            long bytesAlreadyTransferred = 0L;
            if (this.upload.multipartId == null || this.upload.multipartId.isEmpty()) {
                PutObjectRequest putObjectRequest = this.createPutObjectRequest(this.upload);
                TransferUtility.appendMultipartTransferServiceUserAgentString(putObjectRequest);
                try {
                    this.upload.multipartId = this.initiateMultipartUpload(putObjectRequest);
                }
                catch (AmazonClientException ace) {
                    LOGGER.error((Object)("Error initiating multipart upload: " + this.upload.id + " due to " + ace.getMessage()), (Throwable)ace);
                    this.updater.throwError(this.upload.id, (Exception)((Object)ace));
                    this.updater.updateState(this.upload.id, TransferState.FAILED);
                    return false;
                }
                this.dbUtil.updateMultipartId(this.upload.id, this.upload.multipartId);
            } else {
                bytesAlreadyTransferred = this.dbUtil.queryBytesTransferredByMainUploadId(this.upload.id);
                if (bytesAlreadyTransferred > 0L) {
                    LOGGER.info((Object)String.format("Resume transfer %d from %d bytes", this.upload.id, bytesAlreadyTransferred));
                }
            }
            UploadTaskProgressListener uploadTaskProgressListener = new UploadTaskProgressListener(bytesAlreadyTransferred);
            this.updater.updateProgress(this.upload.id, bytesAlreadyTransferred, this.upload.bytesTotal, false);
            this.requestList = this.dbUtil.getNonCompletedPartRequestsFromDB(this.upload.id, this.upload.multipartId);
            LOGGER.info((Object)("Multipart upload " + this.upload.id + " in " + this.requestList.size() + " parts."));
            for (UploadPartRequest uploadPartRequest : this.requestList) {
                TransferUtility.appendMultipartTransferServiceUserAgentString(uploadPartRequest);
                UploadPartTaskMetadata uploadPartTaskMetadata = new UploadPartTaskMetadata();
                uploadPartTaskMetadata.uploadPartRequest = uploadPartRequest;
                uploadPartTaskMetadata.bytesTransferredSoFar = 0L;
                uploadPartTaskMetadata.state = TransferState.WAITING;
                this.uploadPartTasks.put(uploadPartRequest.getPartNumber(), uploadPartTaskMetadata);
                uploadPartTaskMetadata.uploadPartTask = TransferThreadPool.submitTask(new UploadPartTask(uploadPartTaskMetadata, uploadTaskProgressListener, uploadPartRequest, this.s3, this.dbUtil));
            }
            try {
                boolean isSuccess = true;
                for (UploadPartTaskMetadata task : this.uploadPartTasks.values()) {
                    boolean b = task.uploadPartTask.get();
                    isSuccess &= b;
                }
                if (isSuccess) break block22;
                try {
                    if (TransferNetworkLossHandler.getInstance() != null && !TransferNetworkLossHandler.getInstance().isNetworkConnected()) {
                        LOGGER.info((Object)"Network not connected. Setting the state to WAITING_FOR_NETWORK.");
                        this.updater.updateState(this.upload.id, TransferState.WAITING_FOR_NETWORK);
                        return false;
                    }
                }
                catch (TransferUtilityException transferUtilityException) {
                    LOGGER.error((Object)("TransferUtilityException: [" + transferUtilityException + "]"));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Upload resulted in an exception. " + e));
                for (UploadPartTaskMetadata task : this.uploadPartTasks.values()) {
                    task.uploadPartTask.cancel(true);
                }
                if (TransferState.PENDING_CANCEL.equals((Object)this.upload.state)) {
                    this.updater.updateState(this.upload.id, TransferState.CANCELED);
                    LOGGER.info((Object)("Transfer is " + (Object)((Object)TransferState.CANCELED)));
                    return false;
                }
                if (TransferState.PENDING_PAUSE.equals((Object)this.upload.state)) {
                    this.updater.updateState(this.upload.id, TransferState.PAUSED);
                    LOGGER.info((Object)("Transfer is " + (Object)((Object)TransferState.PAUSED)));
                    return false;
                }
                for (UploadPartTaskMetadata task : this.uploadPartTasks.values()) {
                    if (!TransferState.WAITING_FOR_NETWORK.equals((Object)task.state)) continue;
                    LOGGER.info((Object)"Individual part is WAITING_FOR_NETWORK.");
                    this.updater.updateState(this.upload.id, TransferState.WAITING_FOR_NETWORK);
                    return false;
                }
                try {
                    if (TransferNetworkLossHandler.getInstance() != null && !TransferNetworkLossHandler.getInstance().isNetworkConnected()) {
                        LOGGER.info((Object)"Network not connected. Setting the state to WAITING_FOR_NETWORK.");
                        this.updater.updateState(this.upload.id, TransferState.WAITING_FOR_NETWORK);
                        return false;
                    }
                }
                catch (TransferUtilityException transferUtilityException) {
                    LOGGER.error((Object)("TransferUtilityException: [" + transferUtilityException + "]"));
                }
                if (RetryUtils.isInterrupted((Throwable)e)) {
                    LOGGER.info((Object)("Transfer is interrupted. " + e));
                    this.updater.updateState(this.upload.id, TransferState.FAILED);
                    return false;
                }
                LOGGER.error((Object)("Error encountered during multi-part upload: " + this.upload.id + " due to " + e.getMessage()), (Throwable)e);
                this.updater.throwError(this.upload.id, e);
                this.updater.updateState(this.upload.id, TransferState.FAILED);
                return false;
            }
        }
        LOGGER.info((Object)("Completing the multi-part upload transfer for " + this.upload.id));
        try {
            this.completeMultiPartUpload(this.upload.id, this.upload.bucketName, this.upload.key, this.upload.multipartId);
            this.updater.updateProgress(this.upload.id, this.upload.bytesTotal, this.upload.bytesTotal, true);
            this.updater.updateState(this.upload.id, TransferState.COMPLETED);
            return true;
        }
        catch (AmazonClientException ace) {
            LOGGER.error((Object)("Failed to complete multipart: " + this.upload.id + " due to " + ace.getMessage()), (Throwable)ace);
            this.abortMultiPartUpload(this.upload.id, this.upload.bucketName, this.upload.key, this.upload.multipartId);
            this.updater.throwError(this.upload.id, (Exception)((Object)ace));
            this.updater.updateState(this.upload.id, TransferState.FAILED);
            return false;
        }
    }

    private Boolean uploadSinglePartAndWaitForCompletion() {
        PutObjectRequest putObjectRequest = this.createPutObjectRequest(this.upload);
        ProgressListener progressListener = this.updater.newProgressListener(this.upload.id);
        long length = putObjectRequest.getFile().length();
        TransferUtility.appendTransferServiceUserAgentString(putObjectRequest);
        putObjectRequest.setGeneralProgressListener(progressListener);
        try {
            this.s3.putObject(putObjectRequest);
            this.updater.updateProgress(this.upload.id, length, length, true);
            this.updater.updateState(this.upload.id, TransferState.COMPLETED);
            return true;
        }
        catch (Exception e) {
            if (TransferState.PENDING_CANCEL.equals((Object)this.upload.state)) {
                this.updater.updateState(this.upload.id, TransferState.CANCELED);
                LOGGER.info((Object)("Transfer is " + (Object)((Object)TransferState.CANCELED)));
                return false;
            }
            if (TransferState.PENDING_PAUSE.equals((Object)this.upload.state)) {
                this.updater.updateState(this.upload.id, TransferState.PAUSED);
                LOGGER.info((Object)("Transfer is " + (Object)((Object)TransferState.PAUSED)));
                ProgressEvent resetEvent = new ProgressEvent(0L);
                resetEvent.setEventCode(32);
                progressListener.progressChanged(new ProgressEvent(0L));
                return false;
            }
            try {
                if (TransferNetworkLossHandler.getInstance() != null && !TransferNetworkLossHandler.getInstance().isNetworkConnected()) {
                    LOGGER.info((Object)("Thread:[" + Thread.currentThread().getId() + "]: Network wasn't available."));
                    this.updater.updateState(this.upload.id, TransferState.WAITING_FOR_NETWORK);
                    LOGGER.debug((Object)"Network Connection Interrupted: Moving the TransferState to WAITING_FOR_NETWORK");
                    ProgressEvent resetEvent = new ProgressEvent(0L);
                    resetEvent.setEventCode(32);
                    progressListener.progressChanged(new ProgressEvent(0L));
                    return false;
                }
            }
            catch (TransferUtilityException transferUtilityException) {
                LOGGER.error((Object)("TransferUtilityException: [" + transferUtilityException + "]"));
            }
            if (RetryUtils.isInterrupted((Throwable)e)) {
                LOGGER.info((Object)("Transfer is interrupted. " + e));
                this.updater.updateState(this.upload.id, TransferState.FAILED);
                return false;
            }
            LOGGER.debug((Object)("Failed to upload: " + this.upload.id + " due to " + e.getMessage()));
            this.updater.throwError(this.upload.id, e);
            this.updater.updateState(this.upload.id, TransferState.FAILED);
            return false;
        }
    }

    private void completeMultiPartUpload(int mainUploadId, String bucket, String key, String multipartId) throws AmazonClientException, AmazonServiceException {
        List<PartETag> partETags = this.dbUtil.queryPartETagsOfUpload(mainUploadId);
        CompleteMultipartUploadRequest completeRequest = new CompleteMultipartUploadRequest(bucket, key, multipartId, partETags);
        TransferUtility.appendMultipartTransferServiceUserAgentString(completeRequest);
        this.s3.completeMultipartUpload(completeRequest);
    }

    private void abortMultiPartUpload(int mainUploadId, String bucket, String key, String multipartId) {
        LOGGER.info((Object)"Aborting the multipart since complete multipart failed.");
        try {
            this.s3.abortMultipartUpload(new AbortMultipartUploadRequest(bucket, key, multipartId));
            LOGGER.debug((Object)("Successfully aborted multipart upload: " + mainUploadId));
        }
        catch (AmazonClientException e) {
            LOGGER.debug((Object)("Failed to abort the multipart upload: " + mainUploadId), (Throwable)e);
        }
    }

    private String initiateMultipartUpload(PutObjectRequest putObjectRequest) {
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(putObjectRequest.getBucketName(), putObjectRequest.getKey()).withCannedACL(putObjectRequest.getCannedAcl()).withObjectMetadata(putObjectRequest.getMetadata()).withSSEAwsKeyManagementParams(putObjectRequest.getSSEAwsKeyManagementParams()).withTagging(putObjectRequest.getTagging());
        TransferUtility.appendMultipartTransferServiceUserAgentString(initiateMultipartUploadRequest);
        return this.s3.initiateMultipartUpload(initiateMultipartUploadRequest).getUploadId();
    }

    private PutObjectRequest createPutObjectRequest(TransferRecord upload) {
        File file = new File(upload.file);
        PutObjectRequest putObjectRequest = new PutObjectRequest(upload.bucketName, upload.key, file);
        ObjectMetadata om = new ObjectMetadata();
        om.setContentLength(file.length());
        if (upload.headerCacheControl != null) {
            om.setCacheControl(upload.headerCacheControl);
        }
        if (upload.headerContentDisposition != null) {
            om.setContentDisposition(upload.headerContentDisposition);
        }
        if (upload.headerContentEncoding != null) {
            om.setContentEncoding(upload.headerContentEncoding);
        }
        if (upload.headerContentType != null) {
            om.setContentType(upload.headerContentType);
        } else {
            om.setContentType(Mimetypes.getInstance().getMimetype(file));
        }
        if (upload.headerStorageClass != null) {
            putObjectRequest.setStorageClass(upload.headerStorageClass);
        }
        if (upload.expirationTimeRuleId != null) {
            om.setExpirationTimeRuleId(upload.expirationTimeRuleId);
        }
        if (upload.httpExpires != null) {
            om.setHttpExpiresDate(new Date(Long.valueOf(upload.httpExpires)));
        }
        if (upload.sseAlgorithm != null) {
            om.setSSEAlgorithm(upload.sseAlgorithm);
        }
        if (upload.userMetadata != null) {
            String isRequesterPays;
            String redirectLocation;
            om.setUserMetadata(upload.userMetadata);
            String objectTag = upload.userMetadata.get("x-amz-tagging");
            if (objectTag != null) {
                try {
                    String[] tags = objectTag.split(OBJECT_TAGS_DELIMITER);
                    ArrayList<Tag> tagList = new ArrayList<Tag>();
                    for (String tag : tags) {
                        String[] tagParts = tag.split(OBJECT_TAG_KEY_VALUE_SEPARATOR);
                        tagList.add(new Tag(tagParts[0], tagParts[1]));
                    }
                    putObjectRequest.setTagging(new ObjectTagging(tagList));
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Error in passing the object tags as request headers.", (Throwable)exception);
                }
            }
            if ((redirectLocation = upload.userMetadata.get("x-amz-website-redirect-location")) != null) {
                putObjectRequest.setRedirectLocation(redirectLocation);
            }
            if ((isRequesterPays = upload.userMetadata.get("x-amz-request-payer")) != null) {
                putObjectRequest.setRequesterPays(REQUESTER_PAYS.equals(isRequesterPays));
            }
        }
        if (upload.md5 != null) {
            om.setContentMD5(upload.md5);
        }
        if (upload.sseKMSKey != null) {
            putObjectRequest.setSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(upload.sseKMSKey));
        }
        putObjectRequest.setMetadata(om);
        putObjectRequest.setCannedAcl(UploadTask.getCannedAclFromString(upload.cannedAcl));
        return putObjectRequest;
    }

    private static CannedAccessControlList getCannedAclFromString(String cannedAcl) {
        return cannedAcl == null ? null : CANNED_ACL_MAP.get(cannedAcl);
    }

    static {
        for (CannedAccessControlList cannedAcl : CannedAccessControlList.values()) {
            CANNED_ACL_MAP.put(cannedAcl.toString(), cannedAcl);
        }
    }

    class UploadPartTaskMetadata {
        UploadPartRequest uploadPartRequest;
        Future<Boolean> uploadPartTask;
        long bytesTransferredSoFar;
        TransferState state;

        UploadPartTaskMetadata() {
        }
    }

    class UploadTaskProgressListener
    implements ProgressListener {
        private long prevTotalBytesTransferredOfAllParts;
        private final long bytesAlreadyTransferred;

        UploadTaskProgressListener(long bytesAlreadyTransferred) {
            this.prevTotalBytesTransferredOfAllParts = bytesAlreadyTransferred;
            this.bytesAlreadyTransferred = bytesAlreadyTransferred;
        }

        public void progressChanged(ProgressEvent progressEvent) {
        }

        public synchronized void onProgressChanged(int partNum, long bytesTransferredSoFarForPartNum) {
            UploadPartTaskMetadata partNumTask = UploadTask.this.uploadPartTasks.get(partNum);
            if (partNumTask == null) {
                LOGGER.info((Object)"Update received for unknown part. Ignoring.");
                return;
            }
            partNumTask.bytesTransferredSoFar = bytesTransferredSoFarForPartNum;
            long totalBytesTransferredOfAllParts = this.bytesAlreadyTransferred;
            for (Map.Entry<Integer, UploadPartTaskMetadata> part : UploadTask.this.uploadPartTasks.entrySet()) {
                totalBytesTransferredOfAllParts += part.getValue().bytesTransferredSoFar;
            }
            if (totalBytesTransferredOfAllParts > this.prevTotalBytesTransferredOfAllParts && totalBytesTransferredOfAllParts <= ((UploadTask)UploadTask.this).upload.bytesTotal) {
                UploadTask.this.updater.updateProgress(((UploadTask)UploadTask.this).upload.id, totalBytesTransferredOfAllParts, ((UploadTask)UploadTask.this).upload.bytesTotal, true);
                this.prevTotalBytesTransferredOfAllParts = totalBytesTransferredOfAllParts;
            }
        }
    }
}

