/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.util.Log;
import java.util.HashMap;
import java.util.Map;

public enum TransferState {
    WAITING,
    IN_PROGRESS,
    PAUSED,
    RESUMED_WAITING,
    COMPLETED,
    CANCELED,
    FAILED,
    WAITING_FOR_NETWORK,
    PART_COMPLETED,
    PENDING_CANCEL,
    PENDING_PAUSE,
    PENDING_NETWORK_DISCONNECT,
    UNKNOWN;

    private static final Map<String, TransferState> map;

    public static TransferState getState(String stateAsString) {
        if (map.containsKey(stateAsString)) {
            return map.get(stateAsString);
        }
        Log.e((String)"TransferState", (String)("Unknown state " + stateAsString + " transfer will be have state set to UNKNOWN."));
        return UNKNOWN;
    }

    static {
        map = new HashMap<String, TransferState>();
        for (TransferState state : TransferState.values()) {
            map.put(state.toString(), state);
        }
    }
}

