/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.internal.crypto.CipherLite;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.internal.crypto.JceEncryptionConstants;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsAccessor;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.util.Base64;
import com.amazonaws.util.json.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Key;
import java.security.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class ContentCryptoMaterial {
    private final String keyWrappingAlgorithm;
    private final CipherLite cipherLite;
    private final Map<String, String> kekMaterialsDescription;
    private final byte[] encryptedCEK;

    ContentCryptoMaterial(Map<String, String> kekMaterialsDescription, byte[] encryptedCEK, String keyWrappingAlgorithm, CipherLite cipherLite) {
        this.cipherLite = cipherLite;
        this.keyWrappingAlgorithm = keyWrappingAlgorithm;
        this.encryptedCEK = (byte[])encryptedCEK.clone();
        this.kekMaterialsDescription = kekMaterialsDescription;
    }

    String getKeyWrappingAlgorithm() {
        return this.keyWrappingAlgorithm;
    }

    ContentCryptoScheme getContentCryptoScheme() {
        return this.cipherLite.getContentCryptoScheme();
    }

    ObjectMetadata toObjectMetadata(ObjectMetadata metadata) {
        String keyWrapAlgo;
        byte[] encryptedCEK = this.getEncryptedCEK();
        metadata.addUserMetadata("x-amz-key-v2", Base64.encodeAsString((byte[])encryptedCEK));
        byte[] iv = this.cipherLite.getIV();
        metadata.addUserMetadata("x-amz-iv", Base64.encodeAsString((byte[])iv));
        metadata.addUserMetadata("x-amz-matdesc", this.kekMaterialDescAsJson());
        ContentCryptoScheme scheme = this.getContentCryptoScheme();
        metadata.addUserMetadata("x-amz-cek-alg", scheme.getCipherAlgorithm());
        int tagLen = scheme.getTagLengthInBits();
        if (tagLen > 0) {
            metadata.addUserMetadata("x-amz-tag-len", String.valueOf(tagLen));
        }
        if ((keyWrapAlgo = this.getKeyWrappingAlgorithm()) != null) {
            metadata.addUserMetadata("x-amz-wrap-alg", keyWrapAlgo);
        }
        return metadata;
    }

    String toJsonString() {
        String keyWrapAlgo;
        HashMap<String, String> map = new HashMap<String, String>();
        byte[] encryptedCEK = this.getEncryptedCEK();
        map.put("x-amz-key-v2", Base64.encodeAsString((byte[])encryptedCEK));
        byte[] iv = this.cipherLite.getIV();
        map.put("x-amz-iv", Base64.encodeAsString((byte[])iv));
        map.put("x-amz-matdesc", this.kekMaterialDescAsJson());
        ContentCryptoScheme scheme = this.getContentCryptoScheme();
        map.put("x-amz-cek-alg", scheme.getCipherAlgorithm());
        int tagLen = scheme.getTagLengthInBits();
        if (tagLen > 0) {
            map.put("x-amz-tag-len", String.valueOf(tagLen));
        }
        if ((keyWrapAlgo = this.getKeyWrappingAlgorithm()) != null) {
            map.put("x-amz-wrap-alg", keyWrapAlgo);
        }
        return JsonUtils.mapToString(map);
    }

    private String kekMaterialDescAsJson() {
        Map<String, String> kekMaterialDesc = this.getKEKMaterialsDescription();
        if (kekMaterialDesc == null) {
            kekMaterialDesc = Collections.emptyMap();
        }
        return JsonUtils.mapToString(kekMaterialDesc);
    }

    private static Map<String, String> matdescFromJson(String json) {
        if (json == null) {
            return null;
        }
        Map map = JsonUtils.jsonToMap((String)json);
        return map == null ? null : Collections.unmodifiableMap(map);
    }

    private static SecretKey cek(byte[] cekSecured, String keyWrapAlgo, EncryptionMaterials materials, Provider securityProvider) {
        Key kek = materials.getKeyPair() != null ? materials.getKeyPair().getPrivate() : materials.getSymmetricKey();
        try {
            if (keyWrapAlgo != null) {
                Cipher cipher = securityProvider == null ? Cipher.getInstance(keyWrapAlgo) : Cipher.getInstance(keyWrapAlgo, securityProvider);
                cipher.init(4, kek);
                return (SecretKey)cipher.unwrap(cekSecured, keyWrapAlgo, 3);
            }
            Cipher cipher = securityProvider != null ? Cipher.getInstance(kek.getAlgorithm(), securityProvider) : Cipher.getInstance(kek.getAlgorithm());
            cipher.init(2, kek);
            byte[] decryptedSymmetricKeyBytes = cipher.doFinal(cekSecured);
            return new SecretKeySpec(decryptedSymmetricKeyBytes, JceEncryptionConstants.SYMMETRIC_KEY_ALGORITHM);
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to decrypt symmetric key from object metadata : " + e.getMessage(), (Throwable)e);
        }
    }

    static ContentCryptoMaterial fromObjectMetadata(ObjectMetadata metadata, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range) {
        EncryptionMaterials materials;
        Map<String, String> userMeta = metadata.getUserMetadata();
        String b64key = userMeta.get("x-amz-key-v2");
        if (b64key == null && (b64key = userMeta.get("x-amz-key")) == null) {
            throw new AmazonClientException("Content encrypting key not found.");
        }
        byte[] cekWrapped = Base64.decode((String)b64key);
        byte[] iv = Base64.decode((String)userMeta.get("x-amz-iv"));
        if (cekWrapped == null || iv == null) {
            throw new AmazonClientException("Content encrypting key or IV not found.");
        }
        String matdescStr = userMeta.get("x-amz-matdesc");
        Map<String, String> matdesc = ContentCryptoMaterial.matdescFromJson(matdescStr);
        EncryptionMaterials encryptionMaterials = materials = kekMaterialAccessor == null ? null : kekMaterialAccessor.getEncryptionMaterials(matdesc);
        if (materials == null) {
            throw new AmazonClientException("Unable to retrieve the client encryption materials");
        }
        String cekAlgo = userMeta.get("x-amz-cek-alg");
        boolean isRangeGet = range != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(cekAlgo, isRangeGet);
        if (isRangeGet) {
            iv = contentCryptoScheme.adjustIV(iv, range[0]);
        } else {
            String s;
            int tagLenActual;
            int tagLenExpected = contentCryptoScheme.getTagLengthInBits();
            if (tagLenExpected > 0 && tagLenExpected != (tagLenActual = Integer.parseInt(s = userMeta.get("x-amz-tag-len")))) {
                throw new AmazonClientException("Unsupported tag length: " + tagLenActual + ", expected: " + tagLenExpected);
            }
        }
        String keyWrapAlgo = userMeta.get("x-amz-wrap-alg");
        SecretKey cek = ContentCryptoMaterial.cek(cekWrapped, keyWrapAlgo, materials, securityProvider);
        return new ContentCryptoMaterial(matdesc, cekWrapped, keyWrapAlgo, contentCryptoScheme.createCipherLite(cek, iv, 2, securityProvider));
    }

    static ContentCryptoMaterial fromInstructionFile(Map<String, String> instFile, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range) {
        return ContentCryptoMaterial.fromInstructionFile0(instFile, kekMaterialAccessor, securityProvider, range);
    }

    private static ContentCryptoMaterial fromInstructionFile0(Map<String, String> map, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range) {
        EncryptionMaterials materials;
        String b64key = map.get("x-amz-key-v2");
        if (b64key == null && (b64key = map.get("x-amz-key")) == null) {
            throw new AmazonClientException("Content encrypting key not found.");
        }
        byte[] cekWrapped = Base64.decode((String)b64key);
        byte[] iv = Base64.decode((String)map.get("x-amz-iv"));
        if (cekWrapped == null || iv == null) {
            throw new AmazonClientException("Necessary encryption info not found in the instruction file " + map);
        }
        String matdescStr = map.get("x-amz-matdesc");
        Map<String, String> matdesc = ContentCryptoMaterial.matdescFromJson(matdescStr);
        EncryptionMaterials encryptionMaterials = materials = kekMaterialAccessor == null ? null : kekMaterialAccessor.getEncryptionMaterials(matdesc);
        if (materials == null) {
            throw new AmazonClientException("Unable to retrieve the encryption materials that originally encrypted object corresponding to instruction file " + map);
        }
        String cekAlgo = map.get("x-amz-cek-alg");
        boolean isRangeGet = range != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(cekAlgo, isRangeGet);
        if (isRangeGet) {
            iv = contentCryptoScheme.adjustIV(iv, range[0]);
        } else {
            String s;
            int tagLenActual;
            int tagLenExpected = contentCryptoScheme.getTagLengthInBits();
            if (tagLenExpected > 0 && tagLenExpected != (tagLenActual = Integer.parseInt(s = map.get("x-amz-tag-len")))) {
                throw new AmazonClientException("Unsupported tag length: " + tagLenActual + ", expected: " + tagLenExpected);
            }
        }
        String keyWrapAlgo = map.get("x-amz-wrap-alg");
        SecretKey cek = ContentCryptoMaterial.cek(cekWrapped, keyWrapAlgo, materials, securityProvider);
        return new ContentCryptoMaterial(matdesc, cekWrapped, keyWrapAlgo, contentCryptoScheme.createCipherLite(cek, iv, 2, securityProvider));
    }

    static String parseInstructionFile(S3Object instructionFile) {
        try {
            return ContentCryptoMaterial.convertStreamToString((InputStream)((Object)instructionFile.getObjectContent()));
        }
        catch (Exception e) {
            throw new AmazonClientException("Error parsing JSON instruction file: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        finally {
            inputStream.close();
        }
        return stringBuilder.toString();
    }

    CipherLite getCipherLite() {
        return this.cipherLite;
    }

    Map<String, String> getKEKMaterialsDescription() {
        return this.kekMaterialsDescription;
    }

    byte[] getEncryptedCEK() {
        return (byte[])this.encryptedCEK.clone();
    }
}

