/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.app.Service;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.database.Cursor;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Message;
import android.util.Log;
import com.amazonaws.mobileconnectors.s3.transferutility.S3ClientWeakReference;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferRecord;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferThreadPool;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferType;
import com.amazonaws.mobileconnectors.s3.transferutility.networkinfo.NetworkInfoChangeListener;
import com.amazonaws.mobileconnectors.s3.transferutility.networkinfo.NetworkInfoReceiver;
import com.amazonaws.services.s3.AmazonS3;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class TransferService
extends Service {
    private static final String TAG = "TransferSerivce";
    private static final int MSG_UPDATE = 100;
    private static final int MSG_CHECK = 200;
    private static final int MINUTE_IN_MILLIS = 60000;
    private AmazonS3 s3;
    private HandlerThread handlerThread;
    private Handler updateHandler;
    private TransferContentObserver observer;
    private NetworkInfoReceiver networkInfoReceive;
    private Map<Integer, TransferRecord> transfers;
    private int startId;
    private TransferDBUtil dbUtil;
    private final Handler.Callback mUpdateCallback = new Handler.Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleMessage(Message msg) {
            boolean isActive;
            Map map = TransferService.this.transfers;
            synchronized (map) {
                isActive = TransferService.this.updateTransfersFromDB();
            }
            if (isActive) {
                TransferService.this.enqueueCheckTasksDoneLater();
            } else if (msg.what == 200) {
                TransferService.this.stopSelf(TransferService.this.startId);
            }
            return true;
        }
    };

    public IBinder onBind(Intent intent) {
        throw new UnsupportedOperationException("Can't bind to TransferSerivce");
    }

    public void onCreate() {
        super.onCreate();
        Log.d((String)TAG, (String)"Starting Transfer Service");
        this.transfers = new HashMap<Integer, TransferRecord>();
        this.handlerThread = new HandlerThread("TransferSerivce-AWSTransferUpdateHandlerThread");
        this.handlerThread.start();
        this.updateHandler = new Handler(this.handlerThread.getLooper(), this.mUpdateCallback);
        this.dbUtil = new TransferDBUtil(this.getApplicationContext());
        this.observer = new TransferContentObserver();
        this.getContentResolver().registerContentObserver(this.dbUtil.getContentUri(), true, (ContentObserver)this.observer);
        this.networkInfoReceive = new NetworkInfoReceiver(this.getApplicationContext());
        this.networkInfoReceive.addNetworkInfoListener(new NetworkInfoChangeListener(){

            @Override
            public void onDisconnect() {
                TransferService.this.dbUtil.updateNetworkDisconnected();
            }

            @Override
            public void onConnect() {
                TransferService.this.dbUtil.updateNetworkConnected();
            }
        });
        if (this.networkInfoReceive.isNetworkConnected()) {
            this.dbUtil.updateNetworkConnected();
        } else {
            this.dbUtil.updateNetworkDisconnected();
        }
        this.registerReceiver(this.networkInfoReceive, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.startId = startId;
        String keyForS3Client = intent.getStringExtra("keyForS3WeakReference");
        this.s3 = S3ClientWeakReference.get(keyForS3Client);
        if (this.s3 == null) {
            Log.w((String)TAG, (String)"TransferService can't get s3 client, it will stop.");
            this.stopSelf();
        }
        this.enqueueUpdate();
        return 2;
    }

    public void onDestroy() {
        this.getContentResolver().unregisterContentObserver((ContentObserver)this.observer);
        this.unregisterReceiver(this.networkInfoReceive);
        this.handlerThread.quit();
        this.dbUtil.setAllRunningRecordsToPausedBeforeShutdownService();
        TransferThreadPool.closeThreadPool();
        super.onDestroy();
    }

    private void enqueueUpdate() {
        this.updateHandler.removeMessages(100);
        this.updateHandler.obtainMessage(100, (Object)this.startId).sendToTarget();
    }

    private void enqueueCheckTasksDoneLater() {
        this.updateHandler.removeMessages(200);
        this.updateHandler.sendMessageDelayed(this.updateHandler.obtainMessage(200, (Object)this.startId), 60000L);
    }

    boolean updateTransfersFromDB() {
        boolean isActive = false;
        HashSet<Integer> deadTransferIds = new HashSet<Integer>(this.transfers.keySet());
        Cursor cursor = this.dbUtil.queryAllTransfersWithType(TransferType.ANY);
        while (cursor.moveToNext()) {
            int transferId = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
            deadTransferIds.remove(transferId);
            TransferRecord transfer = this.transfers.get(transferId);
            if (transfer != null) {
                transfer.updateFromDB(cursor);
            } else {
                transfer = this.addNewTransfer(cursor);
            }
            boolean isTransferActive = transfer.startIfReady(this.dbUtil);
            transfer.pauseOrCancelIfRequested(this.dbUtil);
            isActive |= isTransferActive;
        }
        cursor.close();
        Iterator iterator = deadTransferIds.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            this.transfers.remove(id);
        }
        return isActive;
    }

    private TransferRecord addNewTransfer(Cursor c) {
        TransferRecord transfer = new TransferRecord(c.getInt(c.getColumnIndexOrThrow("_id")), this.s3);
        transfer.updateFromDB(c);
        this.transfers.put(transfer.id, transfer);
        return transfer;
    }

    private class TransferContentObserver
    extends ContentObserver {
        public TransferContentObserver() {
            super(new Handler());
        }

        public void onChange(boolean selfChange) {
            TransferService.this.enqueueUpdate();
        }
    }
}

