/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDatabaseHelper;

class TransferDBBase {
    private static final int TRANSFERS = 10;
    private static final int TRANSFER_ID = 20;
    private static final int TRANSFER_PART = 30;
    private static final int TRANSFER_STATE = 40;
    private static final String BASE_PATH = "transfers";
    private final Context context;
    private final Uri contentUri;
    private final UriMatcher uriMatcher;
    private final TransferDatabaseHelper databaseHelper;

    public TransferDBBase(Context context) {
        this.context = context;
        String mAuthority = context.getApplicationContext().getPackageName();
        this.databaseHelper = new TransferDatabaseHelper(this.context);
        this.contentUri = Uri.parse((String)("content://" + mAuthority + "/" + BASE_PATH));
        this.uriMatcher = new UriMatcher(-1);
        this.uriMatcher.addURI(mAuthority, BASE_PATH, 10);
        this.uriMatcher.addURI(mAuthority, "transfers/#", 20);
        this.uriMatcher.addURI(mAuthority, "transfers/part/#", 30);
        this.uriMatcher.addURI(mAuthority, "transfers/state/*", 40);
    }

    public void closeDBHelper() {
        this.databaseHelper.close();
    }

    public Uri getContentUri() {
        return this.contentUri;
    }

    public Uri insert(Uri uri, ContentValues values) {
        int uriType = this.uriMatcher.match(uri);
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        long id = 0L;
        switch (uriType) {
            case 10: {
                id = db.insert("awstransfer", null, values);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URI: " + uri);
            }
        }
        this.context.getContentResolver().notifyChange(uri, null);
        return Uri.parse((String)("transfers/" + id));
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteQueryBuilder queryBuilder = new SQLiteQueryBuilder();
        queryBuilder.setTables("awstransfer");
        int uriType = this.uriMatcher.match(uri);
        switch (uriType) {
            case 10: {
                queryBuilder.appendWhere((CharSequence)"part_num=0");
                break;
            }
            case 20: {
                queryBuilder.appendWhere((CharSequence)("_id=" + uri.getLastPathSegment()));
                break;
            }
            case 30: {
                queryBuilder.appendWhere((CharSequence)("main_upload_id=" + uri.getLastPathSegment()));
                break;
            }
            case 40: {
                queryBuilder.appendWhere((CharSequence)"state=");
                queryBuilder.appendWhereEscapeString(uri.getLastPathSegment());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URI: " + uri);
            }
        }
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        Cursor cursor = queryBuilder.query(db, projection, selection, selectionArgs, null, null, sortOrder);
        return cursor;
    }

    public synchronized int update(Uri uri, ContentValues values, String whereClause, String[] whereArgs) {
        int uriType = this.uriMatcher.match(uri);
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        int rowsUpdated = 0;
        switch (uriType) {
            case 10: {
                rowsUpdated = db.update("awstransfer", values, whereClause, whereArgs);
                break;
            }
            case 20: {
                String id = uri.getLastPathSegment();
                if (TextUtils.isEmpty((CharSequence)whereClause)) {
                    rowsUpdated = db.update("awstransfer", values, "_id=" + id, null);
                    break;
                }
                rowsUpdated = db.update("awstransfer", values, "_id=" + id + " and " + whereClause, whereArgs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URI: " + uri);
            }
        }
        if (rowsUpdated > 0) {
            this.context.getContentResolver().notifyChange(uri, null);
        }
        return rowsUpdated;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        int uriType = this.uriMatcher.match(uri);
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        int rowsDeleted = 0;
        switch (uriType) {
            case 10: {
                rowsDeleted = db.delete("awstransfer", selection, selectionArgs);
                break;
            }
            case 20: {
                String id = uri.getLastPathSegment();
                if (TextUtils.isEmpty((CharSequence)selection)) {
                    rowsDeleted = db.delete("awstransfer", "_id=" + id, null);
                    break;
                }
                rowsDeleted = db.delete("awstransfer", "_id=" + id + " and " + selection, selectionArgs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URI: " + uri);
            }
        }
        this.context.getContentResolver().notifyChange(uri, null);
        return rowsDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bulkInsert(Uri uri, ContentValues[] valuesArray) {
        int uriType = this.uriMatcher.match(uri);
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        int mainUploadId = 0;
        switch (uriType) {
            case 10: {
                try {
                    db.beginTransaction();
                    mainUploadId = (int)db.insertOrThrow("awstransfer", null, valuesArray[0]);
                    for (int i = 1; i < valuesArray.length; ++i) {
                        valuesArray[i].put("main_upload_id", Integer.valueOf(mainUploadId));
                        db.insertOrThrow("awstransfer", null, valuesArray[i]);
                    }
                    db.setTransactionSuccessful();
                    break;
                }
                catch (Exception e) {
                    Log.e((String)TransferDBBase.class.getSimpleName(), (String)("bulkInsert error : " + e.getMessage()));
                    break;
                }
                finally {
                    db.endTransaction();
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown URI: " + uri);
            }
        }
        this.context.getContentResolver().notifyChange(uri, null);
        return mainUploadId;
    }
}

