/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.util.Log;
import com.amazonaws.AbortedException;
import com.amazonaws.AmazonClientException;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferRecord;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferStatusUpdater;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtility;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.Callable;

class DownloadTask
implements Callable<Boolean> {
    private static final String TAG = "DownloadTask";
    private final AmazonS3 s3;
    private final TransferRecord download;
    private final TransferStatusUpdater updater;

    public DownloadTask(TransferRecord download, AmazonS3 s3, TransferStatusUpdater updater) {
        this.download = download;
        this.s3 = s3;
        this.updater = updater;
    }

    @Override
    public Boolean call() throws Exception {
        this.updater.updateState(this.download.id, TransferState.IN_PROGRESS);
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.download.bucketName, this.download.key);
        TransferUtility.appendTransferServiceUserAgentString(getObjectRequest);
        File file = new File(this.download.file);
        long bytesCurrent = file.length();
        if (bytesCurrent > 0L) {
            Log.d((String)TAG, (String)String.format("Resume transfer %d from %d bytes", this.download.id, bytesCurrent));
            getObjectRequest.setRange(bytesCurrent, -1L);
        }
        getObjectRequest.setGeneralProgressListener(this.updater.newProgressListener(this.download.id));
        try {
            S3Object object = this.s3.getObject(getObjectRequest);
            if (object == null) {
                this.updater.throwError(this.download.id, new IllegalStateException("AmazonS3.getObject returns null"));
                this.updater.updateState(this.download.id, TransferState.FAILED);
                return false;
            }
            long bytesTotal = object.getObjectMetadata().getInstanceLength();
            this.updater.updateProgress(this.download.id, bytesCurrent, bytesTotal);
            this.saveToFile((InputStream)((Object)object.getObjectContent()), file);
            this.updater.updateProgress(this.download.id, bytesTotal, bytesTotal);
            this.updater.updateState(this.download.id, TransferState.COMPLETED);
            return true;
        }
        catch (Exception e) {
            if (e instanceof AbortedException || e.getCause() != null && (e.getCause() instanceof InterruptedIOException || e.getCause() instanceof InterruptedException)) {
                Log.d((String)TAG, (String)("Transfer " + this.download.id + " is interrupted by user"));
            } else {
                Log.e((String)TAG, (String)("Failed to download: " + this.download.id + " due to " + e.getMessage()));
                this.updater.throwError(this.download.id, e);
                this.updater.updateState(this.download.id, TransferState.FAILED);
            }
            return false;
        }
    }

    private void saveToFile(InputStream is, File file) {
        File parentDirectory = file.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists()) {
            parentDirectory.mkdirs();
        }
        boolean append = file.length() > 0L;
        OutputStream os = null;
        try {
            int bytesRead;
            os = new BufferedOutputStream(new FileOutputStream(file, append));
            byte[] buffer = new byte[16384];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new AmazonClientException("Unable to store object contents to disk: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                is.close();
            }
            catch (IOException iOException) {}
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }
}

