/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.util.Log;
import com.amazonaws.AbortedException;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferRecord;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferStatusUpdater;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtility;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import java.io.File;
import java.io.InterruptedIOException;
import java.util.concurrent.Callable;

class DownloadTask
implements Callable<Boolean> {
    private static final String TAG = "DownloadTask";
    private final AmazonS3 s3;
    private final TransferRecord download;
    private final TransferStatusUpdater updater;

    public DownloadTask(TransferRecord download, AmazonS3 s3, TransferStatusUpdater updater) {
        this.download = download;
        this.s3 = s3;
        this.updater = updater;
    }

    @Override
    public Boolean call() throws Exception {
        this.updater.updateState(this.download.id, TransferState.IN_PROGRESS);
        File file = new File(this.download.file);
        try {
            GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(this.download.bucketName, this.download.key);
            TransferUtility.appendTransferServiceUserAgentString(getObjectMetadataRequest);
            ObjectMetadata objectMetadata = this.s3.getObjectMetadata(getObjectMetadataRequest);
            long bytesTotal = objectMetadata.getContentLength();
            long bytesCurrent = file.length();
            if (bytesCurrent > bytesTotal) {
                this.updater.throwError(this.download.id, new IllegalStateException("Unable to determine the range for download operation."));
                this.updater.updateState(this.download.id, TransferState.FAILED);
                return false;
            }
            GetObjectRequest getObjectRequest = new GetObjectRequest(this.download.bucketName, this.download.key);
            TransferUtility.appendTransferServiceUserAgentString(getObjectRequest);
            if (bytesCurrent > 0L) {
                Log.d((String)TAG, (String)String.format("Resume transfer %d from %d bytes", this.download.id, bytesCurrent));
                getObjectRequest.setRange(bytesCurrent, bytesTotal - 1L);
            }
            this.updater.updateProgress(this.download.id, bytesCurrent, bytesTotal);
            getObjectRequest.setGeneralProgressListener(this.updater.newProgressListener(this.download.id, bytesCurrent, bytesTotal));
            ObjectMetadata metadata = this.s3.getObject(getObjectRequest, file);
            if (metadata != null) {
                this.updater.updateProgress(this.download.id, bytesTotal, bytesTotal);
                this.updater.updateState(this.download.id, TransferState.COMPLETED);
                return true;
            }
            this.updater.throwError(this.download.id, new IllegalStateException("AmazonS3.getObject returns null"));
            this.updater.updateState(this.download.id, TransferState.FAILED);
        }
        catch (Exception e) {
            if (e instanceof AbortedException || e.getCause() != null && (e.getCause() instanceof InterruptedIOException || e.getCause() instanceof InterruptedException)) {
                Log.d((String)TAG, (String)("Transfer " + this.download.id + " is interrupted by user"));
            }
            Log.e((String)TAG, (String)("Failed to download: " + this.download.id + " due to " + e.getMessage()));
            this.updater.throwError(this.download.id, e);
            this.updater.updateState(this.download.id, TransferState.FAILED);
        }
        return false;
    }
}

