/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import java.util.HashMap;
import java.util.Map;

public enum TransferNetworkConnectionType {
    ANY{

        @Override
        protected boolean verify(NetworkInfo networkInfo) {
            return networkInfo != null && networkInfo.isConnected();
        }
    }
    ,
    WIFI{

        @Override
        protected boolean verify(NetworkInfo networkInfo) {
            return networkInfo != null && networkInfo.isConnected() && networkInfo.getType() == 1;
        }
    }
    ,
    MOBILE{

        @Override
        protected boolean verify(NetworkInfo networkInfo) {
            return networkInfo != null && networkInfo.isConnected() && networkInfo.getType() == 0;
        }
    };

    private static final Map<String, TransferNetworkConnectionType> MAP;
    private static final Log LOGGER;

    boolean isConnected(ConnectivityManager connectivityManager) {
        return this.verify(connectivityManager.getActiveNetworkInfo());
    }

    protected abstract boolean verify(NetworkInfo var1);

    public static TransferNetworkConnectionType getConnectionType(String typeAsString) {
        if (MAP.containsKey(typeAsString)) {
            return MAP.get(typeAsString);
        }
        LOGGER.error((Object)("Unknown connection type " + typeAsString + " transfer will have connection type set to ANY."));
        return ANY;
    }

    static {
        MAP = new HashMap<String, TransferNetworkConnectionType>();
        for (TransferNetworkConnectionType type : TransferNetworkConnectionType.values()) {
            MAP.put(type.toString(), type);
        }
        LOGGER = LogFactory.getLog(TransferNetworkConnectionType.class);
    }
}

