/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferNetworkLossHandler;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtilityException;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.util.concurrent.Callable;

class UploadPartTask
implements Callable<Boolean> {
    private static final Log LOGGER = LogFactory.getLog(UploadPartTask.class);
    private final UploadPartRequest request;
    private final AmazonS3 s3;
    private final TransferDBUtil dbUtil;

    public UploadPartTask(UploadPartRequest request, AmazonS3 s3, TransferDBUtil dbUtil) {
        this.request = request;
        this.s3 = s3;
        this.dbUtil = dbUtil;
    }

    @Override
    public Boolean call() throws Exception {
        try {
            UploadPartResult putPartResult = this.s3.uploadPart(this.request);
            this.dbUtil.updateState(this.request.getId(), TransferState.PART_COMPLETED);
            this.dbUtil.updateETag(this.request.getId(), putPartResult.getETag());
            return true;
        }
        catch (Exception e) {
            try {
                if (TransferNetworkLossHandler.getInstance() != null && !TransferNetworkLossHandler.getInstance().isNetworkConnected()) {
                    LOGGER.info((Object)("Thread: [" + Thread.currentThread().getId() + "]: Network wasn't available."));
                    this.dbUtil.updateState(this.request.getId(), TransferState.WAITING_FOR_NETWORK);
                    LOGGER.debug((Object)"Network Connection Interrupted: Moving the TransferState to WAITING_FOR_NETWORK");
                    return false;
                }
            }
            catch (TransferUtilityException transferUtilityException) {
                LOGGER.error((Object)("TransferUtilityException: [" + transferUtilityException + "]"));
            }
            if (RetryUtils.isInterrupted((Throwable)e)) {
                LOGGER.error((Object)("Upload part interrupted: " + e.getMessage()));
                return false;
            }
            this.dbUtil.updateState(this.request.getId(), TransferState.FAILED);
            LOGGER.error((Object)"Encountered error uploading part ", (Throwable)e);
            throw e;
        }
    }
}

