/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.mobileconnectors.s3.transferutility.S3ClientReference;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferRecord;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferStatusUpdater;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferType;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtilityException;
import com.amazonaws.services.s3.AmazonS3;
import java.util.ArrayList;

public class TransferNetworkLossHandler
extends BroadcastReceiver {
    private static final Log LOGGER = LogFactory.getLog(TransferNetworkLossHandler.class);
    private final ConnectivityManager connManager;
    private TransferDBUtil dbUtil;
    TransferStatusUpdater updater;
    private static TransferNetworkLossHandler transferNetworkLossHandler;

    private TransferNetworkLossHandler(Context context) {
        this.connManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.dbUtil = new TransferDBUtil(context);
        this.updater = TransferStatusUpdater.getInstance(context);
    }

    public static synchronized TransferNetworkLossHandler getInstance(Context context) {
        if (transferNetworkLossHandler == null) {
            transferNetworkLossHandler = new TransferNetworkLossHandler(context);
        }
        return transferNetworkLossHandler;
    }

    public static synchronized TransferNetworkLossHandler getInstance() throws TransferUtilityException {
        if (transferNetworkLossHandler == null) {
            String errorMessage = "TransferNetworkLossHandler is not created. Please call `TransferNetworkLossHandler.getInstance(Context)` to instantiate it before retrieving";
            LOGGER.error((Object)"TransferNetworkLossHandler is not created. Please call `TransferNetworkLossHandler.getInstance(Context)` to instantiate it before retrieving");
            throw new TransferUtilityException("TransferNetworkLossHandler is not created. Please call `TransferNetworkLossHandler.getInstance(Context)` to instantiate it before retrieving");
        }
        return transferNetworkLossHandler;
    }

    public void onReceive(Context context, Intent intent) {
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            LOGGER.info((Object)"Network connectivity changed detected.");
            final boolean networkConnected = this.isNetworkConnected();
            LOGGER.info((Object)("Network connected: " + networkConnected));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (networkConnected) {
                        TransferNetworkLossHandler.this.checkTransfersOnNetworkReconnect();
                    } else {
                        TransferNetworkLossHandler.this.pauseAllForNetwork();
                    }
                }
            }).start();
        }
    }

    boolean isNetworkConnected() {
        NetworkInfo info = this.connManager.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    private void checkTransfersOnNetworkReconnect() {
        if (this.isNetworkConnected()) {
            this.loadAndResumeTransfersFromDB(new TransferState[]{TransferState.WAITING_FOR_NETWORK});
        } else {
            LOGGER.error((Object)"Network Connect message received but not connected to network.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadAndResumeTransfersFromDB(TransferState[] transferStates) {
        LOGGER.debug((Object)"Loading transfers from database...");
        Cursor c = null;
        int count = 0;
        ArrayList<Integer> transferIds = new ArrayList<Integer>();
        try {
            c = this.dbUtil.queryTransfersWithTypeAndStates(TransferType.ANY, transferStates);
            while (c.moveToNext()) {
                int id = c.getInt(c.getColumnIndexOrThrow("_id"));
                if (this.updater.getTransfer(id) == null) {
                    TransferRecord transfer = new TransferRecord(id);
                    transfer.updateFromDB(c);
                    this.updater.addTransfer(transfer);
                    ++count;
                }
                transferIds.add(id);
            }
        }
        finally {
            if (c != null) {
                LOGGER.debug((Object)"Closing the cursor for loadAndResumeTransfersFromDB");
                c.close();
            }
        }
        try {
            for (Integer id : transferIds) {
                TransferRecord transfer;
                AmazonS3 s3 = S3ClientReference.get(id);
                if (s3 == null || (transfer = this.updater.getTransfer(id)) == null || transfer.isRunning()) continue;
                transfer.start(s3, this.dbUtil, this.updater);
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)("Error in resuming the transfers." + exception.getMessage()));
        }
        LOGGER.debug((Object)(count + " transfers are loaded from database."));
    }

    private void pauseAllForNetwork() {
        for (TransferRecord transferRecord : this.updater.getTransfers().values()) {
            AmazonS3 s3 = S3ClientReference.get(transferRecord.id);
            if (s3 == null || transferRecord == null || !transferRecord.pause(s3, this.updater)) continue;
            this.updater.updateState(transferRecord.id, TransferState.WAITING_FOR_NETWORK);
        }
    }
}

