/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.ProgressListenerCallbackExecutor;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.internal.CopyCallable;
import com.amazonaws.services.s3.transfer.internal.CopyImpl;
import com.amazonaws.services.s3.transfer.internal.TransferMonitor;
import com.amazonaws.services.s3.transfer.model.CopyResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class CopyMonitor
implements Callable<CopyResult>,
TransferMonitor {
    private final AmazonS3 s3;
    private final ExecutorService threadPool;
    private final CopyObjectRequest copyObjectRequest;
    private ScheduledExecutorService timedThreadPool;
    private final CopyCallable multipartCopyCallable;
    private final CopyImpl transfer;
    private final ProgressListenerCallbackExecutor progressListenerChainCallbackExecutor;
    private String uploadId;
    private final List<Future<PartETag>> futures = new ArrayList<Future<PartETag>>();
    private boolean isCopyDone = false;
    private Future<CopyResult> nextFuture;
    private int pollInterval = 5000;

    public synchronized Future<CopyResult> getFuture() {
        return this.nextFuture;
    }

    private synchronized void setNextFuture(Future<CopyResult> nextFuture) {
        this.nextFuture = nextFuture;
    }

    @Override
    public synchronized boolean isDone() {
        return this.isCopyDone;
    }

    private synchronized void markAllDone() {
        this.isCopyDone = true;
    }

    public CopyMonitor(TransferManager manager, CopyImpl transfer, ExecutorService threadPool, CopyCallable multipartCopyCallable, CopyObjectRequest copyObjectRequest, ProgressListenerChain progressListenerChain) {
        this.s3 = manager.getAmazonS3Client();
        this.multipartCopyCallable = multipartCopyCallable;
        this.threadPool = threadPool;
        this.copyObjectRequest = copyObjectRequest;
        this.transfer = transfer;
        this.progressListenerChainCallbackExecutor = ProgressListenerCallbackExecutor.wrapListener((ProgressListener)progressListenerChain);
        this.setNextFuture(threadPool.submit(this));
    }

    @Override
    public CopyResult call() throws Exception {
        try {
            if (this.uploadId == null) {
                return this.copy();
            }
            return this.poll();
        }
        catch (CancellationException e) {
            this.transfer.setState(Transfer.TransferState.Canceled);
            this.fireProgressEvent(16);
            throw new AmazonClientException("Upload canceled");
        }
        catch (Exception e) {
            this.transfer.setState(Transfer.TransferState.Failed);
            this.fireProgressEvent(8);
            throw e;
        }
    }

    public void setTimedThreadPool(ScheduledExecutorService timedThreadPool) {
        this.timedThreadPool = timedThreadPool;
    }

    private CopyResult poll() throws InterruptedException {
        for (Future<PartETag> f : this.futures) {
            if (f.isDone()) continue;
            this.reschedule();
            return null;
        }
        for (Future<PartETag> f : this.futures) {
            if (!f.isCancelled()) continue;
            throw new CancellationException();
        }
        return this.completeMultipartUpload();
    }

    private void fireProgressEvent(int eventType) {
        if (this.progressListenerChainCallbackExecutor == null) {
            return;
        }
        ProgressEvent event = new ProgressEvent(0L);
        event.setEventCode(eventType);
        this.progressListenerChainCallbackExecutor.progressChanged(event);
    }

    private CopyResult copy() throws Exception, InterruptedException {
        CopyResult result = this.multipartCopyCallable.call();
        if (result != null) {
            this.copyComplete();
        } else {
            this.uploadId = this.multipartCopyCallable.getMultipartUploadId();
            this.futures.addAll(this.multipartCopyCallable.getFutures());
            this.reschedule();
        }
        return result;
    }

    private void copyComplete() {
        this.markAllDone();
        this.transfer.setState(Transfer.TransferState.Completed);
        if (this.multipartCopyCallable.isMultipartCopy()) {
            this.fireProgressEvent(4);
        }
    }

    private void reschedule() {
        this.setNextFuture(this.timedThreadPool.schedule(new Callable<CopyResult>(){

            @Override
            public CopyResult call() throws Exception {
                CopyMonitor.this.setNextFuture(CopyMonitor.this.threadPool.submit(CopyMonitor.this));
                return null;
            }
        }, (long)this.pollInterval, TimeUnit.MILLISECONDS));
    }

    private CopyResult completeMultipartUpload() {
        CompleteMultipartUploadResult completeMultipartUploadResult = this.s3.completeMultipartUpload(new CompleteMultipartUploadRequest(this.copyObjectRequest.getDestinationBucketName(), this.copyObjectRequest.getDestinationKey(), this.uploadId, this.collectPartETags()));
        this.copyComplete();
        CopyResult copyResult = new CopyResult();
        copyResult.setSourceBucketName(this.copyObjectRequest.getSourceBucketName());
        copyResult.setSourceKey(this.copyObjectRequest.getSourceKey());
        copyResult.setDestinationBucketName(completeMultipartUploadResult.getBucketName());
        copyResult.setDestinationKey(completeMultipartUploadResult.getKey());
        copyResult.setETag(completeMultipartUploadResult.getETag());
        copyResult.setVersionId(completeMultipartUploadResult.getVersionId());
        return copyResult;
    }

    private List<PartETag> collectPartETags() {
        ArrayList<PartETag> partETags = new ArrayList<PartETag>(this.futures.size());
        for (Future<PartETag> future : this.futures) {
            try {
                partETags.add(future.get());
            }
            catch (Exception e) {
                throw new AmazonClientException("Unable to copy part: " + e.getCause().getMessage(), e.getCause());
            }
        }
        return partETags;
    }
}

