/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.services.s3.internal.Constants;
import com.amazonaws.services.s3.internal.DeleteObjectsResponse;
import com.amazonaws.services.s3.internal.ObjectExpirationResult;
import com.amazonaws.services.s3.internal.ServerSideEncryptionResult;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.BucketCrossOriginConfiguration;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.BucketLoggingConfiguration;
import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.BucketTaggingConfiguration;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import com.amazonaws.services.s3.model.CORSRule;
import com.amazonaws.services.s3.model.CanonicalGrantee;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.EmailAddressGrantee;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.GroupGrantee;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.MultiObjectDeleteException;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.PartSummary;
import com.amazonaws.services.s3.model.Permission;
import com.amazonaws.services.s3.model.RedirectRule;
import com.amazonaws.services.s3.model.RequestPaymentConfiguration;
import com.amazonaws.services.s3.model.RoutingRule;
import com.amazonaws.services.s3.model.RoutingRuleCondition;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.S3VersionSummary;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.TagSet;
import com.amazonaws.services.s3.model.VersionListing;
import com.amazonaws.services.s3.model.transform.AbstractHandler;
import com.amazonaws.services.s3.model.transform.AbstractSSEHandler;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlResponsesSaxParser {
    private static final Log log = LogFactory.getLog(XmlResponsesSaxParser.class);
    private XMLReader xr = null;
    private boolean sanitizeXmlDocument = true;

    public XmlResponsesSaxParser() throws AmazonClientException {
        try {
            this.xr = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            System.setProperty("org.xml.sax.driver", "org.xmlpull.v1.sax2.Driver");
            try {
                this.xr = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException sAXException2) {
                throw new AmazonClientException("Couldn't initialize a sax driver for the XMLReader", (Throwable)sAXException);
            }
        }
    }

    protected void parseXmlInputStream(DefaultHandler defaultHandler, InputStream inputStream) throws IOException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing XML response document with handler: " + defaultHandler.getClass()));
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            this.xr.setContentHandler(defaultHandler);
            this.xr.setErrorHandler(defaultHandler);
            this.xr.parse(new InputSource(bufferedReader));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            block6: {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error((Object)"Unable to close response InputStream up after XML parse failure", (Throwable)iOException);
                }
            }
            throw new AmazonClientException("Failed to parse XML document with handler " + defaultHandler.getClass(), throwable);
        }
    }

    protected InputStream sanitizeXmlDocument(DefaultHandler defaultHandler, InputStream inputStream) throws IOException {
        if (!this.sanitizeXmlDocument) {
            return inputStream;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sanitizing XML document destined for handler " + defaultHandler.getClass()));
        }
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            char[] cArray = new char[8192];
            int n = -1;
            while ((n = bufferedReader.read(cArray)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
            bufferedReader.close();
            String string = stringBuilder.toString().replaceAll("\r", "&#013;");
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes(StringUtils.UTF8));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            block8: {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    if (!log.isErrorEnabled()) break block8;
                    log.error((Object)"Unable to close response InputStream after failure sanitizing XML document", (Throwable)iOException);
                }
            }
            throw new AmazonClientException("Failed to sanitize XML document destined for handler " + defaultHandler.getClass(), throwable);
        }
        return byteArrayInputStream;
    }

    private static String checkForEmptyString(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    private static int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            log.error((Object)("Unable to parse integer value '" + string + "'"), (Throwable)numberFormatException);
            return -1;
        }
    }

    private static long parseLong(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            log.error((Object)("Unable to parse long value '" + string + "'"), (Throwable)numberFormatException);
            return -1L;
        }
    }

    public ListBucketHandler parseListBucketObjectsResponse(InputStream inputStream) throws IOException {
        ListBucketHandler listBucketHandler = new ListBucketHandler();
        this.parseXmlInputStream(listBucketHandler, this.sanitizeXmlDocument(listBucketHandler, inputStream));
        return listBucketHandler;
    }

    public ListVersionsHandler parseListVersionsResponse(InputStream inputStream) throws IOException {
        ListVersionsHandler listVersionsHandler = new ListVersionsHandler();
        this.parseXmlInputStream(listVersionsHandler, this.sanitizeXmlDocument(listVersionsHandler, inputStream));
        return listVersionsHandler;
    }

    public ListAllMyBucketsHandler parseListMyBucketsResponse(InputStream inputStream) throws IOException {
        ListAllMyBucketsHandler listAllMyBucketsHandler = new ListAllMyBucketsHandler();
        this.parseXmlInputStream(listAllMyBucketsHandler, this.sanitizeXmlDocument(listAllMyBucketsHandler, inputStream));
        return listAllMyBucketsHandler;
    }

    public AccessControlListHandler parseAccessControlListResponse(InputStream inputStream) throws IOException {
        AccessControlListHandler accessControlListHandler = new AccessControlListHandler();
        this.parseXmlInputStream(accessControlListHandler, inputStream);
        return accessControlListHandler;
    }

    public BucketLoggingConfigurationHandler parseLoggingStatusResponse(InputStream inputStream) throws IOException {
        BucketLoggingConfigurationHandler bucketLoggingConfigurationHandler = new BucketLoggingConfigurationHandler();
        this.parseXmlInputStream(bucketLoggingConfigurationHandler, inputStream);
        return bucketLoggingConfigurationHandler;
    }

    public BucketLifecycleConfigurationHandler parseBucketLifecycleConfigurationResponse(InputStream inputStream) throws IOException {
        BucketLifecycleConfigurationHandler bucketLifecycleConfigurationHandler = new BucketLifecycleConfigurationHandler();
        this.parseXmlInputStream(bucketLifecycleConfigurationHandler, inputStream);
        return bucketLifecycleConfigurationHandler;
    }

    public BucketCrossOriginConfigurationHandler parseBucketCrossOriginConfigurationResponse(InputStream inputStream) throws IOException {
        BucketCrossOriginConfigurationHandler bucketCrossOriginConfigurationHandler = new BucketCrossOriginConfigurationHandler();
        this.parseXmlInputStream(bucketCrossOriginConfigurationHandler, inputStream);
        return bucketCrossOriginConfigurationHandler;
    }

    public String parseBucketLocationResponse(InputStream inputStream) throws IOException {
        BucketLocationHandler bucketLocationHandler = new BucketLocationHandler();
        this.parseXmlInputStream(bucketLocationHandler, inputStream);
        return bucketLocationHandler.getLocation();
    }

    public BucketVersioningConfigurationHandler parseVersioningConfigurationResponse(InputStream inputStream) throws IOException {
        BucketVersioningConfigurationHandler bucketVersioningConfigurationHandler = new BucketVersioningConfigurationHandler();
        this.parseXmlInputStream(bucketVersioningConfigurationHandler, inputStream);
        return bucketVersioningConfigurationHandler;
    }

    public BucketWebsiteConfigurationHandler parseWebsiteConfigurationResponse(InputStream inputStream) throws IOException {
        BucketWebsiteConfigurationHandler bucketWebsiteConfigurationHandler = new BucketWebsiteConfigurationHandler();
        this.parseXmlInputStream(bucketWebsiteConfigurationHandler, inputStream);
        return bucketWebsiteConfigurationHandler;
    }

    public BucketNotificationConfigurationHandler parseNotificationConfigurationResponse(InputStream inputStream) throws IOException {
        BucketNotificationConfigurationHandler bucketNotificationConfigurationHandler = new BucketNotificationConfigurationHandler();
        this.parseXmlInputStream(bucketNotificationConfigurationHandler, inputStream);
        return bucketNotificationConfigurationHandler;
    }

    public BucketTaggingConfigurationHandler parseTaggingConfigurationResponse(InputStream inputStream) throws IOException {
        BucketTaggingConfigurationHandler bucketTaggingConfigurationHandler = new BucketTaggingConfigurationHandler();
        this.parseXmlInputStream(bucketTaggingConfigurationHandler, inputStream);
        return bucketTaggingConfigurationHandler;
    }

    public DeleteObjectsHandler parseDeletedObjectsResult(InputStream inputStream) throws IOException {
        DeleteObjectsHandler deleteObjectsHandler = new DeleteObjectsHandler();
        this.parseXmlInputStream(deleteObjectsHandler, inputStream);
        return deleteObjectsHandler;
    }

    public CopyObjectResultHandler parseCopyObjectResponse(InputStream inputStream) throws IOException {
        CopyObjectResultHandler copyObjectResultHandler = new CopyObjectResultHandler();
        this.parseXmlInputStream(copyObjectResultHandler, inputStream);
        return copyObjectResultHandler;
    }

    public CompleteMultipartUploadHandler parseCompleteMultipartUploadResponse(InputStream inputStream) throws IOException {
        CompleteMultipartUploadHandler completeMultipartUploadHandler = new CompleteMultipartUploadHandler();
        this.parseXmlInputStream(completeMultipartUploadHandler, inputStream);
        return completeMultipartUploadHandler;
    }

    public InitiateMultipartUploadHandler parseInitiateMultipartUploadResponse(InputStream inputStream) throws IOException {
        InitiateMultipartUploadHandler initiateMultipartUploadHandler = new InitiateMultipartUploadHandler();
        this.parseXmlInputStream(initiateMultipartUploadHandler, inputStream);
        return initiateMultipartUploadHandler;
    }

    public ListMultipartUploadsHandler parseListMultipartUploadsResponse(InputStream inputStream) throws IOException {
        ListMultipartUploadsHandler listMultipartUploadsHandler = new ListMultipartUploadsHandler();
        this.parseXmlInputStream(listMultipartUploadsHandler, inputStream);
        return listMultipartUploadsHandler;
    }

    public ListPartsHandler parseListPartsResponse(InputStream inputStream) throws IOException {
        ListPartsHandler listPartsHandler = new ListPartsHandler();
        this.parseXmlInputStream(listPartsHandler, inputStream);
        return listPartsHandler;
    }

    public RequestPaymentConfigurationHandler parseRequestPaymentConfigurationResponse(InputStream inputStream) throws IOException {
        RequestPaymentConfigurationHandler requestPaymentConfigurationHandler = new RequestPaymentConfigurationHandler();
        this.parseXmlInputStream(requestPaymentConfigurationHandler, inputStream);
        return requestPaymentConfigurationHandler;
    }

    private static String findAttributeValue(String string, Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string2 = attributes.getQName(i);
            if (!string2.trim().equalsIgnoreCase(string.trim())) continue;
            return attributes.getValue(i);
        }
        return null;
    }

    public static class BucketCrossOriginConfigurationHandler
    extends AbstractHandler {
        private final BucketCrossOriginConfiguration configuration = new BucketCrossOriginConfiguration(new ArrayList<CORSRule>());
        private CORSRule currentRule;
        private List<CORSRule.AllowedMethods> allowedMethods = null;
        private List<String> allowedOrigins = null;
        private List<String> exposedHeaders = null;
        private List<String> allowedHeaders = null;

        public BucketCrossOriginConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("CORSConfiguration")) {
                if (string2.equals("CORSRule")) {
                    this.currentRule = new CORSRule();
                }
            } else if (this.in("CORSConfiguration", "CORSRule")) {
                if (string2.equals("AllowedOrigin")) {
                    if (this.allowedOrigins == null) {
                        this.allowedOrigins = new ArrayList<String>();
                    }
                } else if (string2.equals("AllowedMethod")) {
                    if (this.allowedMethods == null) {
                        this.allowedMethods = new ArrayList<CORSRule.AllowedMethods>();
                    }
                } else if (string2.equals("ExposeHeader")) {
                    if (this.exposedHeaders == null) {
                        this.exposedHeaders = new ArrayList<String>();
                    }
                } else if (string2.equals("AllowedHeader") && this.allowedHeaders == null) {
                    this.allowedHeaders = new LinkedList<String>();
                }
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("CORSConfiguration")) {
                if (string2.equals("CORSRule")) {
                    this.currentRule.setAllowedHeaders(this.allowedHeaders);
                    this.currentRule.setAllowedMethods(this.allowedMethods);
                    this.currentRule.setAllowedOrigins(this.allowedOrigins);
                    this.currentRule.setExposedHeaders(this.exposedHeaders);
                    this.allowedHeaders = null;
                    this.allowedMethods = null;
                    this.allowedOrigins = null;
                    this.exposedHeaders = null;
                    this.configuration.getRules().add(this.currentRule);
                    this.currentRule = null;
                }
            } else if (this.in("CORSConfiguration", "CORSRule")) {
                if (string2.equals("ID")) {
                    this.currentRule.setId(this.getText());
                } else if (string2.equals("AllowedOrigin")) {
                    this.allowedOrigins.add(this.getText());
                } else if (string2.equals("AllowedMethod")) {
                    this.allowedMethods.add(CORSRule.AllowedMethods.fromValue(this.getText()));
                } else if (string2.equals("MaxAgeSeconds")) {
                    this.currentRule.setMaxAgeSeconds(Integer.parseInt(this.getText()));
                } else if (string2.equals("ExposeHeader")) {
                    this.exposedHeaders.add(this.getText());
                } else if (string2.equals("AllowedHeader")) {
                    this.allowedHeaders.add(this.getText());
                }
            }
        }
    }

    public static class BucketLifecycleConfigurationHandler
    extends AbstractHandler {
        private final BucketLifecycleConfiguration configuration = new BucketLifecycleConfiguration(new ArrayList<BucketLifecycleConfiguration.Rule>());
        private BucketLifecycleConfiguration.Rule currentRule;
        private BucketLifecycleConfiguration.Transition currentTransition;
        private BucketLifecycleConfiguration.NoncurrentVersionTransition currentNcvTransition;

        public BucketLifecycleConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("LifecycleConfiguration")) {
                if (string2.equals("Rule")) {
                    this.currentRule = new BucketLifecycleConfiguration.Rule();
                }
            } else if (this.in("LifecycleConfiguration", "Rule")) {
                if (string2.equals("Transition")) {
                    this.currentTransition = new BucketLifecycleConfiguration.Transition();
                } else if (string2.equals("NoncurrentVersionTransition")) {
                    this.currentNcvTransition = new BucketLifecycleConfiguration.NoncurrentVersionTransition();
                }
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("LifecycleConfiguration")) {
                if (string2.equals("Rule")) {
                    this.configuration.getRules().add(this.currentRule);
                    this.currentRule = null;
                }
            } else if (this.in("LifecycleConfiguration", "Rule")) {
                if (string2.equals("ID")) {
                    this.currentRule.setId(this.getText());
                } else if (string2.equals("Prefix")) {
                    this.currentRule.setPrefix(this.getText());
                } else if (string2.equals("Status")) {
                    this.currentRule.setStatus(this.getText());
                } else if (string2.equals("Transition")) {
                    this.currentRule.setTransition(this.currentTransition);
                    this.currentTransition = null;
                } else if (string2.equals("NoncurrentVersionTransition")) {
                    this.currentRule.setNoncurrentVersionTransition(this.currentNcvTransition);
                    this.currentNcvTransition = null;
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "Expiration")) {
                if (string2.equals("Date")) {
                    this.currentRule.setExpirationDate(ServiceUtils.parseIso8601Date(this.getText()));
                } else if (string2.equals("Days")) {
                    this.currentRule.setExpirationInDays(Integer.parseInt(this.getText()));
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "Transition")) {
                if (string2.equals("StorageClass")) {
                    this.currentTransition.setStorageClass(StorageClass.fromValue(this.getText()));
                } else if (string2.equals("Date")) {
                    this.currentTransition.setDate(ServiceUtils.parseIso8601Date(this.getText()));
                } else if (string2.equals("Days")) {
                    this.currentTransition.setDays(Integer.parseInt(this.getText()));
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "NoncurrentVersionExpiration")) {
                if (string2.equals("NoncurrentDays")) {
                    this.currentRule.setNoncurrentVersionExpirationInDays(Integer.parseInt(this.getText()));
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "NoncurrentVersionTransition")) {
                if (string2.equals("StorageClass")) {
                    this.currentNcvTransition.setStorageClass(StorageClass.fromValue(this.getText()));
                } else if (string2.equals("NoncurrentDays")) {
                    this.currentNcvTransition.setDays(Integer.parseInt(this.getText()));
                }
            }
        }
    }

    public static class DeleteObjectsHandler
    extends AbstractHandler {
        private final DeleteObjectsResponse response = new DeleteObjectsResponse();
        private DeleteObjectsResult.DeletedObject currentDeletedObject = null;
        private MultiObjectDeleteException.DeleteError currentError = null;

        public DeleteObjectsResponse getDeleteObjectResult() {
            return this.response;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("DeleteResult")) {
                if (string2.equals("Deleted")) {
                    this.currentDeletedObject = new DeleteObjectsResult.DeletedObject();
                } else if (string2.equals("Error")) {
                    this.currentError = new MultiObjectDeleteException.DeleteError();
                }
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("DeleteResult")) {
                if (string2.equals("Deleted")) {
                    this.response.getDeletedObjects().add(this.currentDeletedObject);
                    this.currentDeletedObject = null;
                } else if (string2.equals("Error")) {
                    this.response.getErrors().add(this.currentError);
                    this.currentError = null;
                }
            } else if (this.in("DeleteResult", "Deleted")) {
                if (string2.equals("Key")) {
                    this.currentDeletedObject.setKey(this.getText());
                } else if (string2.equals("VersionId")) {
                    this.currentDeletedObject.setVersionId(this.getText());
                } else if (string2.equals("DeleteMarker")) {
                    this.currentDeletedObject.setDeleteMarker(this.getText().equals("true"));
                } else if (string2.equals("DeleteMarkerVersionId")) {
                    this.currentDeletedObject.setDeleteMarkerVersionId(this.getText());
                }
            } else if (this.in("DeleteResult", "Error")) {
                if (string2.equals("Key")) {
                    this.currentError.setKey(this.getText());
                } else if (string2.equals("VersionId")) {
                    this.currentError.setVersionId(this.getText());
                } else if (string2.equals("Code")) {
                    this.currentError.setCode(this.getText());
                } else if (string2.equals("Message")) {
                    this.currentError.setMessage(this.getText());
                }
            }
        }
    }

    public static class BucketTaggingConfigurationHandler
    extends AbstractHandler {
        private final BucketTaggingConfiguration configuration = new BucketTaggingConfiguration();
        private Map<String, String> currentTagSet;
        private String currentTagKey;
        private String currentTagValue;

        public BucketTaggingConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("Tagging") && string2.equals("TagSet")) {
                this.currentTagSet = new HashMap<String, String>();
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("Tagging")) {
                if (string2.equals("TagSet")) {
                    this.configuration.getAllTagSets().add(new TagSet(this.currentTagSet));
                    this.currentTagSet = null;
                }
            } else if (this.in("Tagging", "TagSet")) {
                if (string2.equals("Tag")) {
                    if (this.currentTagKey != null && this.currentTagValue != null) {
                        this.currentTagSet.put(this.currentTagKey, this.currentTagValue);
                    }
                    this.currentTagKey = null;
                    this.currentTagValue = null;
                }
            } else if (this.in("Tagging", "TagSet", "Tag")) {
                if (string2.equals("Key")) {
                    this.currentTagKey = this.getText();
                } else if (string2.equals("Value")) {
                    this.currentTagValue = this.getText();
                }
            }
        }
    }

    public static class BucketNotificationConfigurationHandler
    extends AbstractHandler {
        private final BucketNotificationConfiguration configuration = new BucketNotificationConfiguration();
        private String topic;
        private String event;

        public BucketNotificationConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("NotificationConfiguration", "TopicConfiguration")) {
                if (string2.equals("Topic")) {
                    this.topic = this.getText();
                } else if (string2.equals("Event")) {
                    this.event = this.getText();
                }
            } else if (this.in("NotificationConfiguration") && string2.equals("TopicConfiguration")) {
                if (this.topic != null && this.event != null) {
                    this.configuration.getTopicConfigurations().add(new BucketNotificationConfiguration.TopicConfiguration(this.topic, this.event));
                }
                this.topic = null;
                this.event = null;
            }
        }
    }

    public static class ListPartsHandler
    extends AbstractHandler {
        private final PartListing result = new PartListing();
        private PartSummary currentPart;
        private Owner currentOwner;

        public PartListing getListPartsResult() {
            return this.result;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("ListPartsResult")) {
                if (string2.equals("Part")) {
                    this.currentPart = new PartSummary();
                } else if (string2.equals("Owner") || string2.equals("Initiator")) {
                    this.currentOwner = new Owner();
                }
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("ListPartsResult")) {
                if (string2.equals("Bucket")) {
                    this.result.setBucketName(this.getText());
                } else if (string2.equals("Key")) {
                    this.result.setKey(this.getText());
                } else if (string2.equals("UploadId")) {
                    this.result.setUploadId(this.getText());
                } else if (string2.equals("Owner")) {
                    this.result.setOwner(this.currentOwner);
                    this.currentOwner = null;
                } else if (string2.equals("Initiator")) {
                    this.result.setInitiator(this.currentOwner);
                    this.currentOwner = null;
                } else if (string2.equals("StorageClass")) {
                    this.result.setStorageClass(this.getText());
                } else if (string2.equals("PartNumberMarker")) {
                    this.result.setPartNumberMarker(this.parseInteger(this.getText()));
                } else if (string2.equals("NextPartNumberMarker")) {
                    this.result.setNextPartNumberMarker(this.parseInteger(this.getText()));
                } else if (string2.equals("MaxParts")) {
                    this.result.setMaxParts(this.parseInteger(this.getText()));
                } else if (string2.equals("EncodingType")) {
                    this.result.setEncodingType(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("IsTruncated")) {
                    this.result.setTruncated(Boolean.parseBoolean(this.getText()));
                } else if (string2.equals("Part")) {
                    this.result.getParts().add(this.currentPart);
                    this.currentPart = null;
                }
            } else if (this.in("ListPartsResult", "Part")) {
                if (string2.equals("PartNumber")) {
                    this.currentPart.setPartNumber(Integer.parseInt(this.getText()));
                } else if (string2.equals("LastModified")) {
                    this.currentPart.setLastModified(ServiceUtils.parseIso8601Date(this.getText()));
                } else if (string2.equals("ETag")) {
                    this.currentPart.setETag(ServiceUtils.removeQuotes(this.getText()));
                } else if (string2.equals("Size")) {
                    this.currentPart.setSize(Long.parseLong(this.getText()));
                }
            } else if (this.in("ListPartsResult", "Owner") || this.in("ListPartsResult", "Initiator")) {
                if (string2.equals("ID")) {
                    this.currentOwner.setId(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("DisplayName")) {
                    this.currentOwner.setDisplayName(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                }
            }
        }

        private Integer parseInteger(String string) {
            string = XmlResponsesSaxParser.checkForEmptyString(this.getText());
            if (string == null) {
                return null;
            }
            return Integer.parseInt(string);
        }
    }

    public static class ListMultipartUploadsHandler
    extends AbstractHandler {
        private final MultipartUploadListing result = new MultipartUploadListing();
        private MultipartUpload currentMultipartUpload;
        private Owner currentOwner;

        public MultipartUploadListing getListMultipartUploadsResult() {
            return this.result;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("ListMultipartUploadsResult")) {
                if (string2.equals("Upload")) {
                    this.currentMultipartUpload = new MultipartUpload();
                }
            } else if (this.in("ListMultipartUploadsResult", "Upload") && (string2.equals("Owner") || string2.equals("Initiator"))) {
                this.currentOwner = new Owner();
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("ListMultipartUploadsResult")) {
                if (string2.equals("Bucket")) {
                    this.result.setBucketName(this.getText());
                } else if (string2.equals("KeyMarker")) {
                    this.result.setKeyMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("Delimiter")) {
                    this.result.setDelimiter(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("Prefix")) {
                    this.result.setPrefix(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("UploadIdMarker")) {
                    this.result.setUploadIdMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("NextKeyMarker")) {
                    this.result.setNextKeyMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("NextUploadIdMarker")) {
                    this.result.setNextUploadIdMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("MaxUploads")) {
                    this.result.setMaxUploads(Integer.parseInt(this.getText()));
                } else if (string2.equals("EncodingType")) {
                    this.result.setEncodingType(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("IsTruncated")) {
                    this.result.setTruncated(Boolean.parseBoolean(this.getText()));
                } else if (string2.equals("Upload")) {
                    this.result.getMultipartUploads().add(this.currentMultipartUpload);
                    this.currentMultipartUpload = null;
                }
            } else if (this.in("ListMultipartUploadsResult", "CommonPrefixes")) {
                if (string2.equals("Prefix")) {
                    this.result.getCommonPrefixes().add(this.getText());
                }
            } else if (this.in("ListMultipartUploadsResult", "Upload")) {
                if (string2.equals("Key")) {
                    this.currentMultipartUpload.setKey(this.getText());
                } else if (string2.equals("UploadId")) {
                    this.currentMultipartUpload.setUploadId(this.getText());
                } else if (string2.equals("Owner")) {
                    this.currentMultipartUpload.setOwner(this.currentOwner);
                    this.currentOwner = null;
                } else if (string2.equals("Initiator")) {
                    this.currentMultipartUpload.setInitiator(this.currentOwner);
                    this.currentOwner = null;
                } else if (string2.equals("StorageClass")) {
                    this.currentMultipartUpload.setStorageClass(this.getText());
                } else if (string2.equals("Initiated")) {
                    this.currentMultipartUpload.setInitiated(ServiceUtils.parseIso8601Date(this.getText()));
                }
            } else if (this.in("ListMultipartUploadsResult", "Upload", "Owner") || this.in("ListMultipartUploadsResult", "Upload", "Initiator")) {
                if (string2.equals("ID")) {
                    this.currentOwner.setId(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("DisplayName")) {
                    this.currentOwner.setDisplayName(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                }
            }
        }
    }

    public static class InitiateMultipartUploadHandler
    extends AbstractHandler {
        private final InitiateMultipartUploadResult result = new InitiateMultipartUploadResult();

        public InitiateMultipartUploadResult getInitiateMultipartUploadResult() {
            return this.result;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("InitiateMultipartUploadResult")) {
                if (string2.equals("Bucket")) {
                    this.result.setBucketName(this.getText());
                } else if (string2.equals("Key")) {
                    this.result.setKey(this.getText());
                } else if (string2.equals("UploadId")) {
                    this.result.setUploadId(this.getText());
                }
            }
        }
    }

    public static class CompleteMultipartUploadHandler
    extends AbstractSSEHandler
    implements ObjectExpirationResult {
        private CompleteMultipartUploadResult result;
        private AmazonS3Exception ase;
        private String hostId;
        private String requestId;
        private String errorCode;

        @Override
        protected ServerSideEncryptionResult sseResult() {
            return this.result;
        }

        @Override
        public Date getExpirationTime() {
            return this.result == null ? null : this.result.getExpirationTime();
        }

        @Override
        public void setExpirationTime(Date date) {
            if (this.result != null) {
                this.result.setExpirationTime(date);
            }
        }

        @Override
        public String getExpirationTimeRuleId() {
            return this.result == null ? null : this.result.getExpirationTimeRuleId();
        }

        @Override
        public void setExpirationTimeRuleId(String string) {
            if (this.result != null) {
                this.result.setExpirationTimeRuleId(string);
            }
        }

        public CompleteMultipartUploadResult getCompleteMultipartUploadResult() {
            return this.result;
        }

        public AmazonS3Exception getAmazonS3Exception() {
            return this.ase;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.atTopLevel() && string2.equals("CompleteMultipartUploadResult")) {
                this.result = new CompleteMultipartUploadResult();
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.atTopLevel()) {
                if (string2.equals("Error") && this.ase != null) {
                    this.ase.setErrorCode(this.errorCode);
                    this.ase.setRequestId(this.requestId);
                    this.ase.setExtendedRequestId(this.hostId);
                }
            } else if (this.in("CompleteMultipartUploadResult")) {
                if (string2.equals("Location")) {
                    this.result.setLocation(this.getText());
                } else if (string2.equals("Bucket")) {
                    this.result.setBucketName(this.getText());
                } else if (string2.equals("Key")) {
                    this.result.setKey(this.getText());
                } else if (string2.equals("ETag")) {
                    this.result.setETag(ServiceUtils.removeQuotes(this.getText()));
                }
            } else if (this.in("Error")) {
                if (string2.equals("Code")) {
                    this.errorCode = this.getText();
                } else if (string2.equals("Message")) {
                    this.ase = new AmazonS3Exception(this.getText());
                } else if (string2.equals("RequestId")) {
                    this.requestId = this.getText();
                } else if (string2.equals("HostId")) {
                    this.hostId = this.getText();
                }
            }
        }
    }

    public static class BucketVersioningConfigurationHandler
    extends AbstractHandler {
        private final BucketVersioningConfiguration configuration = new BucketVersioningConfiguration();

        public BucketVersioningConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("VersioningConfiguration")) {
                if (string2.equals("Status")) {
                    this.configuration.setStatus(this.getText());
                } else if (string2.equals("MfaDelete")) {
                    String string4 = this.getText();
                    if (string4.equals("Disabled")) {
                        this.configuration.setMfaDeleteEnabled(false);
                    } else if (string4.equals("Enabled")) {
                        this.configuration.setMfaDeleteEnabled(true);
                    } else {
                        this.configuration.setMfaDeleteEnabled(null);
                    }
                }
            }
        }
    }

    public static class BucketWebsiteConfigurationHandler
    extends AbstractHandler {
        private final BucketWebsiteConfiguration configuration = new BucketWebsiteConfiguration(null);
        private RoutingRuleCondition currentCondition = null;
        private RedirectRule currentRedirectRule = null;
        private RoutingRule currentRoutingRule = null;

        public BucketWebsiteConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("WebsiteConfiguration")) {
                if (string2.equals("RedirectAllRequestsTo")) {
                    this.currentRedirectRule = new RedirectRule();
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules")) {
                if (string2.equals("RoutingRule")) {
                    this.currentRoutingRule = new RoutingRule();
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules", "RoutingRule")) {
                if (string2.equals("Condition")) {
                    this.currentCondition = new RoutingRuleCondition();
                } else if (string2.equals("Redirect")) {
                    this.currentRedirectRule = new RedirectRule();
                }
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("WebsiteConfiguration")) {
                if (string2.equals("RedirectAllRequestsTo")) {
                    this.configuration.setRedirectAllRequestsTo(this.currentRedirectRule);
                    this.currentRedirectRule = null;
                }
            } else if (this.in("WebsiteConfiguration", "IndexDocument")) {
                if (string2.equals("Suffix")) {
                    this.configuration.setIndexDocumentSuffix(this.getText());
                }
            } else if (this.in("WebsiteConfiguration", "ErrorDocument")) {
                if (string2.equals("Key")) {
                    this.configuration.setErrorDocument(this.getText());
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules")) {
                if (string2.equals("RoutingRule")) {
                    this.configuration.getRoutingRules().add(this.currentRoutingRule);
                    this.currentRoutingRule = null;
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules", "RoutingRule")) {
                if (string2.equals("Condition")) {
                    this.currentRoutingRule.setCondition(this.currentCondition);
                    this.currentCondition = null;
                } else if (string2.equals("Redirect")) {
                    this.currentRoutingRule.setRedirect(this.currentRedirectRule);
                    this.currentRedirectRule = null;
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules", "RoutingRule", "Condition")) {
                if (string2.equals("KeyPrefixEquals")) {
                    this.currentCondition.setKeyPrefixEquals(this.getText());
                } else if (string2.equals("HttpErrorCodeReturnedEquals")) {
                    this.currentCondition.setHttpErrorCodeReturnedEquals(this.getText());
                }
            } else if (this.in("WebsiteConfiguration", "RedirectAllRequestsTo") || this.in("WebsiteConfiguration", "RoutingRules", "RoutingRule", "Redirect")) {
                if (string2.equals("Protocol")) {
                    this.currentRedirectRule.setProtocol(this.getText());
                } else if (string2.equals("HostName")) {
                    this.currentRedirectRule.setHostName(this.getText());
                } else if (string2.equals("ReplaceKeyPrefixWith")) {
                    this.currentRedirectRule.setReplaceKeyPrefixWith(this.getText());
                } else if (string2.equals("ReplaceKeyWith")) {
                    this.currentRedirectRule.setReplaceKeyWith(this.getText());
                } else if (string2.equals("HttpRedirectCode")) {
                    this.currentRedirectRule.setHttpRedirectCode(this.getText());
                }
            }
        }
    }

    public static class ListVersionsHandler
    extends AbstractHandler {
        private final VersionListing versionListing = new VersionListing();
        private S3VersionSummary currentVersionSummary;
        private Owner currentOwner;

        public VersionListing getListing() {
            return this.versionListing;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("ListVersionsResult")) {
                if (string2.equals("Version")) {
                    this.currentVersionSummary = new S3VersionSummary();
                    this.currentVersionSummary.setBucketName(this.versionListing.getBucketName());
                } else if (string2.equals("DeleteMarker")) {
                    this.currentVersionSummary = new S3VersionSummary();
                    this.currentVersionSummary.setBucketName(this.versionListing.getBucketName());
                    this.currentVersionSummary.setIsDeleteMarker(true);
                }
            } else if ((this.in("ListVersionsResult", "Version") || this.in("ListVersionsResult", "DeleteMarker")) && string2.equals("Owner")) {
                this.currentOwner = new Owner();
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("ListVersionsResult")) {
                if (string2.equals("Name")) {
                    this.versionListing.setBucketName(this.getText());
                } else if (string2.equals("Prefix")) {
                    this.versionListing.setPrefix(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("KeyMarker")) {
                    this.versionListing.setKeyMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("VersionIdMarker")) {
                    this.versionListing.setVersionIdMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("MaxKeys")) {
                    this.versionListing.setMaxKeys(Integer.parseInt(this.getText()));
                } else if (string2.equals("Delimiter")) {
                    this.versionListing.setDelimiter(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("EncodingType")) {
                    this.versionListing.setEncodingType(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("NextKeyMarker")) {
                    this.versionListing.setNextKeyMarker(this.getText());
                } else if (string2.equals("NextVersionIdMarker")) {
                    this.versionListing.setNextVersionIdMarker(this.getText());
                } else if (string2.equals("IsTruncated")) {
                    this.versionListing.setTruncated("true".equals(this.getText()));
                } else if (string2.equals("Version") || string2.equals("DeleteMarker")) {
                    this.versionListing.getVersionSummaries().add(this.currentVersionSummary);
                    this.currentVersionSummary = null;
                }
            } else if (this.in("ListVersionsResult", "CommonPrefixes")) {
                if (string2.equals("Prefix")) {
                    this.versionListing.getCommonPrefixes().add(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                }
            } else if (this.in("ListVersionsResult", "Version") || this.in("ListVersionsResult", "DeleteMarker")) {
                if (string2.equals("Key")) {
                    this.currentVersionSummary.setKey(this.getText());
                } else if (string2.equals("VersionId")) {
                    this.currentVersionSummary.setVersionId(this.getText());
                } else if (string2.equals("IsLatest")) {
                    this.currentVersionSummary.setIsLatest("true".equals(this.getText()));
                } else if (string2.equals("LastModified")) {
                    this.currentVersionSummary.setLastModified(ServiceUtils.parseIso8601Date(this.getText()));
                } else if (string2.equals("ETag")) {
                    this.currentVersionSummary.setETag(ServiceUtils.removeQuotes(this.getText()));
                } else if (string2.equals("Size")) {
                    this.currentVersionSummary.setSize(Long.parseLong(this.getText()));
                } else if (string2.equals("Owner")) {
                    this.currentVersionSummary.setOwner(this.currentOwner);
                    this.currentOwner = null;
                } else if (string2.equals("StorageClass")) {
                    this.currentVersionSummary.setStorageClass(this.getText());
                }
            } else if (this.in("ListVersionsResult", "Version", "Owner") || this.in("ListVersionsResult", "DeleteMarker", "Owner")) {
                if (string2.equals("ID")) {
                    this.currentOwner.setId(this.getText());
                } else if (string2.equals("DisplayName")) {
                    this.currentOwner.setDisplayName(this.getText());
                }
            }
        }
    }

    public static class RequestPaymentConfigurationHandler
    extends AbstractHandler {
        private String payer = null;

        public RequestPaymentConfiguration getConfiguration() {
            return new RequestPaymentConfiguration(RequestPaymentConfiguration.Payer.valueOf(this.payer));
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("RequestPaymentConfiguration") && string2.equals("Payer")) {
                this.payer = this.getText();
            }
        }
    }

    public static class CopyObjectResultHandler
    extends AbstractSSEHandler
    implements ObjectExpirationResult {
        private final CopyObjectResult result = new CopyObjectResult();
        private String errorCode = null;
        private String errorMessage = null;
        private String errorRequestId = null;
        private String errorHostId = null;
        private boolean receivedErrorResponse = false;

        @Override
        protected ServerSideEncryptionResult sseResult() {
            return this.result;
        }

        public Date getLastModified() {
            return this.result.getLastModifiedDate();
        }

        public String getVersionId() {
            return this.result.getVersionId();
        }

        public void setVersionId(String string) {
            this.result.setVersionId(string);
        }

        @Override
        public Date getExpirationTime() {
            return this.result.getExpirationTime();
        }

        @Override
        public void setExpirationTime(Date date) {
            this.result.setExpirationTime(date);
        }

        @Override
        public String getExpirationTimeRuleId() {
            return this.result.getExpirationTimeRuleId();
        }

        @Override
        public void setExpirationTimeRuleId(String string) {
            this.result.setExpirationTimeRuleId(string);
        }

        public String getETag() {
            return this.result.getETag();
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getErrorHostId() {
            return this.errorHostId;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getErrorRequestId() {
            return this.errorRequestId;
        }

        public boolean isErrorResponse() {
            return this.receivedErrorResponse;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.atTopLevel()) {
                if (string2.equals("CopyObjectResult") || string2.equals("CopyPartResult")) {
                    this.receivedErrorResponse = false;
                } else if (string2.equals("Error")) {
                    this.receivedErrorResponse = true;
                }
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("CopyObjectResult") || this.in("CopyPartResult")) {
                if (string2.equals("LastModified")) {
                    this.result.setLastModifiedDate(ServiceUtils.parseIso8601Date(this.getText()));
                } else if (string2.equals("ETag")) {
                    this.result.setETag(ServiceUtils.removeQuotes(this.getText()));
                }
            } else if (this.in("Error")) {
                if (string2.equals("Code")) {
                    this.errorCode = this.getText();
                } else if (string2.equals("Message")) {
                    this.errorMessage = this.getText();
                } else if (string2.equals("RequestId")) {
                    this.errorRequestId = this.getText();
                } else if (string2.equals("HostId")) {
                    this.errorHostId = this.getText();
                }
            }
        }
    }

    public static class BucketLocationHandler
    extends AbstractHandler {
        private String location = null;

        public String getLocation() {
            return this.location;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.atTopLevel() && string2.equals("LocationConstraint")) {
                String string4 = this.getText();
                this.location = string4.length() == 0 ? null : string4;
            }
        }
    }

    public static class BucketLoggingConfigurationHandler
    extends AbstractHandler {
        private final BucketLoggingConfiguration bucketLoggingConfiguration = new BucketLoggingConfiguration();

        public BucketLoggingConfiguration getBucketLoggingConfiguration() {
            return this.bucketLoggingConfiguration;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("BucketLoggingStatus", "LoggingEnabled")) {
                if (string2.equals("TargetBucket")) {
                    this.bucketLoggingConfiguration.setDestinationBucketName(this.getText());
                } else if (string2.equals("TargetPrefix")) {
                    this.bucketLoggingConfiguration.setLogFilePrefix(this.getText());
                }
            }
        }
    }

    public static class AccessControlListHandler
    extends AbstractHandler {
        private final AccessControlList accessControlList = new AccessControlList();
        private Grantee currentGrantee = null;
        private Permission currentPermission = null;

        public AccessControlList getAccessControlList() {
            return this.accessControlList;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("AccessControlPolicy")) {
                if (string2.equals("Owner")) {
                    this.accessControlList.setOwner(new Owner());
                }
            } else if (this.in("AccessControlPolicy", "AccessControlList", "Grant") && string2.equals("Grantee")) {
                String string4 = XmlResponsesSaxParser.findAttributeValue("xsi:type", attributes);
                if ("AmazonCustomerByEmail".equals(string4)) {
                    this.currentGrantee = new EmailAddressGrantee(null);
                } else if ("CanonicalUser".equals(string4)) {
                    this.currentGrantee = new CanonicalGrantee(null);
                } else if ("Group".equals(string4)) {
                    // empty if block
                }
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("AccessControlPolicy", "Owner")) {
                if (string2.equals("ID")) {
                    this.accessControlList.getOwner().setId(this.getText());
                } else if (string2.equals("DisplayName")) {
                    this.accessControlList.getOwner().setDisplayName(this.getText());
                }
            } else if (this.in("AccessControlPolicy", "AccessControlList")) {
                if (string2.equals("Grant")) {
                    this.accessControlList.grantPermission(this.currentGrantee, this.currentPermission);
                    this.currentGrantee = null;
                    this.currentPermission = null;
                }
            } else if (this.in("AccessControlPolicy", "AccessControlList", "Grant")) {
                if (string2.equals("Permission")) {
                    this.currentPermission = Permission.parsePermission(this.getText());
                }
            } else if (this.in("AccessControlPolicy", "AccessControlList", "Grant", "Grantee")) {
                if (string2.equals("ID")) {
                    this.currentGrantee.setIdentifier(this.getText());
                } else if (string2.equals("EmailAddress")) {
                    this.currentGrantee.setIdentifier(this.getText());
                } else if (string2.equals("URI")) {
                    this.currentGrantee = GroupGrantee.parseGroupGrantee(this.getText());
                } else if (string2.equals("DisplayName")) {
                    ((CanonicalGrantee)this.currentGrantee).setDisplayName(this.getText());
                }
            }
        }
    }

    public static class ListAllMyBucketsHandler
    extends AbstractHandler {
        private final List<Bucket> buckets = new ArrayList<Bucket>();
        private Owner bucketsOwner = null;
        private Bucket currentBucket = null;

        public List<Bucket> getBuckets() {
            return this.buckets;
        }

        public Owner getOwner() {
            return this.bucketsOwner;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("ListAllMyBucketsResult")) {
                if (string2.equals("Owner")) {
                    this.bucketsOwner = new Owner();
                }
            } else if (this.in("ListAllMyBucketsResult", "Buckets") && string2.equals("Bucket")) {
                this.currentBucket = new Bucket();
                this.currentBucket.setOwner(this.bucketsOwner);
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("ListAllMyBucketsResult", "Owner")) {
                if (string2.equals("ID")) {
                    this.bucketsOwner.setId(this.getText());
                } else if (string2.equals("DisplayName")) {
                    this.bucketsOwner.setDisplayName(this.getText());
                }
            } else if (this.in("ListAllMyBucketsResult", "Buckets")) {
                if (string2.equals("Bucket")) {
                    this.buckets.add(this.currentBucket);
                    this.currentBucket = null;
                }
            } else if (this.in("ListAllMyBucketsResult", "Buckets", "Bucket")) {
                if (string2.equals("Name")) {
                    this.currentBucket.setName(this.getText());
                } else if (string2.equals("CreationDate")) {
                    Date date = DateUtils.parseISO8601Date((String)this.getText());
                    this.currentBucket.setCreationDate(date);
                }
            }
        }
    }

    public static class ListBucketHandler
    extends AbstractHandler {
        private final ObjectListing objectListing = new ObjectListing();
        private S3ObjectSummary currentObject = null;
        private Owner currentOwner = null;
        private String lastKey = null;

        public ObjectListing getObjectListing() {
            return this.objectListing;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("ListBucketResult")) {
                if (string2.equals("Contents")) {
                    this.currentObject = new S3ObjectSummary();
                    this.currentObject.setBucketName(this.objectListing.getBucketName());
                }
            } else if (this.in("ListBucketResult", "Contents") && string2.equals("Owner")) {
                this.currentOwner = new Owner();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.atTopLevel()) {
                if (!string2.equals("ListBucketResult") || !this.objectListing.isTruncated() || this.objectListing.getNextMarker() != null) return;
                String string4 = null;
                if (!this.objectListing.getObjectSummaries().isEmpty()) {
                    string4 = this.objectListing.getObjectSummaries().get(this.objectListing.getObjectSummaries().size() - 1).getKey();
                } else if (!this.objectListing.getCommonPrefixes().isEmpty()) {
                    string4 = this.objectListing.getCommonPrefixes().get(this.objectListing.getCommonPrefixes().size() - 1);
                } else {
                    log.error((Object)"S3 response indicates truncated results, but contains no object summaries or common prefixes.");
                }
                this.objectListing.setNextMarker(string4);
                return;
            } else if (this.in("ListBucketResult")) {
                if (string2.equals("Name")) {
                    this.objectListing.setBucketName(this.getText());
                    if (!log.isDebugEnabled()) return;
                    log.debug((Object)("Examining listing for bucket: " + this.objectListing.getBucketName()));
                    return;
                } else if (string2.equals("Prefix")) {
                    this.objectListing.setPrefix(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                    return;
                } else if (string2.equals("Marker")) {
                    this.objectListing.setMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                    return;
                } else if (string2.equals("NextMarker")) {
                    this.objectListing.setNextMarker(this.getText());
                    return;
                } else if (string2.equals("MaxKeys")) {
                    this.objectListing.setMaxKeys(XmlResponsesSaxParser.parseInt(this.getText()));
                    return;
                } else if (string2.equals("Delimiter")) {
                    this.objectListing.setDelimiter(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                    return;
                } else if (string2.equals("EncodingType")) {
                    this.objectListing.setEncodingType(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                    return;
                } else if (string2.equals("IsTruncated")) {
                    String string5 = this.getText().toLowerCase(Locale.getDefault());
                    if (string5.startsWith("false")) {
                        this.objectListing.setTruncated(false);
                        return;
                    } else {
                        if (!string5.startsWith("true")) throw new IllegalStateException("Invalid value for IsTruncated field: " + string5);
                        this.objectListing.setTruncated(true);
                    }
                    return;
                } else {
                    if (!string2.equals("Contents")) return;
                    this.objectListing.getObjectSummaries().add(this.currentObject);
                    this.currentObject = null;
                }
                return;
            } else if (this.in("ListBucketResult", "Contents")) {
                if (string2.equals("Key")) {
                    this.lastKey = this.getText();
                    this.currentObject.setKey(this.lastKey);
                    return;
                } else if (string2.equals("LastModified")) {
                    this.currentObject.setLastModified(ServiceUtils.parseIso8601Date(this.getText()));
                    return;
                } else if (string2.equals("ETag")) {
                    this.currentObject.setETag(ServiceUtils.removeQuotes(this.getText()));
                    return;
                } else if (string2.equals("Size")) {
                    this.currentObject.setSize(XmlResponsesSaxParser.parseLong(this.getText()));
                    return;
                } else if (string2.equals("StorageClass")) {
                    this.currentObject.setStorageClass(this.getText());
                    return;
                } else {
                    if (!string2.equals("Owner")) return;
                    this.currentObject.setOwner(this.currentOwner);
                    this.currentOwner = null;
                }
                return;
            } else if (this.in("ListBucketResult", "Contents", "Owner")) {
                if (string2.equals("ID")) {
                    this.currentOwner.setId(this.getText());
                    return;
                } else {
                    if (!string2.equals("DisplayName")) return;
                    this.currentOwner.setDisplayName(this.getText());
                }
                return;
            } else {
                if (!this.in("ListBucketResult", "CommonPrefixes") || !string2.equals("Prefix")) return;
                this.objectListing.getCommonPrefixes().add(this.getText());
            }
        }
    }
}

