/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.internal.crypto.AesCbc;
import com.amazonaws.services.s3.internal.crypto.AesCtr;
import com.amazonaws.services.s3.internal.crypto.AesGcm;
import com.amazonaws.services.s3.internal.crypto.CipherLite;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

abstract class ContentCryptoScheme {
    static final long MAX_GCM_BLOCKS = 0xFFFFFFFEL;
    static final long MAX_GCM_BYTES = 0xFFFFFFFE0L;
    static final long MAX_CBC_BYTES = 0x10000000000000L;
    static final long MAX_CTR_BYTES = -1L;
    static final ContentCryptoScheme AES_CBC = new AesCbc();
    static final ContentCryptoScheme AES_GCM = new AesGcm();
    static final ContentCryptoScheme AES_CTR = new AesCtr();

    ContentCryptoScheme() {
    }

    abstract String getKeyGeneratorAlgorithm();

    abstract String getCipherAlgorithm();

    String getSpecificCipherProvider() {
        return null;
    }

    abstract int getKeyLengthInBits();

    abstract int getBlockSizeInBytes();

    abstract int getIVLengthInBytes();

    int getTagLengthInBits() {
        return 0;
    }

    byte[] adjustIV(byte[] byArray, long l) {
        return byArray;
    }

    public String toString() {
        return "cipherAlgo=" + this.getCipherAlgorithm() + ", blockSizeInBytes=" + this.getBlockSizeInBytes() + ", ivLengthInBytes=" + this.getIVLengthInBytes() + ", keyGenAlgo=" + this.getKeyGeneratorAlgorithm() + ", keyLengthInBits=" + this.getKeyLengthInBits() + ", specificProvider=" + this.getSpecificCipherProvider() + ", tagLengthInBits=" + this.getTagLengthInBits();
    }

    static byte[] incrementBlocks(byte[] byArray, long l) {
        if (l == 0L) {
            return byArray;
        }
        if (byArray == null || byArray.length != 16) {
            throw new IllegalArgumentException();
        }
        if (l > 0xFFFFFFFEL) {
            throw new IllegalStateException();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        for (int i = 12; i <= 15; ++i) {
            byteBuffer.put(i - 8, byArray[i]);
        }
        long l2 = byteBuffer.getLong() + l;
        if (l2 > 0xFFFFFFFEL) {
            throw new IllegalStateException();
        }
        byteBuffer.rewind();
        byte[] byArray2 = byteBuffer.putLong(l2).array();
        for (int i = 12; i <= 15; ++i) {
            byArray[i] = byArray2[i - 8];
        }
        return byArray;
    }

    static ContentCryptoScheme fromCEKAlgo(String string) {
        return ContentCryptoScheme.fromCEKAlgo(string, false);
    }

    static ContentCryptoScheme fromCEKAlgo(String string, boolean bl) {
        if (AES_GCM.getCipherAlgorithm().equals(string)) {
            return bl ? AES_CTR : AES_GCM;
        }
        if (string == null || AES_CBC.getCipherAlgorithm().equals(string)) {
            return AES_CBC;
        }
        throw new UnsupportedOperationException("Unsupported content encryption scheme: " + string);
    }

    CipherLite createCipherLite(SecretKey secretKey, byte[] byArray, int n, Provider provider) {
        String string = this.getSpecificCipherProvider();
        try {
            Cipher cipher = string != null ? Cipher.getInstance(this.getCipherAlgorithm(), string) : (provider != null ? Cipher.getInstance(this.getCipherAlgorithm(), provider) : Cipher.getInstance(this.getCipherAlgorithm()));
            cipher.init(n, (Key)secretKey, new IvParameterSpec(byArray));
            return this.newCipherLite(cipher, secretKey, n);
        }
        catch (Exception exception) {
            throw exception instanceof RuntimeException ? (RuntimeException)exception : new AmazonClientException("Unable to build cipher: " + exception.getMessage() + "\nMake sure you have the JCE unlimited strength policy files installed and " + "configured for your JVM", (Throwable)exception);
        }
    }

    protected CipherLite newCipherLite(Cipher cipher, SecretKey secretKey, int n) {
        return new CipherLite(cipher, this, secretKey, n);
    }

    CipherLite createAuxillaryCipher(SecretKey secretKey, byte[] byArray, int n, Provider provider, long l) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return null;
    }

    CipherLite createCipherLite(SecretKey secretKey, byte[] byArray, int n) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        return this.createCipherLite(secretKey, byArray, n, null);
    }

    abstract long getMaxPlaintextSize();
}

