/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.services.s3.internal.HeaderHandler;
import com.amazonaws.services.s3.internal.S3XmlResponseHandler;
import com.amazonaws.transform.Unmarshaller;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

public class ResponseHeaderHandlerChain<T>
extends S3XmlResponseHandler<T> {
    private final List<HeaderHandler<T>> headerHandlers;

    public ResponseHeaderHandlerChain(Unmarshaller<T, InputStream> unmarshaller, HeaderHandler<T> ... headerHandlerArray) {
        super(unmarshaller);
        this.headerHandlers = Arrays.asList(headerHandlerArray);
    }

    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse httpResponse) throws Exception {
        AmazonWebServiceResponse amazonWebServiceResponse = super.handle(httpResponse);
        Object object = amazonWebServiceResponse.getResult();
        if (object != null) {
            for (HeaderHandler<Object> headerHandler : this.headerHandlers) {
                headerHandler.handle(object, httpResponse);
            }
        }
        return amazonWebServiceResponse;
    }
}

