/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.internal.SdkFilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5DigestCalculatingInputStream
extends SdkFilterInputStream {
    private MessageDigest digest;
    private MessageDigest digestLastMarked;

    public MD5DigestCalculatingInputStream(InputStream inputStream) {
        super(inputStream);
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("unexpected", noSuchAlgorithmException);
        }
    }

    public byte[] getMd5Digest() {
        return this.digest.digest();
    }

    public void mark(int n) {
        super.mark(n);
        if (this.markSupported()) {
            try {
                this.digestLastMarked = (MessageDigest)this.digest.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException("unexpected", cloneNotSupportedException);
            }
        }
    }

    public void reset() throws IOException {
        super.reset();
        if (this.digestLastMarked != null) {
            try {
                this.digest = (MessageDigest)this.digestLastMarked.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException("unexpected", cloneNotSupportedException);
            }
        }
    }

    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            this.digest.update((byte)n);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.digest.update(byArray, n, n3);
        }
        return n3;
    }
}

