/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transfermanager.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.mobileconnectors.s3.transfermanager.Download;
import com.amazonaws.mobileconnectors.s3.transfermanager.MultipleFileDownload;
import com.amazonaws.mobileconnectors.s3.transfermanager.Transfer;
import com.amazonaws.mobileconnectors.s3.transfermanager.TransferProgress;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.DownloadImpl;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.MultipleFileTransfer;
import java.io.IOException;
import java.util.Collection;

public class MultipleFileDownloadImpl
extends MultipleFileTransfer<Download>
implements MultipleFileDownload {
    private final String keyPrefix;
    private final String bucketName;

    public MultipleFileDownloadImpl(String string, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, String string2, String string3, Collection<? extends Download> collection) {
        super(string, transferProgress, progressListenerChain, collection);
        this.keyPrefix = string2;
        this.bucketName = string3;
    }

    @Override
    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public void waitForCompletion() throws AmazonClientException, AmazonServiceException, InterruptedException {
        if (this.subTransfers.isEmpty()) {
            return;
        }
        super.waitForCompletion();
    }

    @Override
    public void abort() throws IOException {
        for (Download download : this.subTransfers) {
            ((DownloadImpl)download).abortWithoutNotifyingStateChangeListener();
        }
        for (Download download : this.subTransfers) {
            ((DownloadImpl)download).notifyStateChangeListeners(Transfer.TransferState.Canceled);
        }
    }
}

