/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.transfer.Download;
import com.amazonaws.services.s3.transfer.PersistableDownload;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferProgress;
import com.amazonaws.services.s3.transfer.exception.PauseException;
import com.amazonaws.services.s3.transfer.internal.AbstractTransfer;
import com.amazonaws.services.s3.transfer.internal.S3ProgressPublisher;
import com.amazonaws.services.s3.transfer.internal.TransferManagerUtils;
import com.amazonaws.services.s3.transfer.internal.TransferStateChangeListener;
import java.io.File;
import java.io.IOException;

public class DownloadImpl
extends AbstractTransfer
implements Download {
    S3Object s3Object;
    private final PersistableDownload persistableDownload;

    public DownloadImpl(String string, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, S3Object s3Object, TransferStateChangeListener transferStateChangeListener, GetObjectRequest getObjectRequest, File file) {
        super(string, transferProgress, progressListenerChain, transferStateChangeListener);
        this.s3Object = s3Object;
        this.persistableDownload = this.captureDownloadState(getObjectRequest, file);
        S3ProgressPublisher.publishTransferPersistable((ProgressListener)progressListenerChain, this.persistableDownload);
    }

    @Override
    public ObjectMetadata getObjectMetadata() {
        return this.s3Object.getObjectMetadata();
    }

    @Override
    public String getBucketName() {
        return this.s3Object.getBucketName();
    }

    @Override
    public String getKey() {
        return this.s3Object.getKey();
    }

    @Override
    public synchronized void abort() throws IOException {
        this.monitor.getFuture().cancel(true);
        if (this.s3Object != null) {
            this.s3Object.getObjectContent().abort();
        }
        this.setState(Transfer.TransferState.Canceled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void abortWithoutNotifyingStateChangeListener() throws IOException {
        this.monitor.getFuture().cancel(true);
        DownloadImpl downloadImpl = this;
        synchronized (downloadImpl) {
            this.state = Transfer.TransferState.Canceled;
        }
    }

    public synchronized void setS3Object(S3Object s3Object) {
        this.s3Object = s3Object;
    }

    @Override
    public void setState(Transfer.TransferState transferState) {
        super.setState(transferState);
        if (transferState == Transfer.TransferState.Completed) {
            this.fireProgressEvent(4);
        }
    }

    private PersistableDownload captureDownloadState(GetObjectRequest getObjectRequest, File file) {
        if (getObjectRequest.getSSECustomerKey() == null) {
            return new PersistableDownload(getObjectRequest.getBucketName(), getObjectRequest.getKey(), getObjectRequest.getVersionId(), getObjectRequest.getRange(), getObjectRequest.getResponseHeaders(), getObjectRequest.isRequesterPays(), file.getAbsolutePath());
        }
        return null;
    }

    @Override
    public PersistableDownload pause() throws PauseException {
        boolean bl = true;
        Transfer.TransferState transferState = this.getState();
        this.monitor.getFuture().cancel(true);
        if (this.persistableDownload == null) {
            throw new PauseException(TransferManagerUtils.determinePauseStatus(transferState, bl));
        }
        return this.persistableDownload;
    }
}

