/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.ProgressListenerCallbackExecutor;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.internal.CopyCallable;
import com.amazonaws.services.s3.transfer.internal.CopyImpl;
import com.amazonaws.services.s3.transfer.internal.TransferMonitor;
import com.amazonaws.services.s3.transfer.model.CopyResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class CopyMonitor
implements Callable<CopyResult>,
TransferMonitor {
    private final AmazonS3 s3;
    private final ExecutorService threadPool;
    private final CopyObjectRequest copyObjectRequest;
    private ScheduledExecutorService timedThreadPool;
    private final CopyCallable multipartCopyCallable;
    private final CopyImpl transfer;
    private final ProgressListenerCallbackExecutor progressListenerChainCallbackExecutor;
    private String uploadId;
    private final List<Future<PartETag>> futures = new ArrayList<Future<PartETag>>();
    private boolean isCopyDone = false;
    private Future<CopyResult> nextFuture;
    private int pollInterval = 5000;

    public synchronized Future<CopyResult> getFuture() {
        return this.nextFuture;
    }

    private synchronized void setNextFuture(Future<CopyResult> future) {
        this.nextFuture = future;
    }

    @Override
    public synchronized boolean isDone() {
        return this.isCopyDone;
    }

    private synchronized void markAllDone() {
        this.isCopyDone = true;
    }

    public CopyMonitor(TransferManager transferManager, CopyImpl copyImpl, ExecutorService executorService, CopyCallable copyCallable, CopyObjectRequest copyObjectRequest, ProgressListenerChain progressListenerChain) {
        this.s3 = transferManager.getAmazonS3Client();
        this.multipartCopyCallable = copyCallable;
        this.threadPool = executorService;
        this.copyObjectRequest = copyObjectRequest;
        this.transfer = copyImpl;
        this.progressListenerChainCallbackExecutor = ProgressListenerCallbackExecutor.wrapListener((ProgressListener)progressListenerChain);
        this.setNextFuture(executorService.submit(this));
    }

    @Override
    public CopyResult call() throws Exception {
        try {
            if (this.uploadId == null) {
                return this.copy();
            }
            return this.poll();
        }
        catch (CancellationException cancellationException) {
            this.transfer.setState(Transfer.TransferState.Canceled);
            this.fireProgressEvent(16);
            throw new AmazonClientException("Upload canceled");
        }
        catch (Exception exception) {
            this.transfer.setState(Transfer.TransferState.Failed);
            this.fireProgressEvent(8);
            throw exception;
        }
    }

    public void setTimedThreadPool(ScheduledExecutorService scheduledExecutorService) {
        this.timedThreadPool = scheduledExecutorService;
    }

    private CopyResult poll() throws InterruptedException {
        for (Future<PartETag> future : this.futures) {
            if (future.isDone()) continue;
            this.reschedule();
            return null;
        }
        for (Future<PartETag> future : this.futures) {
            if (!future.isCancelled()) continue;
            throw new CancellationException();
        }
        return this.completeMultipartUpload();
    }

    private void fireProgressEvent(int n) {
        if (this.progressListenerChainCallbackExecutor == null) {
            return;
        }
        ProgressEvent progressEvent = new ProgressEvent(0L);
        progressEvent.setEventCode(n);
        this.progressListenerChainCallbackExecutor.progressChanged(progressEvent);
    }

    private CopyResult copy() throws Exception, InterruptedException {
        CopyResult copyResult = this.multipartCopyCallable.call();
        if (copyResult != null) {
            this.copyComplete();
        } else {
            this.uploadId = this.multipartCopyCallable.getMultipartUploadId();
            this.futures.addAll(this.multipartCopyCallable.getFutures());
            this.reschedule();
        }
        return copyResult;
    }

    private void copyComplete() {
        this.markAllDone();
        this.transfer.setState(Transfer.TransferState.Completed);
        if (this.multipartCopyCallable.isMultipartCopy()) {
            this.fireProgressEvent(4);
        }
    }

    private void reschedule() {
        this.setNextFuture(this.timedThreadPool.schedule(new Callable<CopyResult>(){

            @Override
            public CopyResult call() throws Exception {
                CopyMonitor.this.setNextFuture(CopyMonitor.this.threadPool.submit(CopyMonitor.this));
                return null;
            }
        }, (long)this.pollInterval, TimeUnit.MILLISECONDS));
    }

    private CopyResult completeMultipartUpload() {
        CompleteMultipartUploadResult completeMultipartUploadResult = this.s3.completeMultipartUpload(new CompleteMultipartUploadRequest(this.copyObjectRequest.getDestinationBucketName(), this.copyObjectRequest.getDestinationKey(), this.uploadId, this.collectPartETags()));
        this.copyComplete();
        CopyResult copyResult = new CopyResult();
        copyResult.setSourceBucketName(this.copyObjectRequest.getSourceBucketName());
        copyResult.setSourceKey(this.copyObjectRequest.getSourceKey());
        copyResult.setDestinationBucketName(completeMultipartUploadResult.getBucketName());
        copyResult.setDestinationKey(completeMultipartUploadResult.getKey());
        copyResult.setETag(completeMultipartUploadResult.getETag());
        copyResult.setVersionId(completeMultipartUploadResult.getVersionId());
        return copyResult;
    }

    private List<PartETag> collectPartETags() {
        ArrayList<PartETag> arrayList = new ArrayList<PartETag>(this.futures.size());
        for (Future<PartETag> future : this.futures) {
            try {
                arrayList.add(future.get());
            }
            catch (Exception exception) {
                throw new AmazonClientException("Unable to copy part: " + exception.getCause().getMessage(), exception.getCause());
            }
        }
        return arrayList;
    }
}

