/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.s3.internal.Constants;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public enum Region {
    US_Standard(null),
    US_West("us-west-1"),
    US_West_2("us-west-2"),
    US_GovCloud("s3-us-gov-west-1"),
    EU_Ireland("eu-west-1", "EU"),
    EU_Frankfurt("eu-central-1"),
    AP_Singapore("ap-southeast-1"),
    AP_Sydney("ap-southeast-2"),
    AP_Tokyo("ap-northeast-1"),
    SA_SaoPaulo("sa-east-1"),
    CN_Beijing("cn-north-1");

    public static final Pattern S3_REGIONAL_ENDPOINT_PATTERN;
    private final List<String> regionIds;

    private Region(String ... stringArray) {
        this.regionIds = stringArray != null ? Arrays.asList(stringArray) : null;
    }

    public String toString() {
        return this.getFirstRegionId0();
    }

    public String getFirstRegionId() {
        return this.getFirstRegionId0();
    }

    private String getFirstRegionId0() {
        return this.regionIds == null || this.regionIds.size() == 0 ? null : this.regionIds.get(0);
    }

    public static Region fromValue(String string) throws IllegalArgumentException {
        if (string == null || string.equals("US")) {
            return US_Standard;
        }
        for (Region region : Region.values()) {
            List<String> list = region.regionIds;
            if (list == null || !list.contains(string)) continue;
            return region;
        }
        throw new IllegalArgumentException("Cannot create enum from " + string + " value!");
    }

    public com.amazonaws.regions.Region toAWSRegion() {
        String string = this.getFirstRegionId();
        if (string == null) {
            return RegionUtils.getRegionByEndpoint((String)Constants.S3_HOSTNAME);
        }
        return RegionUtils.getRegion((String)string);
    }

    static {
        S3_REGIONAL_ENDPOINT_PATTERN = Pattern.compile("s3-([^.]+)\\.amazonaws\\.com");
    }
}

