/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.internal.SdkInputStream;
import com.amazonaws.services.s3.internal.crypto.JceEncryptionConstants;
import java.io.IOException;
import java.io.InputStream;

public class AdjustedRangeInputStream
extends SdkInputStream {
    private InputStream decryptedContents;
    private long virtualAvailable;
    private boolean closed;

    public AdjustedRangeInputStream(InputStream inputStream, long l, long l2) throws IOException {
        this.decryptedContents = inputStream;
        this.closed = false;
        this.initializeForRead(l, l2);
    }

    private void initializeForRead(long l, long l2) throws IOException {
        int n;
        if (l < (long)JceEncryptionConstants.SYMMETRIC_CIPHER_BLOCK_SIZE) {
            n = (int)l;
        } else {
            int n2 = (int)(l % (long)JceEncryptionConstants.SYMMETRIC_CIPHER_BLOCK_SIZE);
            n = JceEncryptionConstants.SYMMETRIC_CIPHER_BLOCK_SIZE + n2;
        }
        if (n != 0) {
            while (n > 0) {
                this.decryptedContents.read();
                --n;
            }
        }
        this.virtualAvailable = l2 - l + 1L;
    }

    public int read() throws IOException {
        this.abortIfNeeded();
        int n = 0;
        n = this.virtualAvailable <= 0L ? -1 : this.decryptedContents.read();
        if (n != -1) {
            --this.virtualAvailable;
        } else {
            this.close();
            this.virtualAvailable = 0L;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.abortIfNeeded();
        if (this.virtualAvailable <= 0L) {
            n3 = -1;
        } else {
            if ((long)n2 > this.virtualAvailable) {
                n2 = this.virtualAvailable < Integer.MAX_VALUE ? (int)this.virtualAvailable : Integer.MAX_VALUE;
            }
            n3 = this.decryptedContents.read(byArray, n, n2);
        }
        if (n3 != -1) {
            this.virtualAvailable -= (long)n3;
        } else {
            this.close();
            this.virtualAvailable = 0L;
        }
        return n3;
    }

    public int available() throws IOException {
        this.abortIfNeeded();
        int n = this.decryptedContents.available();
        if ((long)n < this.virtualAvailable) {
            return n;
        }
        return (int)this.virtualAvailable;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.decryptedContents.close();
        }
        this.abortIfNeeded();
    }

    protected InputStream getWrappedInputStream() {
        return this.decryptedContents;
    }
}

