/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.internal.SdkInputStream;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class RepeatableFileInputStream
extends SdkInputStream {
    private static final Log log = LogFactory.getLog(RepeatableFileInputStream.class);
    private final File file;
    private FileInputStream fis = null;
    private long bytesReadPastMarkPoint = 0L;
    private long markPoint = 0L;

    public RepeatableFileInputStream(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        this.fis = new FileInputStream(file);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void reset() throws IOException {
        this.fis.close();
        this.abortIfNeeded();
        this.fis = new FileInputStream(this.file);
        long l = 0L;
        for (long i = this.markPoint; i > 0L; i -= l) {
            l = this.fis.skip(i);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reset to mark point " + this.markPoint + " after returning " + this.bytesReadPastMarkPoint + " bytes"));
        }
        this.bytesReadPastMarkPoint = 0L;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        this.abortIfNeeded();
        this.markPoint += this.bytesReadPastMarkPoint;
        this.bytesReadPastMarkPoint = 0L;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Input stream marked at " + this.markPoint + " bytes"));
        }
    }

    public int available() throws IOException {
        this.abortIfNeeded();
        return this.fis.available();
    }

    public void close() throws IOException {
        this.fis.close();
        this.abortIfNeeded();
    }

    public int read() throws IOException {
        this.abortIfNeeded();
        int n = this.fis.read();
        if (n != -1) {
            ++this.bytesReadPastMarkPoint;
            return n;
        }
        return -1;
    }

    public long skip(long l) throws IOException {
        this.abortIfNeeded();
        long l2 = this.fis.skip(l);
        this.bytesReadPastMarkPoint += l2;
        return l2;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.abortIfNeeded();
        int n3 = this.fis.read(byArray, n, n2);
        this.bytesReadPastMarkPoint += (long)n3;
        return n3;
    }

    public InputStream getWrappedInputStream() {
        return this.fis;
    }
}

