/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class XmlWriter {
    List<String> tags = new ArrayList<String>();
    StringBuilder sb = new StringBuilder();

    public XmlWriter start(String string) {
        this.sb.append("<").append(string).append(">");
        this.tags.add(string);
        return this;
    }

    public XmlWriter start(String string, String string2, String string3) {
        this.sb.append("<").append(string);
        this.writeAttr(string2, string3);
        this.sb.append(">");
        this.tags.add(string);
        return this;
    }

    public XmlWriter start(String string, String[] stringArray, String[] stringArray2) {
        this.sb.append("<").append(string);
        for (int i = 0; i < Math.min(stringArray.length, stringArray2.length); ++i) {
            this.writeAttr(stringArray[i], stringArray2[i]);
        }
        this.sb.append(">");
        this.tags.add(string);
        return this;
    }

    public XmlWriter end() {
        assert (this.tags.size() > 0);
        String string = this.tags.remove(this.tags.size() - 1);
        this.sb.append("</").append(string).append(">");
        return this;
    }

    public byte[] getBytes() {
        assert (this.tags.size() == 0);
        return this.toString().getBytes(StringUtils.UTF8);
    }

    public String toString() {
        return this.sb.toString();
    }

    public XmlWriter value(String string) {
        this.appendEscapedString(string, this.sb);
        return this;
    }

    private void writeAttr(String string, String string2) {
        this.sb.append(' ').append(string).append("=\"");
        this.appendEscapedString(string2, this.sb);
        this.sb.append("\"");
    }

    private void appendEscapedString(String string, StringBuilder stringBuilder) {
        int n;
        if (string == null) {
            string = "";
        }
        int n2 = 0;
        int n3 = string.length();
        for (n = 0; n < n3; ++n) {
            String string2;
            char c = string.charAt(n);
            switch (c) {
                case '\t': {
                    string2 = "&#9;";
                    break;
                }
                case '\n': {
                    string2 = "&#10;";
                    break;
                }
                case '\r': {
                    string2 = "&#13;";
                    break;
                }
                case '&': {
                    string2 = "&amp;";
                    break;
                }
                case '\"': {
                    string2 = "&quot;";
                    break;
                }
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                default: {
                    string2 = null;
                }
            }
            if (string2 == null) continue;
            if (n2 < n) {
                stringBuilder.append(string, n2, n);
            }
            this.sb.append(string2);
            n2 = n + 1;
        }
        if (n2 < n) {
            this.sb.append(string, n2, n);
        }
    }
}

