/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.Request;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AwsChunkedEncodingInputStream;
import com.amazonaws.services.s3.internal.Constants;
import com.amazonaws.services.s3.internal.RepeatableInputStream;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.util.BinaryUtils;
import java.io.IOException;
import java.io.InputStream;

public class AWSS3V4Signer
extends AWS4Signer {
    private static final String CONTENT_SHA_256 = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";

    public AWSS3V4Signer() {
        super(false);
    }

    protected void processRequestPayload(Request<?> request, AWS4Signer.HeaderSigningResult headerSigningResult) {
        if (AWSS3V4Signer.useChunkEncoding(request)) {
            InputStream inputStream = request.getContent();
            String string = headerSigningResult.getDateTime();
            String string2 = headerSigningResult.getScope();
            byte[] byArray = headerSigningResult.getKSigning();
            String string3 = BinaryUtils.toHex((byte[])headerSigningResult.getSignature());
            AwsChunkedEncodingInputStream awsChunkedEncodingInputStream = new AwsChunkedEncodingInputStream(inputStream, byArray, string, string2, string3, (AWS4Signer)this);
            request.setContent((InputStream)awsChunkedEncodingInputStream);
        }
    }

    protected String calculateContentHashPresign(Request<?> request) {
        return "UNSIGNED-PAYLOAD";
    }

    protected String calculateContentHash(Request<?> request) {
        request.addHeader("x-amz-content-sha256", "required");
        if (AWSS3V4Signer.useChunkEncoding(request)) {
            long l;
            String string = (String)request.getHeaders().get("Content-Length");
            if (string != null) {
                l = Long.parseLong(string);
            } else {
                try {
                    l = AWSS3V4Signer.getContentLength(request);
                }
                catch (IOException iOException) {
                    throw new AmazonClientException("Cannot get the content-lenght of the request content.", (Throwable)iOException);
                }
            }
            request.addHeader("x-amz-decoded-content-length", Long.toString(l));
            request.addHeader("Content-Length", Long.toString(AwsChunkedEncodingInputStream.calculateStreamContentLength((long)l)));
            return CONTENT_SHA_256;
        }
        return super.calculateContentHash(request);
    }

    private static boolean useChunkEncoding(Request<?> request) {
        boolean bl = false;
        if (request.getOriginalRequest() instanceof PutObjectRequest || request.getOriginalRequest() instanceof UploadPartRequest) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getContentLength(Request<?> request) throws IOException {
        Object object = request.getContent();
        if (!((InputStream)object).markSupported()) {
            int n = Constants.getStreamBufferSize();
            object = new RepeatableInputStream((InputStream)object, n);
            request.setContent((InputStream)object);
        }
        long l = 0L;
        byte[] byArray = new byte[4096];
        try {
            int n;
            ((InputStream)object).mark(-1);
            while ((n = ((InputStream)object).read(byArray)) != -1) {
                l += (long)n;
            }
            ((InputStream)object).reset();
        }
        finally {
            ((InputStream)object).close();
        }
        return l;
    }
}

