/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AmazonS3URI {
    private static final Pattern ENDPOINT_PATTERN = Pattern.compile("^(.+\\.)?s3[.-]([a-z0-9-]+)\\.");
    private final URI uri;
    private final boolean isPathStyle;
    private final String bucket;
    private final String key;
    private final String region;

    public AmazonS3URI(String string) {
        this(URI.create(string));
    }

    public AmazonS3URI(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("uri cannot be null");
        }
        this.uri = uRI;
        String string = uRI.getHost();
        if (string == null) {
            throw new IllegalArgumentException("Invalid S3 URI: no hostname: " + uRI);
        }
        Matcher matcher = ENDPOINT_PATTERN.matcher(string);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid S3 URI: hostname does not appear to be a valid S3 endpoint: " + uRI);
        }
        String string2 = matcher.group(1);
        if (string2 == null || string2.isEmpty()) {
            this.isPathStyle = true;
            String string3 = uRI.getRawPath();
            if ("/".equals(string3)) {
                this.bucket = null;
                this.key = null;
            } else {
                int n = string3.indexOf(47, 1);
                if (n == -1) {
                    this.bucket = AmazonS3URI.decode(string3.substring(1));
                    this.key = null;
                } else if (n == string3.length() - 1) {
                    this.bucket = AmazonS3URI.decode(string3.substring(1, n));
                    this.key = null;
                } else {
                    this.bucket = AmazonS3URI.decode(string3.substring(1, n));
                    this.key = AmazonS3URI.decode(string3.substring(n + 1));
                }
            }
        } else {
            this.isPathStyle = false;
            this.bucket = string2.substring(0, string2.length() - 1);
            this.key = "/".equals(uRI.getPath()) ? null : uRI.getPath().substring(1);
        }
        this.region = "amazonaws".equals(matcher.group(2)) ? null : matcher.group(2);
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean isPathStyle() {
        return this.isPathStyle;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String getRegion() {
        return this.region;
    }

    public String toString() {
        return this.uri.toString();
    }

    private static String decode(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '%') continue;
            return AmazonS3URI.decode(string, i);
        }
        return string;
    }

    private static String decode(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.substring(0, n));
        AmazonS3URI.appendDecoded(stringBuilder, string, n);
        for (int i = n + 3; i < string.length(); ++i) {
            if (string.charAt(i) == '%') {
                AmazonS3URI.appendDecoded(stringBuilder, string, i);
                i += 2;
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    private static void appendDecoded(StringBuilder stringBuilder, String string, int n) {
        if (n > string.length() - 3) {
            throw new IllegalStateException("Invalid percent-encoded string:\"" + string + "\".");
        }
        char c = string.charAt(n + 1);
        char c2 = string.charAt(n + 2);
        char c3 = (char)(AmazonS3URI.fromHex(c) << 4 | AmazonS3URI.fromHex(c2));
        stringBuilder.append(c3);
    }

    private static int fromHex(char c) {
        if (c < '0') {
            throw new IllegalStateException("Invalid percent-encoded string: bad character '" + c + "' in " + "escape sequence.");
        }
        if (c <= '9') {
            return c - 48;
        }
        if (c < 'A') {
            throw new IllegalStateException("Invalid percent-encoded string: bad character '" + c + "' in " + "escape sequence.");
        }
        if (c <= 'F') {
            return c - 65 + 10;
        }
        if (c < 'a') {
            throw new IllegalStateException("Invalid percent-encoded string: bad character '" + c + "' in " + "escape sequence.");
        }
        if (c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalStateException("Invalid percent-encoded string: bad character '" + c + "' in " + "escape sequence.");
    }
}

