/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.client;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.mobile.auth.core.IdentityManager;
import com.amazonaws.mobile.auth.core.StartupAuthResult;
import com.amazonaws.mobile.auth.core.StartupAuthResultHandler;
import com.amazonaws.mobile.auth.core.signin.SignInProvider;
import com.amazonaws.mobile.auth.facebook.FacebookSignInProvider;
import com.amazonaws.mobile.auth.google.GoogleSignInProvider;
import com.amazonaws.mobile.auth.userpools.CognitoUserPoolsSignInProvider;
import com.amazonaws.mobile.client.AWSStartupHandler;
import com.amazonaws.mobile.client.AWSStartupResult;
import com.amazonaws.mobile.config.AWSConfigurable;
import com.amazonaws.mobile.config.AWSConfiguration;
import java.util.LinkedHashMap;

public final class AWSMobileClient {
    private static final String LOG_TAG = AWSMobileClient.class.getSimpleName();
    private final LinkedHashMap<Class<? extends AWSConfigurable>, AWSConfigurable> clientMap;
    private static volatile AWSMobileClient singleton = null;
    private AWSCredentialsProvider awsCredentialsProvider;
    private AWSConfiguration awsConfiguration;
    private SignInProviderConfig[] signInProviderConfig;
    private StartupAuthResultHandler startupAuthResultHandler;
    private AWSStartupHandler awsStartupHandler;
    private boolean defaultConfig = true;
    private static final String USER_POOLS = "CognitoUserPool";
    private static final String FACEBOOK = "FacebookSignIn";
    private static final String GOOGLE = "GoogleSignIn";
    private static final String PERMISSIONS = "Permissions";

    private AWSMobileClient() {
        if (singleton != null) {
            throw new AssertionError();
        }
        this.clientMap = new LinkedHashMap();
    }

    public InitializeBuilder initialize(Context context) {
        this.awsStartupHandler = new AWSStartupHandler(){

            @Override
            public void onComplete(AWSStartupResult awsStartupResult) {
                Log.d((String)LOG_TAG, (String)"AWSMobileClient Initialize succeeded.");
                Log.i((String)LOG_TAG, (String)"Welcome to AWS! You are connected successfully.");
            }
        };
        return this.initialize(context, this.awsStartupHandler);
    }

    public InitializeBuilder initialize(Context context, final AWSStartupHandler awsStartupHandler) {
        this.awsConfiguration = new AWSConfiguration(context.getApplicationContext());
        this.signInProviderConfig = null;
        this.startupAuthResultHandler = new StartupAuthResultHandler(){

            public void onComplete(StartupAuthResult startupAuthResult) {
                Log.i((String)LOG_TAG, (String)"Welcome to AWS! You are connected successfully.");
                if (startupAuthResult.isIdentityIdAvailable()) {
                    Log.i((String)LOG_TAG, (String)"Identity ID retrieved.");
                }
                awsStartupHandler.onComplete(new AWSStartupResult(IdentityManager.getDefaultIdentityManager()));
            }
        };
        this.awsStartupHandler = awsStartupHandler;
        return new InitializeBuilder(context);
    }

    private void initializeWithBuilder(InitializeBuilder initializeBuilder) {
        if (initializeBuilder.getAwsConfiguration() != null) {
            this.awsConfiguration = initializeBuilder.getAwsConfiguration();
        }
        if (initializeBuilder.getSignInProviderConfig() != null) {
            this.signInProviderConfig = initializeBuilder.getSignInProviderConfig();
        }
        try {
            this.fetchCognitoIdentity(initializeBuilder.getContext(), this.startupAuthResultHandler);
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)"Error in initializing the AWSMobileClient. Check if AWS Cloud Config `awsconfiguration.json` is present in the application.");
        }
    }

    public AWSConfigurable getClient(Context context, Class<? extends AWSConfigurable> clientClass) {
        AWSConfigurable client = this.clientMap.get(clientClass);
        Log.d((String)LOG_TAG, (String)("Retrieving the client instance for class: " + clientClass));
        try {
            if (client == null) {
                client = clientClass.newInstance().initialize(context.getApplicationContext(), this.awsConfiguration);
                this.clientMap.put(clientClass, client);
                Log.d((String)LOG_TAG, (String)("Created the new client: " + client));
            }
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)("Error occurred in creating and initializing client: " + clientClass), (Throwable)exception);
        }
        return client;
    }

    public AWSCredentialsProvider getCredentialsProvider() {
        if (this.awsCredentialsProvider != null) {
            return this.awsCredentialsProvider;
        }
        return IdentityManager.getDefaultIdentityManager().getUnderlyingProvider();
    }

    public void setCredentialsProvider(AWSCredentialsProvider awsCredentialsProvider) {
        this.awsCredentialsProvider = awsCredentialsProvider;
    }

    public AWSConfiguration getConfiguration() {
        return this.awsConfiguration;
    }

    public static synchronized AWSMobileClient getInstance() {
        if (singleton == null) {
            singleton = new AWSMobileClient();
        }
        return singleton;
    }

    private void fetchCognitoIdentity(Context context, StartupAuthResultHandler startupAuthResultHandler) {
        try {
            Log.d((String)LOG_TAG, (String)"Fetching the Cognito Identity.");
            IdentityManager identityManager = new IdentityManager(context, this.awsConfiguration);
            IdentityManager.setDefaultIdentityManager((IdentityManager)identityManager);
            if (this.signInProviderConfig == null) {
                this.registerConfigSignInProviders();
            } else {
                this.registerUserSignInProvidersWithPermissions();
            }
            this.resumeSession((Activity)context, startupAuthResultHandler);
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)"Error occurred in fetching the Cognito Identity and resuming the auth session", (Throwable)exception);
        }
    }

    private void registerUserSignInProvidersWithPermissions() {
        Log.d((String)LOG_TAG, (String)"Using the SignInProviderConfig supplied by the user.");
        IdentityManager identityManager = IdentityManager.getDefaultIdentityManager();
        for (SignInProviderConfig config : this.signInProviderConfig) {
            identityManager.addSignInProvider(config.getSignInProviderClass());
            if (config.getProviderPermissions() == null) continue;
            if (FacebookSignInProvider.class.isInstance(config.getSignInProviderClass())) {
                FacebookSignInProvider.setPermissions((String[])config.getProviderPermissions());
            }
            if (!GoogleSignInProvider.class.isInstance(config.getSignInProviderClass())) continue;
            GoogleSignInProvider.setPermissions((String[])config.getProviderPermissions());
        }
    }

    private void registerConfigSignInProviders() {
        Log.d((String)LOG_TAG, (String)"Using the SignInProviderConfig from awsconfiguration.json.");
        IdentityManager identityManager = IdentityManager.getDefaultIdentityManager();
        if (this.configHasKey(USER_POOLS)) {
            identityManager.addSignInProvider(CognitoUserPoolsSignInProvider.class);
        }
        if (this.configHasKey(FACEBOOK)) {
            identityManager.addSignInProvider(FacebookSignInProvider.class);
        }
        if (this.configHasKey(GOOGLE)) {
            identityManager.addSignInProvider(GoogleSignInProvider.class);
        }
    }

    private boolean configHasKey(String configKey) {
        try {
            if (configKey == GOOGLE) {
                return this.awsConfiguration.optJsonObject(configKey).getString("ClientId-WebApp") != null;
            }
            return this.awsConfiguration.optJsonObject(configKey) != null;
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)("Error in reading awsconfiguration.json for " + configKey), (Throwable)exception);
            return false;
        }
    }

    private void resumeSession(Activity callingActivity, StartupAuthResultHandler startupAuthResultHandler) {
        IdentityManager.getDefaultIdentityManager().resumeSession(callingActivity, startupAuthResultHandler);
    }

    public class SignInProviderConfig {
        private Class<? extends SignInProvider> signInProvider;
        private String[] providerPermissions;

        public SignInProviderConfig(Class<? extends SignInProvider> signInProvider, String ... providerPermissions) {
            this.signInProvider = signInProvider;
            this.providerPermissions = providerPermissions;
        }

        public Class<? extends SignInProvider> getSignInProviderClass() {
            return this.signInProvider;
        }

        public String[] getProviderPermissions() {
            return this.providerPermissions;
        }
    }

    public class InitializeBuilder {
        private Context context;
        private AWSConfiguration awsConfiguration;
        private SignInProviderConfig[] signInProviderConfig;

        public InitializeBuilder() {
            this.context = null;
            this.awsConfiguration = null;
            this.signInProviderConfig = null;
        }

        public InitializeBuilder(Context context) {
            this.context = context;
            this.awsConfiguration = null;
            this.signInProviderConfig = null;
        }

        public InitializeBuilder awsConfiguration(AWSConfiguration awsConfiguration) {
            this.awsConfiguration = awsConfiguration;
            return this;
        }

        public InitializeBuilder signInProviders(SignInProviderConfig ... providersConfig) {
            this.signInProviderConfig = providersConfig;
            return this;
        }

        public AWSConfiguration getAwsConfiguration() {
            return this.awsConfiguration;
        }

        public SignInProviderConfig[] getSignInProviderConfig() {
            return this.signInProviderConfig;
        }

        public Context getContext() {
            return this.context;
        }

        public void execute() {
            AWSMobileClient.this.initializeWithBuilder(this);
        }
    }
}

