/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.client;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSAbstractCognitoIdentityProvider;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentity;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityClient;

class AWSMobileClientCognitoIdentityProvider
extends AWSAbstractCognitoIdentityProvider {
    boolean isDeveloperAuthenticated;

    public AWSMobileClientCognitoIdentityProvider(String accountId, String identityPoolId) {
        this(accountId, identityPoolId, new ClientConfiguration());
    }

    public AWSMobileClientCognitoIdentityProvider(String accountId, String identityPoolId, ClientConfiguration clientConfiguration) {
        this(accountId, identityPoolId, (AmazonCognitoIdentity)new AmazonCognitoIdentityClient((AWSCredentials)new AnonymousAWSCredentials(), clientConfiguration));
    }

    public AWSMobileClientCognitoIdentityProvider(String accountId, String identityPoolId, AmazonCognitoIdentity cibClient) {
        super(accountId, identityPoolId, cibClient);
    }

    protected String getUserAgent() {
        return "AWSMobileClient";
    }

    void setDeveloperAuthenticated(String identityId, String token) {
        super.setIdentityId(identityId);
        super.setToken(token);
        this.isDeveloperAuthenticated = true;
    }

    void setNotDeveloperAuthenticated() {
        this.isDeveloperAuthenticated = false;
    }

    public String getProviderName() {
        return "Cognito";
    }

    public String refresh() {
        if (this.isDeveloperAuthenticated) {
            return this.token;
        }
        this.getIdentityId();
        return null;
    }
}

