/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.client;

import android.app.Activity;

public class SignInUIOptions {
    private final Builder builder;

    SignInUIOptions(Builder builder) {
        this.builder = builder;
    }

    public Integer getLogo() {
        return this.builder.logo;
    }

    public Integer getBackgroundColor() {
        return this.builder.backgroundColor;
    }

    public boolean canCancel() {
        return this.builder.canCancel;
    }

    public Class<? extends Activity> nextActivity() {
        return this.builder.nextActivityClass;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer logo;
        private Integer backgroundColor;
        private boolean canCancel;
        private Class<? extends Activity> nextActivityClass;

        public Builder logo(Integer logoResourceId) {
            this.logo = logoResourceId;
            return this;
        }

        public Builder backgroundColor(Integer logoResourceId) {
            this.backgroundColor = logoResourceId;
            return this;
        }

        public Builder canCancel(boolean canCancel) {
            this.canCancel = canCancel;
            return this;
        }

        public Builder nextActivity(Class<? extends Activity> nextActivityClass) {
            this.nextActivityClass = nextActivityClass;
            return this;
        }

        public SignInUIOptions build() {
            return new SignInUIOptions(this);
        }
    }
}

