/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kms.model.DeriveSharedSecretRequest;
import com.amazonaws.services.kms.model.RecipientInfo;
import com.amazonaws.services.kms.model.transform.RecipientInfoJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.List;

public class DeriveSharedSecretRequestMarshaller
implements Marshaller<Request<DeriveSharedSecretRequest>, DeriveSharedSecretRequest> {
    public Request<DeriveSharedSecretRequest> marshall(DeriveSharedSecretRequest deriveSharedSecretRequest) {
        if (deriveSharedSecretRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DeriveSharedSecretRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deriveSharedSecretRequest, "AWSKMS");
        String target = "TrentService.DeriveSharedSecret";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (deriveSharedSecretRequest.getKeyId() != null) {
                String keyId = deriveSharedSecretRequest.getKeyId();
                jsonWriter.name("KeyId");
                jsonWriter.value(keyId);
            }
            if (deriveSharedSecretRequest.getKeyAgreementAlgorithm() != null) {
                String keyAgreementAlgorithm = deriveSharedSecretRequest.getKeyAgreementAlgorithm();
                jsonWriter.name("KeyAgreementAlgorithm");
                jsonWriter.value(keyAgreementAlgorithm);
            }
            if (deriveSharedSecretRequest.getPublicKey() != null) {
                ByteBuffer publicKey = deriveSharedSecretRequest.getPublicKey();
                jsonWriter.name("PublicKey");
                jsonWriter.value(publicKey);
            }
            if (deriveSharedSecretRequest.getGrantTokens() != null) {
                List<String> grantTokens = deriveSharedSecretRequest.getGrantTokens();
                jsonWriter.name("GrantTokens");
                jsonWriter.beginArray();
                for (String grantTokensItem : grantTokens) {
                    if (grantTokensItem == null) continue;
                    jsonWriter.value(grantTokensItem);
                }
                jsonWriter.endArray();
            }
            if (deriveSharedSecretRequest.getDryRun() != null) {
                Boolean dryRun = deriveSharedSecretRequest.getDryRun();
                jsonWriter.name("DryRun");
                jsonWriter.value(dryRun.booleanValue());
            }
            if (deriveSharedSecretRequest.getRecipient() != null) {
                RecipientInfo recipient = deriveSharedSecretRequest.getRecipient();
                jsonWriter.name("Recipient");
                RecipientInfoJsonMarshaller.getInstance().marshall(recipient, jsonWriter);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

