/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.services.kms.model.KeyMetadata;
import com.amazonaws.services.kms.model.transform.MultiRegionConfigurationJsonUnmarshaller;
import com.amazonaws.services.kms.model.transform.XksKeyConfigurationTypeJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class KeyMetadataJsonUnmarshaller
implements Unmarshaller<KeyMetadata, JsonUnmarshallerContext> {
    private static KeyMetadataJsonUnmarshaller instance;

    KeyMetadataJsonUnmarshaller() {
    }

    public KeyMetadata unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        KeyMetadata keyMetadata = new KeyMetadata();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("AWSAccountId")) {
                keyMetadata.setAWSAccountId(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("KeyId")) {
                keyMetadata.setKeyId(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Arn")) {
                keyMetadata.setArn(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("CreationDate")) {
                keyMetadata.setCreationDate(SimpleTypeJsonUnmarshallers.DateJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Enabled")) {
                keyMetadata.setEnabled(SimpleTypeJsonUnmarshallers.BooleanJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Description")) {
                keyMetadata.setDescription(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("KeyUsage")) {
                keyMetadata.setKeyUsage(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("KeyState")) {
                keyMetadata.setKeyState(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("DeletionDate")) {
                keyMetadata.setDeletionDate(SimpleTypeJsonUnmarshallers.DateJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("ValidTo")) {
                keyMetadata.setValidTo(SimpleTypeJsonUnmarshallers.DateJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Origin")) {
                keyMetadata.setOrigin(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("CustomKeyStoreId")) {
                keyMetadata.setCustomKeyStoreId(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("CloudHsmClusterId")) {
                keyMetadata.setCloudHsmClusterId(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("ExpirationModel")) {
                keyMetadata.setExpirationModel(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("KeyManager")) {
                keyMetadata.setKeyManager(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("CustomerMasterKeySpec")) {
                keyMetadata.setCustomerMasterKeySpec(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("KeySpec")) {
                keyMetadata.setKeySpec(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("EncryptionAlgorithms")) {
                keyMetadata.setEncryptionAlgorithms(new ListUnmarshaller((Unmarshaller)SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("SigningAlgorithms")) {
                keyMetadata.setSigningAlgorithms(new ListUnmarshaller((Unmarshaller)SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("KeyAgreementAlgorithms")) {
                keyMetadata.setKeyAgreementAlgorithms(new ListUnmarshaller((Unmarshaller)SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("MultiRegion")) {
                keyMetadata.setMultiRegion(SimpleTypeJsonUnmarshallers.BooleanJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("MultiRegionConfiguration")) {
                keyMetadata.setMultiRegionConfiguration(MultiRegionConfigurationJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("PendingDeletionWindowInDays")) {
                keyMetadata.setPendingDeletionWindowInDays(SimpleTypeJsonUnmarshallers.IntegerJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("MacAlgorithms")) {
                keyMetadata.setMacAlgorithms(new ListUnmarshaller((Unmarshaller)SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("XksKeyConfiguration")) {
                keyMetadata.setXksKeyConfiguration(XksKeyConfigurationTypeJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return keyMetadata;
    }

    public static KeyMetadataJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new KeyMetadataJsonUnmarshaller();
        }
        return instance;
    }
}

