/*
 * Copyright 2010-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonServiceException;

/**
 * <p>
 * The request was rejected because the <code>XksProxyUriEndpoint</code> is
 * already associated with another external key store in this Amazon Web
 * Services Region. To identify the cause, see the error message that
 * accompanies the exception.
 * </p>
 */
public class XksProxyUriEndpointInUseException extends AmazonServiceException {
    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new XksProxyUriEndpointInUseException with the specified
     * error message.
     *
     * @param message Describes the error encountered.
     */
    public XksProxyUriEndpointInUseException(String message) {
        super(message);
    }
}
