/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.kms.model.CreateGrantRequest;
import com.amazonaws.services.kms.model.GrantConstraints;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class CreateGrantRequestMarshaller
implements Marshaller<Request<CreateGrantRequest>, CreateGrantRequest> {
    public Request<CreateGrantRequest> marshall(CreateGrantRequest createGrantRequest) {
        if (createGrantRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createGrantRequest, "AWSKMS");
        String target = "TrentService.CreateGrant";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag grantTokensList;
            GrantConstraints constraints;
            ListWithAutoConstructFlag operationsList;
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (createGrantRequest.getKeyId() != null) {
                jsonWriter.name("KeyId").value(createGrantRequest.getKeyId());
            }
            if (createGrantRequest.getGranteePrincipal() != null) {
                jsonWriter.name("GranteePrincipal").value(createGrantRequest.getGranteePrincipal());
            }
            if (createGrantRequest.getRetiringPrincipal() != null) {
                jsonWriter.name("RetiringPrincipal").value(createGrantRequest.getRetiringPrincipal());
            }
            if (!((operationsList = (ListWithAutoConstructFlag)createGrantRequest.getOperations()) == null || operationsList.isAutoConstruct() && operationsList.isEmpty())) {
                jsonWriter.name("Operations");
                jsonWriter.beginArray();
                for (Object operationsListValue : operationsList) {
                    if (operationsListValue == null) continue;
                    jsonWriter.value((String)operationsListValue);
                }
                jsonWriter.endArray();
            }
            if ((constraints = createGrantRequest.getConstraints()) != null) {
                jsonWriter.name("Constraints");
                jsonWriter.beginObject();
                if (constraints.getEncryptionContextSubset() != null) {
                    jsonWriter.name("EncryptionContextSubset");
                    jsonWriter.beginObject();
                    for (Map.Entry<String, String> encryptionContextSubsetListValue : constraints.getEncryptionContextSubset().entrySet()) {
                        if (encryptionContextSubsetListValue.getValue() == null) continue;
                        jsonWriter.name(encryptionContextSubsetListValue.getKey());
                        jsonWriter.value(encryptionContextSubsetListValue.getValue());
                    }
                    jsonWriter.endObject();
                }
                if (constraints.getEncryptionContextEquals() != null) {
                    jsonWriter.name("EncryptionContextEquals");
                    jsonWriter.beginObject();
                    for (Map.Entry<String, String> encryptionContextEqualsListValue : constraints.getEncryptionContextEquals().entrySet()) {
                        if (encryptionContextEqualsListValue.getValue() == null) continue;
                        jsonWriter.name((String)encryptionContextEqualsListValue.getKey());
                        jsonWriter.value((String)encryptionContextEqualsListValue.getValue());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (!((grantTokensList = (ListWithAutoConstructFlag)createGrantRequest.getGrantTokens()) == null || grantTokensList.isAutoConstruct() && grantTokensList.isEmpty())) {
                jsonWriter.name("GrantTokens");
                jsonWriter.beginArray();
                for (String grantTokensListValue : grantTokensList) {
                    if (grantTokensListValue == null) continue;
                    jsonWriter.value(grantTokensListValue);
                }
                jsonWriter.endArray();
            }
            if (createGrantRequest.getName() != null) {
                jsonWriter.name("Name").value(createGrantRequest.getName());
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

