/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.services.kinesis.model.HashKeyRange;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class HashKeyRangeJsonUnmarshaller
implements Unmarshaller<HashKeyRange, JsonUnmarshallerContext> {
    private static HashKeyRangeJsonUnmarshaller instance;

    HashKeyRangeJsonUnmarshaller() {
    }

    public HashKeyRange unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        HashKeyRange hashKeyRange = new HashKeyRange();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("StartingHashKey")) {
                hashKeyRange.setStartingHashKey(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("EndingHashKey")) {
                hashKeyRange.setEndingHashKey(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return hashKeyRange;
    }

    public static HashKeyRangeJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new HashKeyRangeJsonUnmarshaller();
        }
        return instance;
    }
}

