/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;

public class GetShardIteratorRequestMarshaller
implements Marshaller<Request<GetShardIteratorRequest>, GetShardIteratorRequest> {
    public Request<GetShardIteratorRequest> marshall(GetShardIteratorRequest getShardIteratorRequest) {
        if (getShardIteratorRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetShardIteratorRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getShardIteratorRequest, "AmazonKinesis");
        String target = "Kinesis_20131202.GetShardIterator";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (getShardIteratorRequest.getStreamName() != null) {
                String streamName = getShardIteratorRequest.getStreamName();
                jsonWriter.name("StreamName");
                jsonWriter.value(streamName);
            }
            if (getShardIteratorRequest.getShardId() != null) {
                String shardId = getShardIteratorRequest.getShardId();
                jsonWriter.name("ShardId");
                jsonWriter.value(shardId);
            }
            if (getShardIteratorRequest.getShardIteratorType() != null) {
                String shardIteratorType = getShardIteratorRequest.getShardIteratorType();
                jsonWriter.name("ShardIteratorType");
                jsonWriter.value(shardIteratorType);
            }
            if (getShardIteratorRequest.getStartingSequenceNumber() != null) {
                String startingSequenceNumber = getShardIteratorRequest.getStartingSequenceNumber();
                jsonWriter.name("StartingSequenceNumber");
                jsonWriter.value(startingSequenceNumber);
            }
            if (getShardIteratorRequest.getTimestamp() != null) {
                Date timestamp = getShardIteratorRequest.getTimestamp();
                jsonWriter.name("Timestamp");
                jsonWriter.value(timestamp);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

