/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.CreateBackupRequest;
import com.amazonaws.services.dynamodbv2.model.CreateBackupResult;
import com.amazonaws.services.dynamodbv2.model.CreateGlobalTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateGlobalTableResult;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteBackupRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteBackupResult;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeBackupRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeBackupResult;
import com.amazonaws.services.dynamodbv2.model.DescribeContinuousBackupsRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeContinuousBackupsResult;
import com.amazonaws.services.dynamodbv2.model.DescribeGlobalTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeGlobalTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeGlobalTableSettingsRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeGlobalTableSettingsResult;
import com.amazonaws.services.dynamodbv2.model.DescribeLimitsRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeLimitsResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTimeToLiveRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTimeToLiveResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.ListBackupsRequest;
import com.amazonaws.services.dynamodbv2.model.ListBackupsResult;
import com.amazonaws.services.dynamodbv2.model.ListGlobalTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListGlobalTablesResult;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.ListTagsOfResourceRequest;
import com.amazonaws.services.dynamodbv2.model.ListTagsOfResourceResult;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.RestoreTableFromBackupRequest;
import com.amazonaws.services.dynamodbv2.model.RestoreTableFromBackupResult;
import com.amazonaws.services.dynamodbv2.model.RestoreTableToPointInTimeRequest;
import com.amazonaws.services.dynamodbv2.model.RestoreTableToPointInTimeResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.TagResourceRequest;
import com.amazonaws.services.dynamodbv2.model.UntagResourceRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateContinuousBackupsRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateContinuousBackupsResult;
import com.amazonaws.services.dynamodbv2.model.UpdateGlobalTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateGlobalTableResult;
import com.amazonaws.services.dynamodbv2.model.UpdateGlobalTableSettingsRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateGlobalTableSettingsResult;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTimeToLiveRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTimeToLiveResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonDynamoDBAsyncClient
extends AmazonDynamoDBClient
implements AmazonDynamoDBAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;

    @Deprecated
    public AmazonDynamoDBAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    @Deprecated
    public AmazonDynamoDBAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonDynamoDBAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(10));
    }

    public AmazonDynamoDBAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonDynamoDBAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(10));
    }

    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(final BatchGetItemRequest batchGetItemRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<BatchGetItemResult>(){

            @Override
            public BatchGetItemResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.batchGetItem(batchGetItemRequest);
            }
        });
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(final BatchGetItemRequest batchGetItemRequest, final AsyncHandler<BatchGetItemRequest, BatchGetItemResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<BatchGetItemResult>(){

            @Override
            public BatchGetItemResult call() throws Exception {
                BatchGetItemResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.batchGetItem(batchGetItemRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)batchGetItemRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<BatchWriteItemResult> batchWriteItemAsync(final BatchWriteItemRequest batchWriteItemRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<BatchWriteItemResult>(){

            @Override
            public BatchWriteItemResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.batchWriteItem(batchWriteItemRequest);
            }
        });
    }

    @Override
    public Future<BatchWriteItemResult> batchWriteItemAsync(final BatchWriteItemRequest batchWriteItemRequest, final AsyncHandler<BatchWriteItemRequest, BatchWriteItemResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<BatchWriteItemResult>(){

            @Override
            public BatchWriteItemResult call() throws Exception {
                BatchWriteItemResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.batchWriteItem(batchWriteItemRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)batchWriteItemRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateBackupResult> createBackupAsync(final CreateBackupRequest createBackupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateBackupResult>(){

            @Override
            public CreateBackupResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.createBackup(createBackupRequest);
            }
        });
    }

    @Override
    public Future<CreateBackupResult> createBackupAsync(final CreateBackupRequest createBackupRequest, final AsyncHandler<CreateBackupRequest, CreateBackupResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateBackupResult>(){

            @Override
            public CreateBackupResult call() throws Exception {
                CreateBackupResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.createBackup(createBackupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createBackupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateGlobalTableResult> createGlobalTableAsync(final CreateGlobalTableRequest createGlobalTableRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateGlobalTableResult>(){

            @Override
            public CreateGlobalTableResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.createGlobalTable(createGlobalTableRequest);
            }
        });
    }

    @Override
    public Future<CreateGlobalTableResult> createGlobalTableAsync(final CreateGlobalTableRequest createGlobalTableRequest, final AsyncHandler<CreateGlobalTableRequest, CreateGlobalTableResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateGlobalTableResult>(){

            @Override
            public CreateGlobalTableResult call() throws Exception {
                CreateGlobalTableResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.createGlobalTable(createGlobalTableRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createGlobalTableRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateTableResult> createTableAsync(final CreateTableRequest createTableRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateTableResult>(){

            @Override
            public CreateTableResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.createTable(createTableRequest);
            }
        });
    }

    @Override
    public Future<CreateTableResult> createTableAsync(final CreateTableRequest createTableRequest, final AsyncHandler<CreateTableRequest, CreateTableResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateTableResult>(){

            @Override
            public CreateTableResult call() throws Exception {
                CreateTableResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.createTable(createTableRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createTableRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBackupResult> deleteBackupAsync(final DeleteBackupRequest deleteBackupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteBackupResult>(){

            @Override
            public DeleteBackupResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.deleteBackup(deleteBackupRequest);
            }
        });
    }

    @Override
    public Future<DeleteBackupResult> deleteBackupAsync(final DeleteBackupRequest deleteBackupRequest, final AsyncHandler<DeleteBackupRequest, DeleteBackupResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteBackupResult>(){

            @Override
            public DeleteBackupResult call() throws Exception {
                DeleteBackupResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.deleteBackup(deleteBackupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteBackupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(final DeleteItemRequest deleteItemRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteItemResult>(){

            @Override
            public DeleteItemResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.deleteItem(deleteItemRequest);
            }
        });
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(final DeleteItemRequest deleteItemRequest, final AsyncHandler<DeleteItemRequest, DeleteItemResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteItemResult>(){

            @Override
            public DeleteItemResult call() throws Exception {
                DeleteItemResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.deleteItem(deleteItemRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteItemRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(final DeleteTableRequest deleteTableRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteTableResult>(){

            @Override
            public DeleteTableResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.deleteTable(deleteTableRequest);
            }
        });
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(final DeleteTableRequest deleteTableRequest, final AsyncHandler<DeleteTableRequest, DeleteTableResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteTableResult>(){

            @Override
            public DeleteTableResult call() throws Exception {
                DeleteTableResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.deleteTable(deleteTableRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteTableRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBackupResult> describeBackupAsync(final DescribeBackupRequest describeBackupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeBackupResult>(){

            @Override
            public DescribeBackupResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.describeBackup(describeBackupRequest);
            }
        });
    }

    @Override
    public Future<DescribeBackupResult> describeBackupAsync(final DescribeBackupRequest describeBackupRequest, final AsyncHandler<DescribeBackupRequest, DescribeBackupResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeBackupResult>(){

            @Override
            public DescribeBackupResult call() throws Exception {
                DescribeBackupResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.describeBackup(describeBackupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeBackupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeContinuousBackupsResult> describeContinuousBackupsAsync(final DescribeContinuousBackupsRequest describeContinuousBackupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeContinuousBackupsResult>(){

            @Override
            public DescribeContinuousBackupsResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.describeContinuousBackups(describeContinuousBackupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeContinuousBackupsResult> describeContinuousBackupsAsync(final DescribeContinuousBackupsRequest describeContinuousBackupsRequest, final AsyncHandler<DescribeContinuousBackupsRequest, DescribeContinuousBackupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeContinuousBackupsResult>(){

            @Override
            public DescribeContinuousBackupsResult call() throws Exception {
                DescribeContinuousBackupsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.describeContinuousBackups(describeContinuousBackupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeContinuousBackupsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeGlobalTableResult> describeGlobalTableAsync(final DescribeGlobalTableRequest describeGlobalTableRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeGlobalTableResult>(){

            @Override
            public DescribeGlobalTableResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.describeGlobalTable(describeGlobalTableRequest);
            }
        });
    }

    @Override
    public Future<DescribeGlobalTableResult> describeGlobalTableAsync(final DescribeGlobalTableRequest describeGlobalTableRequest, final AsyncHandler<DescribeGlobalTableRequest, DescribeGlobalTableResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeGlobalTableResult>(){

            @Override
            public DescribeGlobalTableResult call() throws Exception {
                DescribeGlobalTableResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.describeGlobalTable(describeGlobalTableRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeGlobalTableRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeGlobalTableSettingsResult> describeGlobalTableSettingsAsync(final DescribeGlobalTableSettingsRequest describeGlobalTableSettingsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeGlobalTableSettingsResult>(){

            @Override
            public DescribeGlobalTableSettingsResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.describeGlobalTableSettings(describeGlobalTableSettingsRequest);
            }
        });
    }

    @Override
    public Future<DescribeGlobalTableSettingsResult> describeGlobalTableSettingsAsync(final DescribeGlobalTableSettingsRequest describeGlobalTableSettingsRequest, final AsyncHandler<DescribeGlobalTableSettingsRequest, DescribeGlobalTableSettingsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeGlobalTableSettingsResult>(){

            @Override
            public DescribeGlobalTableSettingsResult call() throws Exception {
                DescribeGlobalTableSettingsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.describeGlobalTableSettings(describeGlobalTableSettingsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeGlobalTableSettingsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLimitsResult> describeLimitsAsync(final DescribeLimitsRequest describeLimitsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLimitsResult>(){

            @Override
            public DescribeLimitsResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.describeLimits(describeLimitsRequest);
            }
        });
    }

    @Override
    public Future<DescribeLimitsResult> describeLimitsAsync(final DescribeLimitsRequest describeLimitsRequest, final AsyncHandler<DescribeLimitsRequest, DescribeLimitsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLimitsResult>(){

            @Override
            public DescribeLimitsResult call() throws Exception {
                DescribeLimitsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.describeLimits(describeLimitsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeLimitsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(final DescribeTableRequest describeTableRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTableResult>(){

            @Override
            public DescribeTableResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.describeTable(describeTableRequest);
            }
        });
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(final DescribeTableRequest describeTableRequest, final AsyncHandler<DescribeTableRequest, DescribeTableResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTableResult>(){

            @Override
            public DescribeTableResult call() throws Exception {
                DescribeTableResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.describeTable(describeTableRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeTableRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTimeToLiveResult> describeTimeToLiveAsync(final DescribeTimeToLiveRequest describeTimeToLiveRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTimeToLiveResult>(){

            @Override
            public DescribeTimeToLiveResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.describeTimeToLive(describeTimeToLiveRequest);
            }
        });
    }

    @Override
    public Future<DescribeTimeToLiveResult> describeTimeToLiveAsync(final DescribeTimeToLiveRequest describeTimeToLiveRequest, final AsyncHandler<DescribeTimeToLiveRequest, DescribeTimeToLiveResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTimeToLiveResult>(){

            @Override
            public DescribeTimeToLiveResult call() throws Exception {
                DescribeTimeToLiveResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.describeTimeToLive(describeTimeToLiveRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeTimeToLiveRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetItemResult> getItemAsync(final GetItemRequest getItemRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetItemResult>(){

            @Override
            public GetItemResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.getItem(getItemRequest);
            }
        });
    }

    @Override
    public Future<GetItemResult> getItemAsync(final GetItemRequest getItemRequest, final AsyncHandler<GetItemRequest, GetItemResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetItemResult>(){

            @Override
            public GetItemResult call() throws Exception {
                GetItemResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.getItem(getItemRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getItemRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListBackupsResult> listBackupsAsync(final ListBackupsRequest listBackupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListBackupsResult>(){

            @Override
            public ListBackupsResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.listBackups(listBackupsRequest);
            }
        });
    }

    @Override
    public Future<ListBackupsResult> listBackupsAsync(final ListBackupsRequest listBackupsRequest, final AsyncHandler<ListBackupsRequest, ListBackupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListBackupsResult>(){

            @Override
            public ListBackupsResult call() throws Exception {
                ListBackupsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.listBackups(listBackupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listBackupsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListGlobalTablesResult> listGlobalTablesAsync(final ListGlobalTablesRequest listGlobalTablesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListGlobalTablesResult>(){

            @Override
            public ListGlobalTablesResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.listGlobalTables(listGlobalTablesRequest);
            }
        });
    }

    @Override
    public Future<ListGlobalTablesResult> listGlobalTablesAsync(final ListGlobalTablesRequest listGlobalTablesRequest, final AsyncHandler<ListGlobalTablesRequest, ListGlobalTablesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListGlobalTablesResult>(){

            @Override
            public ListGlobalTablesResult call() throws Exception {
                ListGlobalTablesResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.listGlobalTables(listGlobalTablesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listGlobalTablesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(final ListTablesRequest listTablesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTablesResult>(){

            @Override
            public ListTablesResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.listTables(listTablesRequest);
            }
        });
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(final ListTablesRequest listTablesRequest, final AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTablesResult>(){

            @Override
            public ListTablesResult call() throws Exception {
                ListTablesResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.listTables(listTablesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listTablesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsOfResourceResult> listTagsOfResourceAsync(final ListTagsOfResourceRequest listTagsOfResourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTagsOfResourceResult>(){

            @Override
            public ListTagsOfResourceResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.listTagsOfResource(listTagsOfResourceRequest);
            }
        });
    }

    @Override
    public Future<ListTagsOfResourceResult> listTagsOfResourceAsync(final ListTagsOfResourceRequest listTagsOfResourceRequest, final AsyncHandler<ListTagsOfResourceRequest, ListTagsOfResourceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTagsOfResourceResult>(){

            @Override
            public ListTagsOfResourceResult call() throws Exception {
                ListTagsOfResourceResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.listTagsOfResource(listTagsOfResourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listTagsOfResourceRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<PutItemResult> putItemAsync(final PutItemRequest putItemRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PutItemResult>(){

            @Override
            public PutItemResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.putItem(putItemRequest);
            }
        });
    }

    @Override
    public Future<PutItemResult> putItemAsync(final PutItemRequest putItemRequest, final AsyncHandler<PutItemRequest, PutItemResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PutItemResult>(){

            @Override
            public PutItemResult call() throws Exception {
                PutItemResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.putItem(putItemRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)putItemRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<QueryResult> queryAsync(final QueryRequest queryRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<QueryResult>(){

            @Override
            public QueryResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.query(queryRequest);
            }
        });
    }

    @Override
    public Future<QueryResult> queryAsync(final QueryRequest queryRequest, final AsyncHandler<QueryRequest, QueryResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<QueryResult>(){

            @Override
            public QueryResult call() throws Exception {
                QueryResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.query(queryRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)queryRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<RestoreTableFromBackupResult> restoreTableFromBackupAsync(final RestoreTableFromBackupRequest restoreTableFromBackupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RestoreTableFromBackupResult>(){

            @Override
            public RestoreTableFromBackupResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.restoreTableFromBackup(restoreTableFromBackupRequest);
            }
        });
    }

    @Override
    public Future<RestoreTableFromBackupResult> restoreTableFromBackupAsync(final RestoreTableFromBackupRequest restoreTableFromBackupRequest, final AsyncHandler<RestoreTableFromBackupRequest, RestoreTableFromBackupResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RestoreTableFromBackupResult>(){

            @Override
            public RestoreTableFromBackupResult call() throws Exception {
                RestoreTableFromBackupResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.restoreTableFromBackup(restoreTableFromBackupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)restoreTableFromBackupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<RestoreTableToPointInTimeResult> restoreTableToPointInTimeAsync(final RestoreTableToPointInTimeRequest restoreTableToPointInTimeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RestoreTableToPointInTimeResult>(){

            @Override
            public RestoreTableToPointInTimeResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.restoreTableToPointInTime(restoreTableToPointInTimeRequest);
            }
        });
    }

    @Override
    public Future<RestoreTableToPointInTimeResult> restoreTableToPointInTimeAsync(final RestoreTableToPointInTimeRequest restoreTableToPointInTimeRequest, final AsyncHandler<RestoreTableToPointInTimeRequest, RestoreTableToPointInTimeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RestoreTableToPointInTimeResult>(){

            @Override
            public RestoreTableToPointInTimeResult call() throws Exception {
                RestoreTableToPointInTimeResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.restoreTableToPointInTime(restoreTableToPointInTimeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)restoreTableToPointInTimeRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ScanResult> scanAsync(final ScanRequest scanRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ScanResult>(){

            @Override
            public ScanResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.scan(scanRequest);
            }
        });
    }

    @Override
    public Future<ScanResult> scanAsync(final ScanRequest scanRequest, final AsyncHandler<ScanRequest, ScanResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ScanResult>(){

            @Override
            public ScanResult call() throws Exception {
                ScanResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.scan(scanRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)scanRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> tagResourceAsync(final TagResourceRequest tagResourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonDynamoDBAsyncClient.this.tagResource(tagResourceRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> tagResourceAsync(final TagResourceRequest tagResourceRequest, final AsyncHandler<TagResourceRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonDynamoDBAsyncClient.this.tagResource(tagResourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)tagResourceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> untagResourceAsync(final UntagResourceRequest untagResourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonDynamoDBAsyncClient.this.untagResource(untagResourceRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> untagResourceAsync(final UntagResourceRequest untagResourceRequest, final AsyncHandler<UntagResourceRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonDynamoDBAsyncClient.this.untagResource(untagResourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)untagResourceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateContinuousBackupsResult> updateContinuousBackupsAsync(final UpdateContinuousBackupsRequest updateContinuousBackupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateContinuousBackupsResult>(){

            @Override
            public UpdateContinuousBackupsResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.updateContinuousBackups(updateContinuousBackupsRequest);
            }
        });
    }

    @Override
    public Future<UpdateContinuousBackupsResult> updateContinuousBackupsAsync(final UpdateContinuousBackupsRequest updateContinuousBackupsRequest, final AsyncHandler<UpdateContinuousBackupsRequest, UpdateContinuousBackupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateContinuousBackupsResult>(){

            @Override
            public UpdateContinuousBackupsResult call() throws Exception {
                UpdateContinuousBackupsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.updateContinuousBackups(updateContinuousBackupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateContinuousBackupsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateGlobalTableResult> updateGlobalTableAsync(final UpdateGlobalTableRequest updateGlobalTableRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateGlobalTableResult>(){

            @Override
            public UpdateGlobalTableResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.updateGlobalTable(updateGlobalTableRequest);
            }
        });
    }

    @Override
    public Future<UpdateGlobalTableResult> updateGlobalTableAsync(final UpdateGlobalTableRequest updateGlobalTableRequest, final AsyncHandler<UpdateGlobalTableRequest, UpdateGlobalTableResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateGlobalTableResult>(){

            @Override
            public UpdateGlobalTableResult call() throws Exception {
                UpdateGlobalTableResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.updateGlobalTable(updateGlobalTableRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateGlobalTableRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateGlobalTableSettingsResult> updateGlobalTableSettingsAsync(final UpdateGlobalTableSettingsRequest updateGlobalTableSettingsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateGlobalTableSettingsResult>(){

            @Override
            public UpdateGlobalTableSettingsResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.updateGlobalTableSettings(updateGlobalTableSettingsRequest);
            }
        });
    }

    @Override
    public Future<UpdateGlobalTableSettingsResult> updateGlobalTableSettingsAsync(final UpdateGlobalTableSettingsRequest updateGlobalTableSettingsRequest, final AsyncHandler<UpdateGlobalTableSettingsRequest, UpdateGlobalTableSettingsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateGlobalTableSettingsResult>(){

            @Override
            public UpdateGlobalTableSettingsResult call() throws Exception {
                UpdateGlobalTableSettingsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.updateGlobalTableSettings(updateGlobalTableSettingsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateGlobalTableSettingsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(final UpdateItemRequest updateItemRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateItemResult>(){

            @Override
            public UpdateItemResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.updateItem(updateItemRequest);
            }
        });
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(final UpdateItemRequest updateItemRequest, final AsyncHandler<UpdateItemRequest, UpdateItemResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateItemResult>(){

            @Override
            public UpdateItemResult call() throws Exception {
                UpdateItemResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.updateItem(updateItemRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateItemRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(final UpdateTableRequest updateTableRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateTableResult>(){

            @Override
            public UpdateTableResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.updateTable(updateTableRequest);
            }
        });
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(final UpdateTableRequest updateTableRequest, final AsyncHandler<UpdateTableRequest, UpdateTableResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateTableResult>(){

            @Override
            public UpdateTableResult call() throws Exception {
                UpdateTableResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.updateTable(updateTableRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateTableRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTimeToLiveResult> updateTimeToLiveAsync(final UpdateTimeToLiveRequest updateTimeToLiveRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateTimeToLiveResult>(){

            @Override
            public UpdateTimeToLiveResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.updateTimeToLive(updateTimeToLiveRequest);
            }
        });
    }

    @Override
    public Future<UpdateTimeToLiveResult> updateTimeToLiveAsync(final UpdateTimeToLiveRequest updateTimeToLiveRequest, final AsyncHandler<UpdateTimeToLiveRequest, UpdateTimeToLiveResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateTimeToLiveResult>(){

            @Override
            public UpdateTimeToLiveResult call() throws Exception {
                UpdateTimeToLiveResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.updateTimeToLive(updateTimeToLiveRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateTimeToLiveRequest, (Object)result);
                return result;
            }
        });
    }
}

