/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeDefinitionJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.GlobalSecondaryIndexDescriptionJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.KeySchemaElementJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.LocalSecondaryIndexDescriptionJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProvisionedThroughputDescriptionJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.StreamSpecificationJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class TableDescriptionJsonUnmarshaller
implements Unmarshaller<TableDescription, JsonUnmarshallerContext> {
    private static TableDescriptionJsonUnmarshaller instance;

    TableDescriptionJsonUnmarshaller() {
    }

    public TableDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        TableDescription tableDescription = new TableDescription();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("AttributeDefinitions")) {
                tableDescription.setAttributeDefinitions(new ListUnmarshaller((Unmarshaller)AttributeDefinitionJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("TableName")) {
                tableDescription.setTableName(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("KeySchema")) {
                tableDescription.setKeySchema(new ListUnmarshaller((Unmarshaller)KeySchemaElementJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("TableStatus")) {
                tableDescription.setTableStatus(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("CreationDateTime")) {
                tableDescription.setCreationDateTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("ProvisionedThroughput")) {
                tableDescription.setProvisionedThroughput(ProvisionedThroughputDescriptionJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("TableSizeBytes")) {
                tableDescription.setTableSizeBytes(SimpleTypeJsonUnmarshallers.LongJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("ItemCount")) {
                tableDescription.setItemCount(SimpleTypeJsonUnmarshallers.LongJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("TableArn")) {
                tableDescription.setTableArn(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("LocalSecondaryIndexes")) {
                tableDescription.setLocalSecondaryIndexes(new ListUnmarshaller((Unmarshaller)LocalSecondaryIndexDescriptionJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("GlobalSecondaryIndexes")) {
                tableDescription.setGlobalSecondaryIndexes(new ListUnmarshaller((Unmarshaller)GlobalSecondaryIndexDescriptionJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("StreamSpecification")) {
                tableDescription.setStreamSpecification(StreamSpecificationJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("LatestStreamLabel")) {
                tableDescription.setLatestStreamLabel(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("LatestStreamArn")) {
                tableDescription.setLatestStreamArn(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return tableDescription;
    }

    public static TableDescriptionJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TableDescriptionJsonUnmarshaller();
        }
        return instance;
    }
}

