/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;

public class CreateTableRequestMarshaller
implements Marshaller<Request<CreateTableRequest>, CreateTableRequest> {
    public Request<CreateTableRequest> marshall(CreateTableRequest createTableRequest) {
        if (createTableRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTableRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.CreateTable";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ProvisionedThroughput provisionedThroughput;
            ListWithAutoConstructFlag globalSecondaryIndexesList;
            ListWithAutoConstructFlag localSecondaryIndexesList;
            ListWithAutoConstructFlag keySchemaList;
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            ListWithAutoConstructFlag attributeDefinitionsList = (ListWithAutoConstructFlag)createTableRequest.getAttributeDefinitions();
            if (!(attributeDefinitionsList == null || attributeDefinitionsList.isAutoConstruct() && attributeDefinitionsList.isEmpty())) {
                jsonWriter.name("AttributeDefinitions");
                jsonWriter.beginArray();
                for (Object attributeDefinitionsListValue : attributeDefinitionsList) {
                    if (attributeDefinitionsListValue == null) continue;
                    jsonWriter.beginObject();
                    if (((AttributeDefinition)attributeDefinitionsListValue).getAttributeName() != null) {
                        jsonWriter.name("AttributeName").value(((AttributeDefinition)attributeDefinitionsListValue).getAttributeName());
                    }
                    if (((AttributeDefinition)attributeDefinitionsListValue).getAttributeType() != null) {
                        jsonWriter.name("AttributeType").value(((AttributeDefinition)attributeDefinitionsListValue).getAttributeType());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (createTableRequest.getTableName() != null) {
                jsonWriter.name("TableName").value(createTableRequest.getTableName());
            }
            if (!((keySchemaList = (ListWithAutoConstructFlag)createTableRequest.getKeySchema()) == null || keySchemaList.isAutoConstruct() && keySchemaList.isEmpty())) {
                jsonWriter.name("KeySchema");
                jsonWriter.beginArray();
                for (Object keySchemaListValue : keySchemaList) {
                    if (keySchemaListValue == null) continue;
                    jsonWriter.beginObject();
                    if (((KeySchemaElement)keySchemaListValue).getAttributeName() != null) {
                        jsonWriter.name("AttributeName").value(((KeySchemaElement)keySchemaListValue).getAttributeName());
                    }
                    if (((KeySchemaElement)keySchemaListValue).getKeyType() != null) {
                        jsonWriter.name("KeyType").value(((KeySchemaElement)keySchemaListValue).getKeyType());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (!((localSecondaryIndexesList = (ListWithAutoConstructFlag)createTableRequest.getLocalSecondaryIndexes()) == null || localSecondaryIndexesList.isAutoConstruct() && localSecondaryIndexesList.isEmpty())) {
                jsonWriter.name("LocalSecondaryIndexes");
                jsonWriter.beginArray();
                for (Object localSecondaryIndexesListValue : localSecondaryIndexesList) {
                    Projection projection;
                    ListWithAutoConstructFlag keySchema2List;
                    if (localSecondaryIndexesListValue == null) continue;
                    jsonWriter.beginObject();
                    if (((LocalSecondaryIndex)localSecondaryIndexesListValue).getIndexName() != null) {
                        jsonWriter.name("IndexName").value(((LocalSecondaryIndex)localSecondaryIndexesListValue).getIndexName());
                    }
                    if (!((keySchema2List = (ListWithAutoConstructFlag)((LocalSecondaryIndex)localSecondaryIndexesListValue).getKeySchema()) == null || keySchema2List.isAutoConstruct() && keySchema2List.isEmpty())) {
                        jsonWriter.name("KeySchema");
                        jsonWriter.beginArray();
                        for (KeySchemaElement keySchema2ListValue : keySchema2List) {
                            if (keySchema2ListValue == null) continue;
                            jsonWriter.beginObject();
                            if (keySchema2ListValue.getAttributeName() != null) {
                                jsonWriter.name("AttributeName").value(keySchema2ListValue.getAttributeName());
                            }
                            if (keySchema2ListValue.getKeyType() != null) {
                                jsonWriter.name("KeyType").value(keySchema2ListValue.getKeyType());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if ((projection = ((LocalSecondaryIndex)localSecondaryIndexesListValue).getProjection()) != null) {
                        Object nonKeyAttributesList;
                        jsonWriter.name("Projection");
                        jsonWriter.beginObject();
                        if (projection.getProjectionType() != null) {
                            jsonWriter.name("ProjectionType").value(projection.getProjectionType());
                        }
                        if (!((nonKeyAttributesList = (ListWithAutoConstructFlag)projection.getNonKeyAttributes()) == null || nonKeyAttributesList.isAutoConstruct() && nonKeyAttributesList.isEmpty())) {
                            jsonWriter.name("NonKeyAttributes");
                            jsonWriter.beginArray();
                            Iterator iterator = nonKeyAttributesList.iterator();
                            while (iterator.hasNext()) {
                                String nonKeyAttributesListValue = (String)iterator.next();
                                if (nonKeyAttributesListValue == null) continue;
                                jsonWriter.value(nonKeyAttributesListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (!((globalSecondaryIndexesList = (ListWithAutoConstructFlag)createTableRequest.getGlobalSecondaryIndexes()) == null || globalSecondaryIndexesList.isAutoConstruct() && globalSecondaryIndexesList.isEmpty())) {
                jsonWriter.name("GlobalSecondaryIndexes");
                jsonWriter.beginArray();
                for (GlobalSecondaryIndex globalSecondaryIndexesListValue : globalSecondaryIndexesList) {
                    ProvisionedThroughput provisionedThroughput2;
                    Projection projection;
                    ListWithAutoConstructFlag keySchema2List;
                    if (globalSecondaryIndexesListValue == null) continue;
                    jsonWriter.beginObject();
                    if (globalSecondaryIndexesListValue.getIndexName() != null) {
                        jsonWriter.name("IndexName").value(globalSecondaryIndexesListValue.getIndexName());
                    }
                    if (!((keySchema2List = (ListWithAutoConstructFlag)globalSecondaryIndexesListValue.getKeySchema()) == null || keySchema2List.isAutoConstruct() && keySchema2List.isEmpty())) {
                        jsonWriter.name("KeySchema");
                        jsonWriter.beginArray();
                        for (KeySchemaElement keySchema2ListValue : keySchema2List) {
                            if (keySchema2ListValue == null) continue;
                            jsonWriter.beginObject();
                            if (keySchema2ListValue.getAttributeName() != null) {
                                jsonWriter.name("AttributeName").value(keySchema2ListValue.getAttributeName());
                            }
                            if (keySchema2ListValue.getKeyType() != null) {
                                jsonWriter.name("KeyType").value(keySchema2ListValue.getKeyType());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if ((projection = globalSecondaryIndexesListValue.getProjection()) != null) {
                        ListWithAutoConstructFlag nonKeyAttributesList;
                        jsonWriter.name("Projection");
                        jsonWriter.beginObject();
                        if (projection.getProjectionType() != null) {
                            jsonWriter.name("ProjectionType").value(projection.getProjectionType());
                        }
                        if (!((nonKeyAttributesList = (ListWithAutoConstructFlag)projection.getNonKeyAttributes()) == null || nonKeyAttributesList.isAutoConstruct() && nonKeyAttributesList.isEmpty())) {
                            jsonWriter.name("NonKeyAttributes");
                            jsonWriter.beginArray();
                            for (String nonKeyAttributesListValue : nonKeyAttributesList) {
                                if (nonKeyAttributesListValue == null) continue;
                                jsonWriter.value(nonKeyAttributesListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    if ((provisionedThroughput2 = globalSecondaryIndexesListValue.getProvisionedThroughput()) != null) {
                        jsonWriter.name("ProvisionedThroughput");
                        jsonWriter.beginObject();
                        if (provisionedThroughput2.getReadCapacityUnits() != null) {
                            jsonWriter.name("ReadCapacityUnits").value((Number)provisionedThroughput2.getReadCapacityUnits());
                        }
                        if (provisionedThroughput2.getWriteCapacityUnits() != null) {
                            jsonWriter.name("WriteCapacityUnits").value((Number)provisionedThroughput2.getWriteCapacityUnits());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if ((provisionedThroughput = createTableRequest.getProvisionedThroughput()) != null) {
                jsonWriter.name("ProvisionedThroughput");
                jsonWriter.beginObject();
                if (provisionedThroughput.getReadCapacityUnits() != null) {
                    jsonWriter.name("ReadCapacityUnits").value((Number)provisionedThroughput.getReadCapacityUnits());
                }
                if (provisionedThroughput.getWriteCapacityUnits() != null) {
                    jsonWriter.name("WriteCapacityUnits").value((Number)provisionedThroughput.getWriteCapacityUnits());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

