/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class ScanRequestMarshaller
implements Marshaller<Request<ScanRequest>, ScanRequest> {
    public Request<ScanRequest> marshall(ScanRequest scanRequest) {
        if (scanRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)scanRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.Scan";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag attributesToGetList;
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (scanRequest.getTableName() != null) {
                jsonWriter.name("TableName").value(scanRequest.getTableName());
            }
            if (scanRequest.getIndexName() != null) {
                jsonWriter.name("IndexName").value(scanRequest.getIndexName());
            }
            if (!((attributesToGetList = (ListWithAutoConstructFlag)scanRequest.getAttributesToGet()) == null || attributesToGetList.isAutoConstruct() && attributesToGetList.isEmpty())) {
                jsonWriter.name("AttributesToGet");
                jsonWriter.beginArray();
                for (String string : attributesToGetList) {
                    if (string == null) continue;
                    jsonWriter.value(string);
                }
                jsonWriter.endArray();
            }
            if (scanRequest.getLimit() != null) {
                jsonWriter.name("Limit").value((Number)scanRequest.getLimit());
            }
            if (scanRequest.getSelect() != null) {
                jsonWriter.name("Select").value(scanRequest.getSelect());
            }
            if (scanRequest.getScanFilter() != null) {
                jsonWriter.name("ScanFilter");
                jsonWriter.beginObject();
                for (Map.Entry<String, Condition> entry : scanRequest.getScanFilter().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.name(entry.getKey());
                    jsonWriter.beginObject();
                    ListWithAutoConstructFlag attributeValueListList = (ListWithAutoConstructFlag)entry.getValue().getAttributeValueList();
                    if (!(attributeValueListList == null || attributeValueListList.isAutoConstruct() && attributeValueListList.isEmpty())) {
                        jsonWriter.name("AttributeValueList");
                        jsonWriter.beginArray();
                        for (AttributeValue attributeValueListListValue : attributeValueListList) {
                            if (attributeValueListListValue == null) continue;
                            AttributeValueJsonMarshaller.getInstance().marshall(attributeValueListListValue, jsonWriter);
                        }
                        jsonWriter.endArray();
                    }
                    if (entry.getValue().getComparisonOperator() != null) {
                        jsonWriter.name("ComparisonOperator").value(entry.getValue().getComparisonOperator());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (scanRequest.getConditionalOperator() != null) {
                jsonWriter.name("ConditionalOperator").value(scanRequest.getConditionalOperator());
            }
            if (scanRequest.getExclusiveStartKey() != null) {
                jsonWriter.name("ExclusiveStartKey");
                jsonWriter.beginObject();
                for (Map.Entry<String, Serializable> entry : scanRequest.getExclusiveStartKey().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.name(entry.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall((AttributeValue)entry.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (scanRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.name("ReturnConsumedCapacity").value(scanRequest.getReturnConsumedCapacity());
            }
            if (scanRequest.getTotalSegments() != null) {
                jsonWriter.name("TotalSegments").value((Number)scanRequest.getTotalSegments());
            }
            if (scanRequest.getSegment() != null) {
                jsonWriter.name("Segment").value((Number)scanRequest.getSegment());
            }
            if (scanRequest.getProjectionExpression() != null) {
                jsonWriter.name("ProjectionExpression").value(scanRequest.getProjectionExpression());
            }
            if (scanRequest.getFilterExpression() != null) {
                jsonWriter.name("FilterExpression").value(scanRequest.getFilterExpression());
            }
            if (scanRequest.getExpressionAttributeNames() != null) {
                jsonWriter.name("ExpressionAttributeNames");
                jsonWriter.beginObject();
                for (Map.Entry<String, Object> entry : scanRequest.getExpressionAttributeNames().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.name(entry.getKey());
                    jsonWriter.value((String)entry.getValue());
                }
                jsonWriter.endObject();
            }
            if (scanRequest.getExpressionAttributeValues() != null) {
                jsonWriter.name("ExpressionAttributeValues");
                jsonWriter.beginObject();
                for (Map.Entry<String, Object> entry : scanRequest.getExpressionAttributeValues().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.name(entry.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall((AttributeValue)entry.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (scanRequest.isConsistentRead() != null) {
                jsonWriter.name("ConsistentRead").value(scanRequest.isConsistentRead().booleanValue());
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] byArray = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

