/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class BatchGetItemRequestMarshaller
implements Marshaller<Request<BatchGetItemRequest>, BatchGetItemRequest> {
    public Request<BatchGetItemRequest> marshall(BatchGetItemRequest batchGetItemRequest) {
        if (batchGetItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)batchGetItemRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.BatchGetItem";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (batchGetItemRequest.getRequestItems() != null) {
                jsonWriter.name("RequestItems");
                jsonWriter.beginObject();
                for (Map.Entry<String, KeysAndAttributes> requestItemsListValue : batchGetItemRequest.getRequestItems().entrySet()) {
                    ListWithAutoConstructFlag attributesToGetList;
                    if (requestItemsListValue.getValue() == null) continue;
                    jsonWriter.name(requestItemsListValue.getKey());
                    jsonWriter.beginObject();
                    ListWithAutoConstructFlag keysList = (ListWithAutoConstructFlag)requestItemsListValue.getValue().getKeys();
                    if (!(keysList == null || keysList.isAutoConstruct() && keysList.isEmpty())) {
                        jsonWriter.name("Keys");
                        jsonWriter.beginArray();
                        for (Map keysListValue : keysList) {
                            if (keysListValue == null) continue;
                            jsonWriter.beginObject();
                            for (Map.Entry memberListValue : keysListValue.entrySet()) {
                                if (memberListValue.getValue() == null) continue;
                                jsonWriter.name((String)memberListValue.getKey());
                                AttributeValueJsonMarshaller.getInstance().marshall((AttributeValue)memberListValue.getValue(), jsonWriter);
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (!((attributesToGetList = (ListWithAutoConstructFlag)requestItemsListValue.getValue().getAttributesToGet()) == null || attributesToGetList.isAutoConstruct() && attributesToGetList.isEmpty())) {
                        jsonWriter.name("AttributesToGet");
                        jsonWriter.beginArray();
                        for (String attributesToGetListValue : attributesToGetList) {
                            if (attributesToGetListValue == null) continue;
                            jsonWriter.value(attributesToGetListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (requestItemsListValue.getValue().isConsistentRead() != null) {
                        jsonWriter.name("ConsistentRead").value(requestItemsListValue.getValue().isConsistentRead().booleanValue());
                    }
                    if (requestItemsListValue.getValue().getProjectionExpression() != null) {
                        jsonWriter.name("ProjectionExpression").value(requestItemsListValue.getValue().getProjectionExpression());
                    }
                    if (requestItemsListValue.getValue().getExpressionAttributeNames() != null) {
                        jsonWriter.name("ExpressionAttributeNames");
                        jsonWriter.beginObject();
                        for (Map.Entry<String, String> expressionAttributeNamesListValue : requestItemsListValue.getValue().getExpressionAttributeNames().entrySet()) {
                            if (expressionAttributeNamesListValue.getValue() == null) continue;
                            jsonWriter.name(expressionAttributeNamesListValue.getKey());
                            jsonWriter.value(expressionAttributeNamesListValue.getValue());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (batchGetItemRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.name("ReturnConsumedCapacity").value(batchGetItemRequest.getReturnConsumedCapacity());
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

